/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.BlankDiffWindowUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diff/actions/BlankSwitchContentActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "perform", "editor", "Lcom/intellij/openapi/editor/Editor;", "viewer", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "helper", "Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;", "isEnabled", "", "currentContent", "Lcom/intellij/diff/contents/DiffContent;", "createNewContent", "project", "Lcom/intellij/openapi/project/Project;", "contextComponent", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
public abstract class BlankSwitchContentActionBase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        MutableDiffRequestChain.Helper helper = MutableDiffRequestChain.Companion.createHelper(dataContext);
        if (helper == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!Intrinsics.areEqual((Object)helper.getChain().getUserData(BlankDiffWindowUtil.INSTANCE.getBLANK_KEY()), (Object)true)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        FrameDiffTool.DiffViewer viewer = (FrameDiffTool.DiffViewer)e.getData(DiffDataKeys.DIFF_VIEWER);
        if (viewer instanceof TwosideTextDiffViewer) {
            Side side;
            List<? extends EditorEx> list = ((TwosideTextDiffViewer)viewer).getEditors();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEditors(...)");
            Side side2 = side = Side.Companion.fromValue(list, (Object)editor);
            DiffContent currentContent = side2 != null ? (DiffContent)side2.select((Object)helper.getChain().getContent1(), (Object)helper.getChain().getContent2()) : null;
            e.getPresentation().setEnabledAndVisible(currentContent != null && this.isEnabled(currentContent));
        } else if (viewer instanceof ThreesideTextDiffViewer) {
            ThreeSide side;
            List<? extends EditorEx> list = ((ThreesideTextDiffViewer)viewer).getEditors();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEditors(...)");
            ThreeSide threeSide = side = ThreeSide.Companion.fromValue(list, (Object)editor);
            DiffContent currentContent = threeSide != null ? (DiffContent)threeSide.select((Object)helper.getChain().getContent1(), (Object)helper.getChain().getBaseContent(), (Object)helper.getChain().getContent2()) : null;
            e.getPresentation().setEnabledAndVisible(currentContent != null && this.isEnabled(currentContent));
        } else if (viewer instanceof UnifiedDiffViewer) {
            Side side;
            int line = ((UnifiedDiffViewer)viewer).getEditor().getCaretModel().getLogicalPosition().line;
            Side side3 = side = (Side)((UnifiedDiffViewer)viewer).transferLineFromOneside((int)line).second;
            DiffContent currentContent = side3 != null ? (DiffContent)side3.select((Object)helper.getChain().getContent1(), (Object)helper.getChain().getContent2()) : null;
            e.getPresentation().setEnabledAndVisible(currentContent != null && this.isEnabled(currentContent));
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        FrameDiffTool.DiffViewer diffViewer = (FrameDiffTool.DiffViewer)e.getData(DiffDataKeys.DIFF_VIEWER);
        if (diffViewer == null) {
            return;
        }
        FrameDiffTool.DiffViewer viewer = diffViewer;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        MutableDiffRequestChain.Helper helper = MutableDiffRequestChain.Companion.createHelper(dataContext);
        if (helper == null) {
            return;
        }
        MutableDiffRequestChain.Helper helper2 = helper;
        this.perform(editor2, viewer, helper2);
    }

    public final void perform(@NotNull Editor editor, @NotNull FrameDiffTool.DiffViewer viewer, @NotNull MutableDiffRequestChain.Helper helper) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        FrameDiffTool.DiffViewer diffViewer = viewer;
        if (diffViewer instanceof TwosideTextDiffViewer) {
            List<? extends EditorEx> list = ((TwosideTextDiffViewer)viewer).getEditors();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEditors(...)");
            Side side = Side.Companion.fromValue(list, (Object)editor);
            if (side == null) {
                return;
            }
            Side side2 = side;
            Project project = ((TwosideTextDiffViewer)viewer).getProject();
            JComponent jComponent = ((TwosideTextDiffViewer)viewer).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            DiffContent diffContent = this.createNewContent(project, jComponent);
            if (diffContent == null) {
                return;
            }
            DiffContent newContent = diffContent;
            helper.setContent(newContent, side2);
        } else if (diffViewer instanceof ThreesideTextDiffViewer) {
            List<? extends EditorEx> list = ((ThreesideTextDiffViewer)viewer).getEditors();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEditors(...)");
            ThreeSide threeSide = ThreeSide.Companion.fromValue(list, (Object)editor);
            if (threeSide == null) {
                return;
            }
            ThreeSide side = threeSide;
            Project project = ((ThreesideTextDiffViewer)viewer).getProject();
            JComponent jComponent = ((ThreesideTextDiffViewer)viewer).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            DiffContent diffContent = this.createNewContent(project, jComponent);
            if (diffContent == null) {
                return;
            }
            DiffContent newContent = diffContent;
            helper.setContent(newContent, side);
        } else if (diffViewer instanceof UnifiedDiffViewer) {
            int line = ((UnifiedDiffViewer)viewer).getEditor().getCaretModel().getLogicalPosition().line;
            Side side = (Side)((UnifiedDiffViewer)viewer).transferLineFromOneside((int)line).second;
            Project project = ((UnifiedDiffViewer)viewer).getProject();
            JComponent jComponent = ((UnifiedDiffViewer)viewer).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            DiffContent diffContent = this.createNewContent(project, jComponent);
            if (diffContent == null) {
                return;
            }
            DiffContent newContent = diffContent;
            Intrinsics.checkNotNull((Object)side);
            helper.setContent(newContent, side);
        }
        helper.fireRequestUpdated();
    }

    public abstract boolean isEnabled(@NotNull DiffContent var1);

    @Nullable
    protected abstract DiffContent createNewContent(@Nullable Project var1, @NotNull JComponent var2);
}

