/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.CommonBundle;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.lang.DiffLanguage;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestProcessor<T>
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestProcessor.class);
    @NotNull
    private final SoftHardCacheMap<T, DiffRequest> myRequestCache;
    @NotNull
    private final DiffTaskQueue myQueue;
    @Nullable
    private T myQueuedProvider;
    private boolean myValidateQueuedProvider;

    public CacheDiffRequestProcessor(@Nullable Project project) {
        super(project);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
        this.myQueuedProvider = null;
        this.myValidateQueuedProvider = false;
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull String place) {
        if (place == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        super(project, place);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
        this.myQueuedProvider = null;
        this.myValidateQueuedProvider = false;
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        if (context == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, context);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
        this.myQueuedProvider = null;
        this.myValidateQueuedProvider = false;
    }

    @Nls
    @Nullable
    protected abstract String getRequestName(@NotNull T var1);

    protected abstract T getCurrentRequestProvider();

    @RequiresBackgroundThread
    @NotNull
    protected abstract DiffRequest loadRequest(@NotNull T var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException, DiffRequestProducerException;

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void updateRequest(boolean bl, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        void scrollToChangePolicy;
        void force;
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRequest((boolean)force, true, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRequest(boolean bl, boolean bl2, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        void useCache;
        DiffRequest cachedRequest;
        void scrollToChangePolicy;
        void force;
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        T requestProvider = this.getCurrentRequestProvider();
        if (requestProvider == null) {
            this.myQueue.abort();
            this.finishUpdate((DiffRequest)NoDiffRequest.INSTANCE, (boolean)force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy);
            return;
        }
        DiffRequest diffRequest = cachedRequest = useCache != false ? this.loadRequestFast(requestProvider) : null;
        if (cachedRequest != null) {
            this.myQueue.abort();
            this.finishUpdate(cachedRequest, (boolean)force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy);
            return;
        }
        if (useCache != false && force == false && Objects.equals(this.myQueuedProvider, requestProvider)) {
            this.myValidateQueuedProvider = true;
            return;
        }
        this.myQueuedProvider = requestProvider;
        this.myValidateQueuedProvider = false;
        this.myQueue.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)arg_0 -> this.lambda$updateRequest$2(requestProvider, (boolean)force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy, arg_0)), () -> this.lambda$updateRequest$3(requestProvider, (boolean)force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy), this.getFastLoadingTimeMillis());
    }

    @RequiresEdt
    private void finishRequestLoading(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy, @NotNull T requestProvider) {
        if (request == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        if (requestProvider == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean shouldValidate = this.myValidateQueuedProvider;
        this.myRequestCache.put(requestProvider, request);
        this.finishUpdate(request, force, scrollToChangePolicy);
        if (shouldValidate) {
            this.updateRequest();
        }
    }

    @RequiresEdt
    private void finishUpdate(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myQueuedProvider = null;
        this.myValidateQueuedProvider = false;
        this.applyRequest(request, force, scrollToChangePolicy);
    }

    protected long getFastLoadingTimeMillis() {
        return 300L;
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull T provider) {
        if (provider == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return this.myRequestCache.get(provider);
    }

    @NotNull
    private DiffRequest doLoadRequest(@NotNull T provider, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (provider == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(7);
        }
        String name = this.getRequestName(provider);
        try {
            diffRequest = this.loadRequest(provider, indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(name);
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(provider)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request;
            if (operationCanceledDiffRequest == null) {
                CacheDiffRequestProcessor.$$$reportNull$$$0(9);
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e) {
            return new ErrorDiffRequest(name, (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return new ErrorDiffRequest(name, (Throwable)e);
        }
        if (diffRequest == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(8);
        }
        return diffRequest;
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    protected void dropCaches() {
        this.myRequestCache.clear();
    }

    private /* synthetic */ void lambda$updateRequest$3(Object requestProvider, boolean force, DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest((DiffRequest)new LoadingDiffRequest(this.getRequestName(requestProvider)), force, scrollToChangePolicy);
    }

    private /* synthetic */ Runnable lambda$updateRequest$2(Object requestProvider, boolean force, DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy, ProgressIndicator indicator) {
        DiffRequest request = this.doLoadRequest(requestProvider, indicator);
        if (request instanceof ContentDiffRequest) {
            ContentDiffRequest contentDiffRequest = (ContentDiffRequest)request;
            contentDiffRequest.getContents().forEach(content -> DiffLanguage.computeAndCacheLanguage(content, this.getProject()));
        }
        return () -> this.finishRequestLoading(request, force, scrollToChangePolicy, requestProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "finishRequestLoading";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "finishUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestFast";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doLoadRequest";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final T myProducer;

        public ReloadRequestAction(T provider) {
            if (provider == null) {
                ReloadRequestAction.$$$reportNull$$$0(0);
            }
            super(CommonBundle.message((String)"action.text.reload", (Object[])new Object[0]), null, AllIcons.Actions.Refresh);
            this.myProducer = provider;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadRequestAction.$$$reportNull$$$0(1);
            }
            CacheDiffRequestProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestProcessor.this.updateRequest(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor$ReloadRequestAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Simple
    extends CacheDiffRequestProcessor<DiffRequestProducer> {
        protected Simple(@Nullable Project project) {
            super(project);
        }

        protected Simple(@Nullable Project project, @NotNull String place) {
            if (place == null) {
                Simple.$$$reportNull$$$0(0);
            }
            super(project, place);
        }

        protected Simple(@Nullable Project project, @NotNull UserDataHolder context) {
            if (context == null) {
                Simple.$$$reportNull$$$0(1);
            }
            super(project, context);
        }

        @Override
        @Nullable
        protected String getRequestName(@NotNull DiffRequestProducer provider) {
            if (provider == null) {
                Simple.$$$reportNull$$$0(2);
            }
            return provider.getName();
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull DiffRequestProducer provider, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            if (provider == null) {
                Simple.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                Simple.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = provider.process((UserDataHolder)this.getContext(), indicator);
            if (diffRequest == null) {
                Simple.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestProcessor$Simple";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor$Simple";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

