/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl.ui;

import com.intellij.diff.impl.ui.SplitBySeparatorKeepFileNamePolicy;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/impl/ui/DiffFilePathLabel;", "Lcom/intellij/ui/components/JBLabel;", "path", "", "fullPath", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "setSize", "", "d", "Ljava/awt/Dimension;", "validate", "invalidate", "revalidate", "intellij.platform.diff.impl"})
final class DiffFilePathLabel
extends JBLabel {
    @NotNull
    private final File file;

    public DiffFilePathLabel(@NotNull String path, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        this.file = new File(path);
        this.setAllowAutoWrapping(true);
        this.setCopyable(true);
        this.setToolTipText(XmlStringUtil.escapeString((String)fullPath));
        this.setForeground(UIUtil.getContextHelpForeground());
    }

    public void setSize(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        super.setSize(d);
        this.setText(XmlStringUtil.escapeString((String)SplitBySeparatorKeepFileNamePolicy.INSTANCE.getOptimalTextForComponent(this.file, (JComponent)((Object)this), d.width)));
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }
}

