/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    protected final MergeThreesideViewer myViewer;
    private final Action myCancelResolveAction;
    private final Action myLeftResolveAction;
    private final Action myRightResolveAction;
    private final Action myAcceptResolveAction;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
        if (context == null) {
            TextMergeViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TextMergeViewer.$$$reportNull$$$0(1);
        }
        this.myMergeContext = context;
        this.myMergeRequest = request;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        ProxySimpleDiffRequest diffRequest = new ProxySimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest), (UserDataHolder)this.myMergeRequest);
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = this.loadThreeSideViewer(diffContext, (ContentDiffRequest)diffRequest, this.myMergeContext, this.myMergeRequest, this);
        this.myCancelResolveAction = this.myViewer.getLoadedResolveAction(MergeResult.CANCEL);
        this.myLeftResolveAction = this.myViewer.getLoadedResolveAction(MergeResult.LEFT);
        this.myRightResolveAction = this.myViewer.getLoadedResolveAction(MergeResult.RIGHT);
        this.myAcceptResolveAction = this.myViewer.getLoadedResolveAction(MergeResult.RESOLVED);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(2);
        }
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output = mergeRequest.getOutputContent();
        List<DiffContent> list = Arrays.asList(left, output, right);
        if (list == null) {
            TextMergeViewer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(4);
        }
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
        List<String> list = titles;
        if (list == null) {
            TextMergeViewer.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            TextMergeViewer.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
        components.statusPanel = init2.statusPanel;
        components.toolbarActions = init2.toolbarActions;
        components.closeHandler = () -> {
            boolean exit = MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext, this.myViewer.isContentModified());
            this.myViewer.logMergeCancelled(this.myViewer.myContentModified, exit);
            return exit;
        };
        MergeTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            TextMergeViewer.$$$reportNull$$$0(7);
        }
        return toolbarComponents;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result) {
        if (result == null) {
            TextMergeViewer.$$$reportNull$$$0(8);
        }
        return switch (result) {
            default -> throw new MatchException(null, null);
            case MergeResult.CANCEL -> this.myCancelResolveAction;
            case MergeResult.LEFT -> this.myLeftResolveAction;
            case MergeResult.RIGHT -> this.myRightResolveAction;
            case MergeResult.RESOLVED -> this.myAcceptResolveAction;
        };
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MergeThreesideViewer getViewer() {
        MergeThreesideViewer mergeThreesideViewer = this.myViewer;
        if (mergeThreesideViewer == null) {
            TextMergeViewer.$$$reportNull$$$0(9);
        }
        return mergeThreesideViewer;
    }

    protected MergeThreesideViewer loadThreeSideViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull MergeContext mergeContext, @NotNull TextMergeRequest mergeRequest, @NotNull TextMergeViewer mergeViewer) {
        if (context == null) {
            TextMergeViewer.$$$reportNull$$$0(10);
        }
        if (request == null) {
            TextMergeViewer.$$$reportNull$$$0(11);
        }
        if (mergeContext == null) {
            TextMergeViewer.$$$reportNull$$$0(12);
        }
        if (mergeRequest == null) {
            TextMergeViewer.$$$reportNull$$$0(13);
        }
        if (mergeViewer == null) {
            TextMergeViewer.$$$reportNull$$$0(14);
        }
        return new MergeThreesideViewer(context, request, mergeContext, mergeRequest, mergeViewer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeRequest";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffContentTitles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContents";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffContentTitles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolveAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadThreeSideViewer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

