/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupServiceKt;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\u0015\u001a\u00020\u0007J*\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0003J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupService;", "", "<init>", "()V", "activePopupDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "buildAndShowPopup", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "mousePosition", "Ljava/awt/Point;", "builder", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "popupDisposable", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel;", "getNextPopupDisposable", "closeActivePopup", "showPopupAt", "panel", "showHint", "hint", "Lcom/intellij/ui/LightweightHint;", "point", "Companion", "intellij.platform.diff.impl"})
public final class LineStatusMarkerPopupService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CheckedDisposable activePopupDisposable;

    @RequiresEdt
    public final void buildAndShowPopup(@NotNull Disposable parentDisposable, @NotNull Editor editor, @Nullable Point mousePosition, @NotNull Function1<? super Disposable, ? extends LineStatusMarkerPopupPanel> builder) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        CheckedDisposable popupDisposable = this.getNextPopupDisposable(parentDisposable);
        LineStatusMarkerPopupPanel markerPopupPanel = (LineStatusMarkerPopupPanel)builder.invoke((Object)popupDisposable);
        this.showPopupAt(editor, markerPopupPanel, mousePosition, popupDisposable);
    }

    private final CheckedDisposable getNextPopupDisposable(Disposable parentDisposable) {
        this.closeActivePopup();
        CheckedDisposable checkedDisposable = this.activePopupDisposable = Disposer.newCheckedDisposable((Disposable)parentDisposable, (String)"LineStatusMarkerPopup");
        Intrinsics.checkNotNull((Object)checkedDisposable);
        return checkedDisposable;
    }

    public final void closeActivePopup() {
        if (this.activePopupDisposable != null) {
            CheckedDisposable checkedDisposable = this.activePopupDisposable;
            Intrinsics.checkNotNull((Object)checkedDisposable);
            Disposer.dispose((Disposable)((Disposable)checkedDisposable));
        }
    }

    @RequiresEdt
    private final void showPopupAt(Editor editor, LineStatusMarkerPopupPanel panel, Point mousePosition, CheckedDisposable popupDisposable) {
        if (popupDisposable.isDisposed()) {
            return;
        }
        LightweightHint hint = new LightweightHint((JComponent)panel);
        Disposer.register((Disposable)((Disposable)popupDisposable), () -> LineStatusMarkerPopupService.showPopupAt$lambda$0(hint));
        hint.addHintListener(arg_0 -> LineStatusMarkerPopupService.showPopupAt$lambda$1(popupDisposable, arg_0));
        hint.setForceLightweightPopup(true);
        panel.addMouseListener(new MouseAdapter(){});
        int line = editor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = editor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= panel.getEditorTextOffset();
        LineStatusMarkerPopupService.Companion.trackInnerEditorResizing(panel, hint, (Disposable)popupDisposable);
        LineStatusMarkerPopupService.Companion.setupEditorListeners(editor, (Disposable)popupDisposable);
        Intrinsics.checkNotNull((Object)point);
        this.showHint(hint, editor, point);
        if (!hint.isVisible()) {
            Disposer.dispose((Disposable)((Disposable)popupDisposable));
        }
    }

    private final void showHint(LightweightHint hint, Editor editor, Point point) {
        HintManagerImpl.doShowInGivenLocation((LightweightHint)hint, (Editor)editor, (Point)point, (HintHint)new HintHint(editor, point), (boolean)true);
    }

    private static final void showPopupAt$lambda$0(LightweightHint $hint) {
        UIUtil.invokeLaterIfNeeded(() -> LineStatusMarkerPopupService.showPopupAt$lambda$0$0($hint));
    }

    private static final void showPopupAt$lambda$0$0(LightweightHint $hint) {
        $hint.hide();
    }

    private static final void showPopupAt$lambda$1(CheckedDisposable $popupDisposable, EventObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Disposer.dispose((Disposable)((Disposable)$popupDisposable));
    }

    @NotNull
    public static final LineStatusMarkerPopupService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0017\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupService$Companion;", "", "<init>", "()V", "trackInnerEditorResizing", "", "panel", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel;", "hint", "Lcom/intellij/ui/LightweightHint;", "popupDisposable", "Lcom/intellij/openapi/Disposable;", "setupEditorListeners", "editor", "Lcom/intellij/openapi/editor/Editor;", "trackFileEditorChange", "trackDocumentChange", "trackSelection", "trackCaretPosition", "trackScrolling", "trackMouseClick", "trackEditorLookup", "trackLafChanging", "instance", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupService;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void trackInnerEditorResizing(LineStatusMarkerPopupPanel panel, LightweightHint hint, Disposable popupDisposable) {
            ComponentAdapter adapter2 = new ComponentAdapter(hint){
                final /* synthetic */ LightweightHint $hint;
                {
                    this.$hint = $hint;
                }

                public void componentResized(ComponentEvent e) {
                    this.$hint.pack();
                }
            };
            List componentsWithListener = new ArrayList();
            UIUtil.forEachComponentInHierarchy((Component)panel, arg_0 -> Companion.trackInnerEditorResizing$lambda$1(arg_0 -> Companion.trackInnerEditorResizing$lambda$0(componentsWithListener, adapter2, arg_0), arg_0));
            Disposer.register((Disposable)popupDisposable, () -> Companion.trackInnerEditorResizing$lambda$2(componentsWithListener, adapter2));
        }

        private final void setupEditorListeners(Editor editor, Disposable popupDisposable) {
            this.trackFileEditorChange(popupDisposable);
            this.trackDocumentChange(editor, popupDisposable);
            this.trackSelection(editor, popupDisposable);
            this.trackCaretPosition(editor, popupDisposable);
            this.trackScrolling(editor, popupDisposable);
            this.trackMouseClick(editor, popupDisposable);
            this.trackEditorLookup(editor, popupDisposable);
            this.trackLafChanging(popupDisposable);
        }

        private final void trackFileEditorChange(Disposable popupDisposable) {
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(popupDisposable);
            Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
            messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

                public void selectionChanged(FileEditorManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            });
        }

        private final void trackDocumentChange(Editor editor, Disposable popupDisposable) {
            editor.getDocument().addDocumentListener((DocumentListener)new BulkAwareDocumentListener(){

                public void documentChangedNonBulk(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getOldLength() != 0 || event.getNewLength() != 0) {
                        this.onDocumentChange();
                    }
                }

                public void bulkUpdateFinished(Document document) {
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    this.onDocumentChange();
                }

                public final void onDocumentChange() {
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            }, popupDisposable);
        }

        private final void trackSelection(Editor editor, Disposable popupDisposable) {
            editor.getSelectionModel().addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            }, popupDisposable);
        }

        private final void trackCaretPosition(Editor editor, Disposable popupDisposable) {
            editor.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(CaretEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            }, popupDisposable);
        }

        private final void trackScrolling(Editor editor, Disposable popupDisposable) {
            editor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

                public void visibleAreaChanged(VisibleAreaEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Rectangle old = e.getOldRectangle();
                    Rectangle rectangle = e.getNewRectangle();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getNewRectangle(...)");
                    Rectangle rectangle2 = rectangle;
                    if (old != null && old.x == rectangle2.x && old.y == rectangle2.y) {
                        return;
                    }
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            }, popupDisposable);
        }

        private final void trackMouseClick(Editor editor, Disposable popupDisposable) {
            editor.addEditorMouseListener(new EditorMouseListener(){

                public void mousePressed(EditorMouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                }
            }, popupDisposable);
        }

        private final void trackEditorLookup(Editor editor, Disposable popupDisposable) {
            Project project = editor.getProject();
            if (project != null) {
                LookupManager.hideActiveLookup((Project)project);
            }
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(popupDisposable);
            Topic topic = EditorHintListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new EditorHintListener(editor){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                }

                public void hintShown(Editor sourceEditor, LightweightHint editorHint, int flags, HintHint hintInfo) {
                    Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
                    Intrinsics.checkNotNullParameter((Object)editorHint, (String)"editorHint");
                    Intrinsics.checkNotNullParameter((Object)hintInfo, (String)"hintInfo");
                    if (sourceEditor != this.$editor) {
                        return;
                    }
                    if (editorHint instanceof Lookup) {
                        LineStatusMarkerPopupServiceKt.access$closeActivePopup();
                    }
                }
            });
        }

        private final void trackLafChanging(Disposable popupDisposable) {
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(popupDisposable);
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, Companion::trackLafChanging$lambda$0);
        }

        @NotNull
        public final LineStatusMarkerPopupService getInstance() {
            Object object = ApplicationManager.getApplication().getService(LineStatusMarkerPopupService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LineStatusMarkerPopupService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private static final Unit trackInnerEditorResizing$lambda$0(List $componentsWithListener, ComponentAdapter $adapter, Component c) {
            JComponent jComponent;
            Component component2 = c;
            if (component2 instanceof EditorTextComponent) {
                jComponent = ((EditorTextComponent)c).getComponent();
            } else if (component2 instanceof ActionToolbar) {
                jComponent = ((ActionToolbar)c).getComponent();
            } else {
                return Unit.INSTANCE;
            }
            JComponent component3 = jComponent;
            Intrinsics.checkNotNull((Object)component3);
            $componentsWithListener.add(component3);
            component3.addComponentListener($adapter);
            return Unit.INSTANCE;
        }

        private static final void trackInnerEditorResizing$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void trackInnerEditorResizing$lambda$2(List $componentsWithListener, ComponentAdapter $adapter) {
            for (JComponent component2 : $componentsWithListener) {
                component2.removeComponentListener($adapter);
            }
        }

        private static final void trackLafChanging$lambda$0(LafManager it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LineStatusMarkerPopupServiceKt.access$closeActivePopup();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

