/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u0082\u0001\u0003\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "", "<init>", "()V", "hasExcluded", "", "getHasExcluded", "()Z", "hasIncluded", "getHasIncluded", "Included", "Excluded", "Partial", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Excluded;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Included;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Partial;", "intellij.platform.diff.impl"})
public abstract sealed class RangeExclusionState {
    private RangeExclusionState() {
    }

    public abstract boolean getHasExcluded();

    public abstract boolean getHasIncluded();

    public /* synthetic */ RangeExclusionState(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Excluded;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "()V", "hasExcluded", "", "getHasExcluded", "()Z", "hasIncluded", "getHasIncluded", "intellij.platform.diff.impl"})
    public static final class Excluded
    extends RangeExclusionState {
        @NotNull
        public static final Excluded INSTANCE = new Excluded();
        private static final boolean hasExcluded = true;
        private static final boolean hasIncluded;

        private Excluded() {
            super(null);
        }

        @Override
        public boolean getHasExcluded() {
            return hasExcluded;
        }

        @Override
        public boolean getHasIncluded() {
            return hasIncluded;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Included;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "()V", "hasExcluded", "", "getHasExcluded", "()Z", "hasIncluded", "getHasIncluded", "intellij.platform.diff.impl"})
    public static final class Included
    extends RangeExclusionState {
        @NotNull
        public static final Included INSTANCE = new Included();
        private static final boolean hasExcluded;
        private static final boolean hasIncluded;

        private Included() {
            super(null);
        }

        @Override
        public boolean getHasExcluded() {
            return hasExcluded;
        }

        @Override
        public boolean getHasIncluded() {
            return hasIncluded;
        }

        static {
            hasIncluded = true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00180\u001cJ1\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00180\u001cJS\u0010!\u001a\u00020\u00182K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\"JS\u0010&\u001a\u00020\u00182K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\"J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007JH\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u000626\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180*H\u0002Je\u0010+\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00032K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\"H\u0002J\b\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000b\u00a8\u00060"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Partial;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "deletionsCount", "", "additionsCount", "includedDeletions", "Ljava/util/BitSet;", "includedAdditions", "<init>", "(IILjava/util/BitSet;Ljava/util/BitSet;)V", "getDeletionsCount", "()I", "getAdditionsCount", "hasExcluded", "", "getHasExcluded", "()Z", "hasIncluded", "getHasIncluded", "includedDeletionsCount", "getIncludedDeletionsCount", "includedAdditionsCount", "getIncludedAdditionsCount", "iterateIncludedDeletionRanges", "", "blockRange", "Lcom/intellij/diff/util/Range;", "consumer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "range", "iterateIncludedAdditionRanges", "iterateAdditionOffsets", "Lkotlin/Function3;", "start", "end", "isIncluded", "iterateDeletionOffsets", "copyIncludedInto", "iterateIncludedRanges", "set", "Lkotlin/Function2;", "iterateOffsets", "count", "toString", "", "validate", "intellij.platform.diff.impl"})
    @ApiStatus.Experimental
    @SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/RangeExclusionState$Partial\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1374:1\n13#2:1375\n13#2:1376\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/RangeExclusionState$Partial\n*L\n1269#1:1375\n1347#1:1376\n*E\n"})
    public static final class Partial
    extends RangeExclusionState {
        private final int deletionsCount;
        private final int additionsCount;
        @NotNull
        private final BitSet includedDeletions;
        @NotNull
        private final BitSet includedAdditions;

        public Partial(int deletionsCount, int additionsCount, @NotNull BitSet includedDeletions, @NotNull BitSet includedAdditions) {
            Intrinsics.checkNotNullParameter((Object)includedDeletions, (String)"includedDeletions");
            Intrinsics.checkNotNullParameter((Object)includedAdditions, (String)"includedAdditions");
            super(null);
            this.deletionsCount = deletionsCount;
            this.additionsCount = additionsCount;
            this.includedDeletions = includedDeletions;
            this.includedAdditions = includedAdditions;
            if (this.includedAdditions.length() > this.additionsCount || this.includedDeletions.length() > this.deletionsCount) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DocumentTracker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Invalid exclusion state: [" + this.includedDeletions + " - " + this.deletionsCount + "] [" + this.includedAdditions + " - " + this.additionsCount + "]");
            }
        }

        public final int getDeletionsCount() {
            return this.deletionsCount;
        }

        public final int getAdditionsCount() {
            return this.additionsCount;
        }

        @Override
        public boolean getHasExcluded() {
            return this.includedDeletions.nextClearBit(0) < this.deletionsCount || this.includedAdditions.nextClearBit(0) < this.additionsCount;
        }

        @Override
        public boolean getHasIncluded() {
            return !this.includedDeletions.isEmpty() || !this.includedAdditions.isEmpty();
        }

        public final int getIncludedDeletionsCount() {
            return this.includedDeletions.cardinality();
        }

        public final int getIncludedAdditionsCount() {
            return this.includedAdditions.cardinality();
        }

        public final void iterateIncludedDeletionRanges(@NotNull Range blockRange, @NotNull Function1<? super Range, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)blockRange, (String)"blockRange");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.iterateIncludedRanges(this.includedDeletions, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> Partial.iterateIncludedDeletionRanges$lambda$0(consumer, blockRange, arg_0, arg_1)));
        }

        public final void iterateIncludedAdditionRanges(@NotNull Range blockRange, @NotNull Function1<? super Range, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)blockRange, (String)"blockRange");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.iterateIncludedRanges(this.includedAdditions, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> Partial.iterateIncludedAdditionRanges$lambda$0(consumer, blockRange, arg_0, arg_1)));
        }

        public final void iterateAdditionOffsets(@NotNull Function3<? super Integer, ? super Integer, ? super Boolean, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.iterateOffsets(this.includedAdditions, this.additionsCount, consumer);
        }

        public final void iterateDeletionOffsets(@NotNull Function3<? super Integer, ? super Integer, ? super Boolean, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.iterateOffsets(this.includedDeletions, this.deletionsCount, consumer);
        }

        @ApiStatus.Internal
        public final void copyIncludedInto(@NotNull BitSet includedDeletions, @NotNull BitSet includedAdditions) {
            Intrinsics.checkNotNullParameter((Object)includedDeletions, (String)"includedDeletions");
            Intrinsics.checkNotNullParameter((Object)includedAdditions, (String)"includedAdditions");
            includedDeletions.or(this.includedDeletions);
            includedAdditions.or(this.includedAdditions);
        }

        private final void iterateIncludedRanges(BitSet set, Function2<? super Integer, ? super Integer, Unit> consumer) {
            int nextStart;
            int index = 0;
            while ((nextStart = set.nextSetBit(index)) != -1) {
                int nextEnd = set.nextClearBit(nextStart);
                consumer.invoke((Object)nextStart, (Object)nextEnd);
                index = nextEnd;
            }
        }

        private final void iterateOffsets(BitSet set, int count, Function3<? super Integer, ? super Integer, ? super Boolean, Unit> consumer) {
            int nextStart;
            int index = 0;
            while ((nextStart = set.nextSetBit(index)) != -1) {
                if (index < nextStart) {
                    consumer.invoke((Object)index, (Object)nextStart, (Object)false);
                }
                int nextEnd = set.nextClearBit(nextStart);
                consumer.invoke((Object)nextStart, (Object)nextEnd, (Object)true);
                index = nextEnd;
            }
            if (index < count) {
                consumer.invoke((Object)index, (Object)count, (Object)false);
            }
        }

        @NotNull
        public String toString() {
            return "RangeExclusionState.Partial(" + this.includedDeletions + " - " + this.includedAdditions + ")";
        }

        public final void validate(int deletionsCount, int additionsCount) {
            if (this.deletionsCount != deletionsCount || this.additionsCount != additionsCount) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DocumentTracker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Invalid exclusion state: [" + this.deletionsCount + " - " + this.deletionsCount + "] [" + deletionsCount + " - " + additionsCount + "]");
            }
        }

        private static final Unit iterateIncludedDeletionRanges$lambda$0(Function1 $consumer, Range $blockRange, int start, int end) {
            $consumer.invoke((Object)new Range($blockRange.start1 + start, $blockRange.start1 + end, $blockRange.start2, $blockRange.start2));
            return Unit.INSTANCE;
        }

        private static final Unit iterateIncludedAdditionRanges$lambda$0(Function1 $consumer, Range $blockRange, int start, int end) {
            $consumer.invoke((Object)new Range($blockRange.end1, $blockRange.end1, $blockRange.start2 + start, $blockRange.start2 + end));
            return Unit.INSTANCE;
        }
    }
}

