/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SyncHeightComponent
extends JPanel {
    private SyncHeightComponent(@NotNull SyncHeightHolder syncHeightHolder, @Nullable JComponent component2) {
        if (syncHeightHolder == null) {
            SyncHeightComponent.$$$reportNull$$$0(0);
        }
        super((LayoutManager)((Object)new SyncHeightLayout(syncHeightHolder, component2)));
        if (component2 != null) {
            this.add(component2);
        }
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            SyncHeightComponent.$$$reportNull$$$0(1);
        }
        if (!ContainerUtil.exists(components, (Condition)Conditions.notNull())) {
            List<JComponent> list = components;
            if (list == null) {
                SyncHeightComponent.$$$reportNull$$$0(2);
            }
            return list;
        }
        SyncHeightHolder syncHeightHolder = new SyncHeightHolder(components);
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (JComponent component2 : components) {
            result.add(new SyncHeightComponent(syncHeightHolder, component2));
        }
        ArrayList<JComponent> arrayList = result;
        if (arrayList == null) {
            SyncHeightComponent.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static void invalidateByChild(@NotNull JComponent component2) {
        SyncHeightComponent syncComponent;
        if (component2 == null) {
            SyncHeightComponent.$$$reportNull$$$0(4);
        }
        if ((syncComponent = (SyncHeightComponent)UIUtil.getParentOfType(SyncHeightComponent.class, (Component)component2)) == null) {
            return;
        }
        SyncHeightLayout syncHeightLayout = (SyncHeightLayout)((Object)ObjectUtils.tryCast((Object)syncComponent.getLayout(), SyncHeightLayout.class));
        if (syncHeightLayout == null) {
            return;
        }
        syncHeightLayout.getSyncHeightHolder().revalidateAll();
    }

    @NotNull
    private static Dimension getPreferredSize(@Nullable Component component2) {
        return component2 != null && component2.isVisible() ? component2.getPreferredSize() : new Dimension();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncHeightHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/SyncHeightComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/SyncHeightComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncHeightComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSyncHeightComponents";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invalidateByChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class SyncHeightLayout
    extends AbstractLayoutManager {
        @NotNull
        private final SyncHeightHolder mySyncHeightHolder;
        @Nullable
        private final JComponent myComponent;

        SyncHeightLayout(@NotNull SyncHeightHolder syncHeightHolder, @Nullable JComponent component2) {
            if (syncHeightHolder == null) {
                SyncHeightLayout.$$$reportNull$$$0(0);
            }
            this.mySyncHeightHolder = syncHeightHolder;
            this.myComponent = component2;
        }

        @NotNull
        private SyncHeightHolder getSyncHeightHolder() {
            SyncHeightHolder syncHeightHolder = this.mySyncHeightHolder;
            if (syncHeightHolder == null) {
                SyncHeightLayout.$$$reportNull$$$0(1);
            }
            return syncHeightHolder;
        }

        public Dimension preferredLayoutSize(Container parent) {
            int syncHeight = this.mySyncHeightHolder.preferredHeight();
            int width = SyncHeightComponent.getPreferredSize((Component)this.myComponent).width;
            return new Dimension(width, syncHeight);
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                SyncHeightLayout.$$$reportNull$$$0(2);
            }
            if (this.myComponent == null) {
                return;
            }
            Dimension preferredSize = SyncHeightComponent.getPreferredSize(this.myComponent);
            int width = parent.getWidth();
            int height = parent.getHeight();
            this.myComponent.setBounds(0, 0, width, Math.min(height, preferredSize.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "syncHeightHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/SyncHeightComponent$SyncHeightLayout";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/SyncHeightComponent$SyncHeightLayout";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSyncHeightHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "layoutContainer";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SyncHeightHolder {
        @NotNull
        private final List<? extends JComponent> mySyncComponents;
        private int myLastPreferredHeight;

        private SyncHeightHolder(@NotNull List<? extends JComponent> components) {
            if (components == null) {
                SyncHeightHolder.$$$reportNull$$$0(0);
            }
            this.mySyncComponents = components;
            this.myLastPreferredHeight = this.preferredHeight();
        }

        public int preferredHeight() {
            int totalHeight = 0;
            for (JComponent jComponent : this.mySyncComponents) {
                Dimension size = SyncHeightComponent.getPreferredSize(jComponent);
                totalHeight = Math.max(size.height, totalHeight);
            }
            if (this.myLastPreferredHeight != totalHeight) {
                this.myLastPreferredHeight = totalHeight;
                SwingUtilities.invokeLater(this::revalidateAll);
            }
            return totalHeight;
        }

        public void revalidateAll() {
            for (JComponent jComponent : this.mySyncComponents) {
                if (jComponent == null) continue;
                jComponent.revalidate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/SyncHeightComponent$SyncHeightHolder", "<init>"));
        }
    }
}

