/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.CommonBundle;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.actions.popup.WarnOnDeletion;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DirDiffTableModel
extends AbstractTableModel
implements DirDiffModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(DirDiffTableModel.class);
    public static final Key<JBLoadingPanel> DECORATOR_KEY = Key.create((String)"DIFF_TABLE_DECORATOR");
    public static final String EMPTY_STRING = StringUtil.repeatSymbol((char)' ', (int)50);
    @Nullable
    private final Project myProject;
    private final DirDiffSettings mySettings;
    protected DiffElement mySource;
    protected DiffElement myTarget;
    private DTree myTree;
    private DirDiffElement mySelectedSeparator;
    private final List<DirDiffElementImpl> myElements = new ArrayList<DirDiffElementImpl>();
    private final AtomicBoolean myUpdating = new AtomicBoolean(false);
    private JBTable myTable;
    private final AtomicReference<@Nls String> text = new AtomicReference<String>(DirDiffTableModel.prepareText(""));
    private volatile Updater myUpdater;
    private final List<DirDiffModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TableSelectionConfig mySelectionConfig;
    private final Map<String, BiMap<String, String>> mySourceToReplacingTarget = HashBiMap.create();
    private DirDiffPanel myPanel;
    private volatile boolean myDisposed;

    public DirDiffTableModel(@Nullable Project project, DiffElement<?> source, DiffElement<?> target, DirDiffSettings settings) {
        this.myProject = project;
        this.mySettings = settings;
        this.mySource = source;
        this.myTarget = target;
    }

    public void stopUpdating() {
        if (this.myUpdating.get()) {
            this.myUpdating.set(false);
        }
    }

    public void applyRemove() {
        int index;
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        this.myUpdating.set(true);
        this.myElements.removeIf(element -> switch (element.getType()) {
            default -> throw new MatchException(null, null);
            case DiffType.SOURCE -> {
                if (!this.mySettings.showNewOnSource) {
                    yield true;
                }
                yield false;
            }
            case DiffType.TARGET -> {
                if (!this.mySettings.showNewOnTarget) {
                    yield true;
                }
                yield false;
            }
            case DiffType.ERROR, DiffType.SEPARATOR -> false;
            case DiffType.CHANGED -> {
                if (!this.mySettings.showDifferent) {
                    yield true;
                }
                yield false;
            }
            case DiffType.EQUAL -> !this.mySettings.showEqual;
        });
        boolean sep = true;
        for (int j = this.myElements.size() - 1; j >= 0; --j) {
            if (this.myElements.get(j).isSeparator()) {
                if (sep) {
                    this.myElements.remove(j);
                    continue;
                }
                sep = true;
                continue;
            }
            sep = false;
        }
        this.fireTableDataChanged();
        this.myUpdating.set(false);
        if (!selectedElements.isEmpty() && (index = this.myElements.indexOf(selectedElements.get(0))) != -1) {
            this.myTable.getSelectionModel().setSelectionInterval(index, index);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        } else {
            this.selectFirstRow();
        }
        this.myPanel.update(true);
    }

    public void selectFirstRow() {
        if (!this.myElements.isEmpty()) {
            int row;
            int n = row = this.myElements.get(0).isSeparator() ? 1 : 0;
            if (row < this.myTable.getRowCount()) {
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
    }

    public void setPanel(DirDiffPanel panel) {
        this.myPanel = panel;
    }

    public void updateFromUI() {
        this.getSettings().setFilter(this.myPanel.getFilter());
        this.myPanel.update(false);
    }

    public boolean isOperationsEnabled() {
        return !this.myDisposed && this.mySettings.enableOperations && this.mySource.isOperationsEnabled() && this.myTarget.isOperationsEnabled();
    }

    public List<DirDiffElementImpl> getElements() {
        return this.myElements;
    }

    public void setReplacement(DirDiffElementImpl source, @Nullable DirDiffElementImpl target) {
        this.setReplacement(source.getParentNode().getPath(), source.getSourceName(), target == null ? null : target.getTargetName());
    }

    public void setReplacement(@NotNull String path, @Nullable String sourceName, @Nullable String targetName) {
        if (path == null) {
            DirDiffTableModel.$$$reportNull$$$0(0);
        }
        BiMap map = this.mySourceToReplacingTarget.computeIfAbsent(path, p -> HashBiMap.create());
        if (targetName != null) {
            map.forcePut((Object)sourceName, (Object)targetName);
        } else {
            map.remove((Object)sourceName);
        }
    }

    public String getReplacementName(DirDiffElementImpl source) {
        BiMap<String, String> map = this.mySourceToReplacingTarget.get(source.getParentNode().getPath());
        return map != null ? (String)map.get((Object)source.getSourceName()) : null;
    }

    @Nls
    private static String prepareText(String text) {
        int LEN = EMPTY_STRING.length();
        Object right = text == null ? EMPTY_STRING : (text.length() == LEN ? text : (text.length() < LEN ? text + EMPTY_STRING.substring(0, LEN - text.length()) : "..." + text.substring(text.length() - LEN + 2)));
        return DiffBundle.message((String)"label.dirdiff.loading.file", (Object[])new Object[]{right});
    }

    void fireUpdateStarted() {
        for (DirDiffModelListener listener : this.myListeners) {
            listener.updateStarted();
        }
    }

    void fireUpdateFinished() {
        for (DirDiffModelListener listener : this.myListeners) {
            listener.updateFinished();
        }
    }

    void addModelListener(DirDiffModelListener listener) {
        this.myListeners.add(listener);
    }

    public void reloadModel(boolean userForcedRefresh) {
        this.fireUpdateStarted();
        this.myUpdating.set(true);
        this.myTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
        JBLoadingPanel loadingPanel2 = this.getLoadingPanel();
        loadingPanel2.startLoading();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(modalityState);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                try {
                    if (this.myDisposed) {
                        return;
                    }
                    this.startAndSetUpdater(new Updater(loadingPanel2, 100));
                    this.text.set(CommonBundle.getLoadingTreeNodeText());
                    this.myTree = new DTree(null, "", true, null);
                    this.mySource.refresh(userForcedRefresh);
                    this.myTarget.refresh(userForcedRefresh);
                    this.scan(this.mySource, this.myTree, true);
                    this.scan(this.myTarget, this.myTree, false);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    this.reportException(DiffBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
                }
                finally {
                    if (this.myTree != null) {
                        this.myTree.setSource(this.mySource);
                        this.myTree.setTarget(this.myTarget);
                        this.myTree.update(this.mySettings);
                        ApplicationManager.getApplication().invokeLater(this::fireUpdateFinished, ModalityState.any());
                        this.applySettings();
                    }
                }
            }, (ProgressIndicator)indicator);
        });
    }

    public void reloadModelSynchronously() {
        this.myUpdating.set(true);
        try {
            this.fireUpdateStarted();
            this.myTree = new DTree(null, "", true, null);
            this.mySource.refresh(true);
            this.myTarget.refresh(true);
            this.scan(this.mySource, this.myTree, true);
            this.scan(this.myTarget, this.myTree, false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.reportException(DiffBundle.message((String)"refresh.failed.message", (Object[])new Object[]{StringUtil.decapitalize((String)e.getLocalizedMessage())}));
        }
        finally {
            this.myTree.setSource(this.mySource);
            this.myTree.setTarget(this.myTarget);
            this.myTree.update(this.mySettings);
            ArrayList elements = new ArrayList();
            this.fillElements(this.myTree, elements);
            this.myElements.clear();
            this.myElements.addAll(elements);
            this.myUpdating.set(false);
            this.fireUpdateFinished();
        }
    }

    protected void reportException(@Nullable @Nls String htmlContent) {
        if (this.myDisposed || htmlContent == null) {
            return;
        }
        Runnable balloonShower = () -> {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, null).setShowCallout(false).setHideOnClickOutside(true).setHideOnAction(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).createBalloon();
            Rectangle rect = this.myPanel.getPanel().getBounds();
            Point p = new Point(rect.x + rect.width - 100, rect.y + 50);
            RelativePoint point = new RelativePoint((Component)this.myPanel.getPanel(), p);
            balloon.show(point, Balloon.Position.below);
            Disposer.register((Disposable)(this.myProject != null ? this.myProject : ApplicationManager.getApplication()), (Disposable)balloon);
        };
        ApplicationManager.getApplication().invokeLater(balloonShower, o -> this.myProject != null && !this.myProject.isDefault() && !this.myProject.isOpen());
    }

    private JBLoadingPanel getLoadingPanel() {
        return (JBLoadingPanel)ComponentUtil.getClientProperty((JComponent)this.myTable, DECORATOR_KEY);
    }

    public void applySettings() {
        JBLoadingPanel loadingPanel2;
        if (!this.myUpdating.get()) {
            this.myUpdating.set(true);
        }
        if (!(loadingPanel2 = this.getLoadingPanel()).isLoading()) {
            loadingPanel2.startLoading();
            if (this.myUpdater == null) {
                this.startAndSetUpdater(new Updater(loadingPanel2, 100));
            }
        }
        Application app = ApplicationManager.getApplication();
        app.executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myTree.updateVisibility(this.mySettings);
            ArrayList elements = new ArrayList();
            this.fillElements(this.myTree, elements);
            Runnable uiThread = () -> {
                if (this.myDisposed) {
                    return;
                }
                this.clear();
                this.myElements.addAll(elements);
                this.myUpdating.set(false);
                this.fireTableDataChanged();
                this.text.set("");
                if (loadingPanel2.isLoading()) {
                    loadingPanel2.stopLoading();
                }
                if (this.mySelectionConfig == null) {
                    this.selectFirstRow();
                } else {
                    this.mySelectionConfig.restore();
                }
                this.myPanel.update(true);
            };
            if (this.myProject == null || this.myProject.isDefault()) {
                SwingUtilities.invokeLater(uiThread);
            } else {
                app.invokeLater(uiThread, ModalityState.any());
            }
        });
    }

    private void fillElements(DTree tree2, List<? super DirDiffElementImpl> elements) {
        if (!this.myUpdating.get()) {
            return;
        }
        boolean separatorAdded = tree2.getParent() == null;
        this.text.set(DirDiffTableModel.prepareText(tree2.getPath()));
        for (DTree child : tree2.getChildren()) {
            if (!this.myUpdating.get()) {
                return;
            }
            if (!child.isContainer()) {
                DiffType type;
                if (!child.isVisible()) continue;
                if (!separatorAdded) {
                    elements.add(DirDiffElementImpl.createDirElement(tree2, tree2.getSource(), tree2.getTarget(), tree2.getPath()));
                    separatorAdded = true;
                }
                if ((type = child.getType()) != null) {
                    switch (type) {
                        case SOURCE: {
                            elements.add(DirDiffElementImpl.createSourceOnly(child, child.getSource()));
                            break;
                        }
                        case TARGET: {
                            elements.add(DirDiffElementImpl.createTargetOnly(child, child.getTarget()));
                            break;
                        }
                        case CHANGED: {
                            elements.add(DirDiffElementImpl.createChange(child, child.getSource(), child.getTarget(), this.mySettings.customSourceChooser));
                            break;
                        }
                        case EQUAL: {
                            elements.add(DirDiffElementImpl.createEqual(child, child.getSource(), child.getTarget()));
                            break;
                        }
                        case ERROR: {
                            elements.add(DirDiffElementImpl.createError(child, child.getSource(), child.getTarget()));
                        }
                    }
                    continue;
                }
                LOG.error(String.format("Element's type is null [Name: %s, Container: %s, Source: %s, Target: %s] ", child.getName(), child.isContainer(), child.getSource(), child.getTarget()));
                continue;
            }
            this.fillElements(child, elements);
        }
    }

    public void clear() {
        if (!this.myElements.isEmpty()) {
            int size = this.myElements.size();
            this.myElements.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    private void scan(DiffElement<?> element, DTree root, boolean source) throws IOException {
        if (!this.myUpdating.get()) {
            return;
        }
        if (element.isContainer()) {
            DiffElement[] children;
            this.text.set(DirDiffTableModel.prepareText(element.getPath()));
            for (DiffElement child : children = element.getChildren()) {
                if (!this.myUpdating.get()) {
                    return;
                }
                this.text.set(DirDiffTableModel.prepareText(child.getPath()));
                BiMap<String, String> replacing = this.mySourceToReplacingTarget.get(root.getPath());
                String replacementName = replacing != null ? (source ? (String)replacing.get((Object)child.getName()) : (String)replacing.inverse().get((Object)child.getName())) : null;
                DTree el = root.addChild(child, source, replacementName);
                this.scan(child, el, source);
            }
        }
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        if (this.myDisposed) {
            return DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
        }
        if (this.mySource instanceof VirtualFileDiffElement && this.myTarget instanceof VirtualFileDiffElement) {
            VirtualFile srcFile = ((VirtualFileDiffElement)this.mySource).getValue();
            VirtualFile trgFile = ((VirtualFileDiffElement)this.myTarget).getValue();
            return DiffRequestFactory.getInstance().getTitleForComparison(srcFile, trgFile);
        }
        return IdeBundle.message((String)"diff.dialog.title", (Object[])new Object[]{this.mySource.getPresentablePath(), this.myTarget.getPresentablePath()});
    }

    @Nullable
    public DirDiffElementImpl getElementAt(int index) {
        return 0 <= index && index < this.myElements.size() ? this.myElements.get(index) : null;
    }

    public DiffElement getSourceDir() {
        return this.mySource;
    }

    public DiffElement getTargetDir() {
        return this.myTarget;
    }

    public void setSourceDir(DiffElement src) {
        this.mySource = src;
    }

    public void setTargetDir(DiffElement trg) {
        this.myTarget = trg;
    }

    @Override
    public int getRowCount() {
        return this.myElements.size();
    }

    @Override
    public int getColumnCount() {
        int count = 3;
        if (this.mySettings.showDate) {
            count += 2;
        }
        if (this.mySettings.showSize) {
            count += 2;
        }
        return count;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void setTable(JBTable table) {
        this.myTable = table;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            boolean isSrc;
            DirDiffElementImpl element = this.myElements.get(rowIndex);
            if (element.isSeparator()) {
                return columnIndex == 0 ? element.getName() : null;
            }
            ColumnType columnType = this.getColumnType(columnIndex);
            boolean bl = isSrc = columnIndex < this.getColumnCount() / 2;
            if (columnType == ColumnType.NAME) {
                return isSrc ? element.getSourcePresentableName() : element.getTargetPresentableName();
            }
            if (columnType == ColumnType.SIZE) {
                return isSrc ? element.getSourceSize() : element.getTargetSize();
            }
            if (columnType == ColumnType.DATE) {
                return isSrc ? element.getSourceModificationDate() : element.getTargetModificationDate();
            }
            return "";
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> {
                this.myElements.clear();
                this.fireTableDataChanged();
                this.myTable.getEmptyText().setText(DiffBundle.message((String)"data.has.been.changed.externally.reloading.data", (Object[])new Object[0]));
                this.reloadModel(true);
                this.myTable.repaint();
            });
            return "";
        }
    }

    public DirDiffElement getSelectedSeparator() {
        return this.mySelectedSeparator;
    }

    public List<DirDiffElementImpl> getSelectedElements() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>();
        for (int row : rows) {
            DirDiffElementImpl element = this.getElementAt(row);
            if (element == null || element.isSeparator()) continue;
            elements.add(element);
        }
        return elements;
    }

    @NotNull
    public ColumnType getColumnType(int column) {
        int count = (this.getColumnCount() - 1) / 2;
        if (column == count) {
            ColumnType columnType = ColumnType.OPERATION;
            if (columnType == null) {
                DirDiffTableModel.$$$reportNull$$$0(1);
            }
            return columnType;
        }
        if (column > count) {
            column = this.getColumnCount() - 1 - column;
        }
        ColumnType columnType = switch (column) {
            case 0 -> ColumnType.NAME;
            case 1 -> {
                if (this.mySettings.showSize) {
                    yield ColumnType.SIZE;
                }
                yield ColumnType.DATE;
            }
            case 2 -> ColumnType.DATE;
            default -> throw new IllegalArgumentException(String.valueOf(column));
        };
        if (columnType == null) {
            DirDiffTableModel.$$$reportNull$$$0(2);
        }
        return columnType;
    }

    @Override
    public String getColumnName(int column) {
        ColumnType type = this.getColumnType(column);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "*";
            case 1 -> DiffBundle.message((String)"column.dirdiff.name", (Object[])new Object[0]);
            case 2 -> DiffBundle.message((String)"column.dirdiff.size", (Object[])new Object[0]);
            case 3 -> DiffBundle.message((String)"column.dirdiff.date", (Object[])new Object[0]);
        };
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowEqual() {
        return this.mySettings.showEqual;
    }

    public void setShowEqual(boolean show) {
        this.mySettings.showEqual = show;
    }

    public boolean isShowDifferent() {
        return this.mySettings.showDifferent;
    }

    public void setShowDifferent(boolean show) {
        this.mySettings.showDifferent = show;
    }

    public boolean isShowNewOnSource() {
        return this.mySettings.showNewOnSource;
    }

    public void setShowNewOnSource(boolean show) {
        this.mySettings.showNewOnSource = show;
    }

    public boolean isShowNewOnTarget() {
        return this.mySettings.showNewOnTarget;
    }

    public void setShowNewOnTarget(boolean show) {
        this.mySettings.showNewOnTarget = show;
    }

    public void setSelectedSeparator(DirDiffElement selectedSeparator) {
        this.mySelectedSeparator = selectedSeparator;
    }

    public boolean isUpdating() {
        return this.myUpdating.get();
    }

    public DirDiffSettings.CompareMode getCompareMode() {
        return this.mySettings.compareMode;
    }

    public void setCompareMode(DirDiffSettings.CompareMode mode) {
        this.mySettings.compareMode = mode;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myListeners.clear();
        this.myElements.clear();
        this.mySource = null;
        this.myTarget = null;
        this.myTree = null;
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void performCopyTo(DirDiffElementImpl element) {
        DiffElement source = element.getSource();
        if (source != null) {
            String path = element.getParentNode().getPath();
            if (source instanceof AsyncDiffElement) {
                ((AsyncDiffElement)source).copyToAsync(this.myTarget, element.getTarget(), path).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> this.refreshAfterCopyTo(element, (DiffElement)newElement));
            } else {
                WriteAction.run(() -> {
                    DiffElement diffElement = source.copyTo(this.myTarget, path);
                    this.refreshElementAfterCopyTo(diffElement, element);
                });
            }
        }
    }

    protected void refreshAfterCopyTo(DirDiffElementImpl element, DiffElement newElement) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDisposed) {
            return;
        }
        if (newElement == null && element.getTarget() != null) {
            int row = this.myElements.indexOf(element);
            element.updateTargetData();
            this.fireTableRowsUpdated(row, row);
        }
        this.refreshElementAfterCopyTo(newElement, element);
    }

    protected void refreshElementAfterCopyTo(DiffElement<?> newElement, DirDiffElementImpl element) {
        if (newElement != null) {
            DTree node = element.getNode();
            node.setType(DiffType.EQUAL);
            node.setTarget(newElement);
            int row = this.myElements.indexOf(element);
            if (this.getSettings().showEqual) {
                element.updateSourceFromTarget(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element, false);
            }
        }
    }

    public void performCopyFrom(@NotNull DirDiffElementImpl element) {
        DiffElement target;
        if (element == null) {
            DirDiffTableModel.$$$reportNull$$$0(3);
        }
        if ((target = element.getTarget()) != null) {
            String path = element.getParentNode().getPath();
            if (target instanceof AsyncDiffElement) {
                ((AsyncDiffElement)target).copyToAsync(this.mySource, element.getSource(), path).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> this.refreshAfterCopyFrom(element, (DiffElement)newElement));
            } else {
                WriteAction.run(() -> {
                    DiffElement diffElement = target.copyTo(this.mySource, path);
                    this.refreshElementAfterCopyFrom(element, diffElement);
                });
            }
        }
    }

    protected void refreshAfterCopyFrom(@NotNull DirDiffElementImpl element, DiffElement newElement) {
        if (element == null) {
            DirDiffTableModel.$$$reportNull$$$0(4);
        }
        if (this.myDisposed) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.refreshElementAfterCopyFrom(element, newElement);
    }

    protected void refreshElementAfterCopyFrom(DirDiffElementImpl element, DiffElement<?> newElement) {
        if (newElement != null) {
            DTree node = element.getNode();
            node.setType(DiffType.EQUAL);
            node.setSource(newElement);
            int row = this.myElements.indexOf(element);
            if (this.getSettings().showEqual) {
                element.updateTargetFromSource(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element, false);
            }
        }
    }

    private void removeElement(DirDiffElementImpl element, boolean removeFromTree) {
        int row = this.myElements.indexOf(element);
        if (row != -1) {
            DTree node = element.getNode();
            if (removeFromTree) {
                DTree parentNode = element.getParentNode();
                parentNode.remove(node);
            }
            this.myElements.remove(row);
            int start = row;
            if (row > 0 && row == this.myElements.size() && this.myElements.get(row - 1).isSeparator() || row != this.myElements.size() && this.myElements.get(row).isSeparator() && row > 0 && this.myElements.get(row - 1).isSeparator()) {
                DirDiffElementImpl el = this.myElements.get(row - 1);
                if (removeFromTree) {
                    el.getParentNode().remove(el.getNode());
                }
                this.myElements.remove(row - 1);
                start = row - 1;
            }
            this.fireTableRowsDeleted(start, row);
        }
    }

    public void performDelete(@NotNull DirDiffElementImpl element) {
        if (element == null) {
            DirDiffTableModel.$$$reportNull$$$0(5);
        }
        DiffElement source = element.getSource();
        DiffElement target = element.getTarget();
        LOG.assertTrue(source == null || target == null);
        if (source instanceof AsyncDiffElement || target instanceof AsyncDiffElement) {
            ((AsyncDiffElement)(source != null ? source : target)).deleteAsync().onError(error -> this.reportException(error != null ? error.getMessage() : null)).onSuccess(result -> {
                if (!this.myDisposed && this.myElements.contains(element)) {
                    this.removeElement(element, true);
                }
            });
        } else {
            if (this.myElements.contains(element)) {
                this.removeElement(element, true);
            }
            WriteAction.run(() -> (source != null ? source : target).delete());
        }
    }

    public void synchronizeSelected() {
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        if (!this.checkCanDelete(selectedElements)) {
            return;
        }
        this.rememberSelection();
        this.sync(selectedElements);
        this.restoreSelection();
    }

    private void restoreSelection() {
        if (this.mySelectionConfig != null) {
            this.mySelectionConfig.restore();
        }
    }

    public void synchronizeAll() {
        ArrayList<DirDiffElementImpl> elements = new ArrayList<DirDiffElementImpl>(this.myElements);
        if (!this.checkCanDelete(elements)) {
            return;
        }
        this.sync(elements);
        this.selectFirstRow();
    }

    protected void sync(List<DirDiffElementImpl> elements) {
        for (DirDiffElementImpl element : elements) {
            this.syncElement(element);
        }
    }

    private boolean checkCanDelete(List<DirDiffElementImpl> elements) {
        if (WarnOnDeletion.isWarnWhenDeleteItems()) {
            int count = 0;
            for (DirDiffElementImpl element : elements) {
                if (element.getOperation() != DirDiffOperation.DELETE) continue;
                ++count;
            }
            if (count > 0 && !this.confirmDeletion(count)) {
                return false;
            }
        }
        return true;
    }

    private boolean confirmDeletion(int count) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"confirm.delete", (Object[])new Object[0]), (String)DiffBundle.message((String)"delete.0.items", (Object[])new Object[]{count})).yesText(CommonBundle.message((String)"button.delete", (Object[])new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(new DoNotAskOption(this){

            public boolean isToBeShown() {
                return WarnOnDeletion.isWarnWhenDeleteItems();
            }

            public void setToBeShown(boolean value, int exitCode) {
                WarnOnDeletion.setWarnWhenDeleteItems(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = DiffBundle.message((String)"do.not.ask.me.again", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/DirDiffTableModel$1", "getDoNotShowMessage"));
            }
        })).ask(this.myProject);
    }

    protected void syncElement(DirDiffElementImpl element) {
        DirDiffOperation operation = element.getOperation();
        if (operation == null) {
            return;
        }
        switch (operation) {
            case COPY_TO: {
                this.performCopyTo(element);
                break;
            }
            case COPY_FROM: {
                this.performCopyFrom(element);
                break;
            }
            case DELETE: {
                this.performDelete(element);
                break;
            }
        }
    }

    private void startAndSetUpdater(Updater updater) {
        updater.start();
        this.myUpdater = updater;
    }

    public void rememberSelection() {
        this.mySelectionConfig = new TableSelectionConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReplacement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performCopyFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAfterCopyFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performDelete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    class Updater
    extends Thread {
        private final JBLoadingPanel myLoadingPanel;
        private final int mySleep;

        Updater(JBLoadingPanel loadingPanel2, int sleep) {
            super("Loading Updater");
            this.myLoadingPanel = loadingPanel2;
            this.mySleep = sleep;
        }

        @Override
        public void run() {
            if (!DirDiffTableModel.this.myDisposed && this.myLoadingPanel.isLoading()) {
                TimeoutUtil.sleep((long)this.mySleep);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String s = DirDiffTableModel.this.text.get();
                    if (s != null && this.myLoadingPanel.isLoading()) {
                        this.myLoadingPanel.setLoadingText(s);
                    }
                }, ModalityState.stateForComponent((Component)this.myLoadingPanel));
                DirDiffTableModel.this.startAndSetUpdater(new Updater(this.myLoadingPanel, this.mySleep));
            } else {
                DirDiffTableModel.this.myUpdater = null;
            }
        }
    }

    public static enum ColumnType {
        OPERATION,
        NAME,
        SIZE,
        DATE;

    }

    public class TableSelectionConfig {
        private final int selectedRow;
        private final int rowCount;

        TableSelectionConfig() {
            this.selectedRow = DirDiffTableModel.this.myTable.getSelectedRow();
            this.rowCount = DirDiffTableModel.this.myTable.getRowCount();
        }

        void restore() {
            DirDiffElementImpl el;
            int newRowCount = DirDiffTableModel.this.myTable.getRowCount();
            if (newRowCount == 0) {
                return;
            }
            int row = Math.min(newRowCount < this.rowCount ? this.selectedRow : this.selectedRow + 1, newRowCount - 1);
            DirDiffElementImpl element = DirDiffTableModel.this.getElementAt(row);
            if (element != null && element.isSeparator()) {
                row = DirDiffTableModel.this.getElementAt(row + 1) != null ? ++row : --row;
            }
            row = (el = DirDiffTableModel.this.getElementAt(row)) == null || el.isSeparator() ? 0 : row;
            DirDiffTableModel.this.myTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible((JTable)DirDiffTableModel.this.myTable);
        }
    }
}

