/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.editor.DiffEditorEscapeAction;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffEditorViewerFileEditor;
import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.diff.editor.DiffVirtualFileWithProducers;
import com.intellij.diff.editor.DiffVirtualFileWithTabName;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002()B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH$J\u001a\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\nH$J\u0019\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH$J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\u0018H\u0014J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "hasContent", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "_isDisposed", "isDisposed", "dispose", "", "previewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPreviewFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isPreviewOpen", "closePreview", "openPreview", "requestFocus", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performDiffAction", "handleEscapeKey", "createEscapeHandler", "Lcom/intellij/openapi/actionSystem/AnAction;", "TabPreviewDiffVirtualFile", "DiffEditorPreviewEscapeAction", "intellij.platform.diff.impl"})
public abstract class EditorTabDiffPreview
implements CheckedDisposable,
DiffPreview {
    @NotNull
    private final Project project;
    private boolean _isDisposed;
    @NotNull
    private final VirtualFile previewFile;

    public EditorTabDiffPreview(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.previewFile = (VirtualFile)new TabPreviewDiffVirtualFile(this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public abstract boolean hasContent();

    @NotNull
    protected abstract DiffEditorViewer createViewer();

    @Nullable
    protected abstract ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean var1);

    @Nullable
    protected abstract String getEditorTabName(@Nullable DiffEditorViewer var1);

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public void dispose() {
        this._isDisposed = true;
    }

    @NotNull
    public final VirtualFile getPreviewFile() {
        return this.previewFile;
    }

    public final boolean isPreviewOpen() {
        return FileEditorManager.getInstance((Project)this.project).isFileOpenWithRemotes(this.previewFile);
    }

    @Override
    public void closePreview() {
        DiffPreview.Companion.closePreviewFile(this.project, this.previewFile);
    }

    @Override
    public boolean openPreview(boolean requestFocus) {
        if (!this.hasContent()) {
            return false;
        }
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile(this.previewFile, requestFocus);
        return true;
    }

    @Override
    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setVisible(event.isFromActionToolbar() || event.getPresentation().isEnabled());
    }

    @Override
    public boolean performDiffAction() {
        if (!this.hasContent()) {
            return false;
        }
        if (ExternalDiffTool.isEnabled()) {
            ListSelection<? extends DiffRequestProducer> diffProducers = this.collectDiffProducers(true);
            if (diffProducers != null && diffProducers.isEmpty()) {
                diffProducers = this.collectDiffProducers(false);
            }
            if (EditorTabDiffPreviewKt.showExternalToolIfNeeded(this.project, diffProducers)) {
                return true;
            }
        }
        return this.openPreview(true);
    }

    protected void handleEscapeKey() {
        this.closePreview();
    }

    @Nullable
    public AnAction createEscapeHandler() {
        return (AnAction)new DiffEditorPreviewEscapeAction(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview$DiffEditorPreviewEscapeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/diff/editor/DiffEditorEscapeAction;", "preview", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "<init>", "(Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;)V", "previewRef", "Ljava/lang/ref/WeakReference;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.diff.impl"})
    private static final class DiffEditorPreviewEscapeAction
    extends DumbAwareAction
    implements DiffEditorEscapeAction {
        @NotNull
        private final WeakReference<EditorTabDiffPreview> previewRef;

        public DiffEditorPreviewEscapeAction(@NotNull EditorTabDiffPreview preview) {
            Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
            this.previewRef = new WeakReference<EditorTabDiffPreview>(preview);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(this.previewRef.get() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EditorTabDiffPreview editorTabDiffPreview = (EditorTabDiffPreview)this.previewRef.get();
                if (editorTabDiffPreview == null) break block0;
                editorTabDiffPreview.handleEscapeKey();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview$TabPreviewDiffVirtualFile;", "Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "Lcom/intellij/diff/editor/DiffVirtualFileWithTabName;", "Lcom/intellij/diff/editor/DiffVirtualFileWithProducers;", "preview", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "<init>", "(Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;)V", "_preview", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "project", "Lcom/intellij/openapi/project/Project;", "getEditorTabName", "", "editors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isValid", "", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "createEscapeHandler", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorTabDiffPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabDiffPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabDiffPreview$TabPreviewDiffVirtualFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n808#2,11:146\n*S KotlinDebug\n*F\n+ 1 EditorTabDiffPreview.kt\ncom/intellij/openapi/vcs/changes/EditorTabDiffPreview$TabPreviewDiffVirtualFile\n*L\n105#1:146,11\n*E\n"})
    private static final class TabPreviewDiffVirtualFile
    extends DiffViewerVirtualFile
    implements DiffVirtualFileWithTabName,
    DiffVirtualFileWithProducers {
        @Nullable
        private EditorTabDiffPreview _preview;

        public TabPreviewDiffVirtualFile(@NotNull EditorTabDiffPreview preview) {
            Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
            super("TabPreviewDiffVirtualFile");
            this._preview = preview;
            Disposer.register((Disposable)((Disposable)preview), () -> TabPreviewDiffVirtualFile._init_$lambda$0(this));
        }

        @Override
        @NotNull
        public DiffEditorViewer createViewer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            EditorTabDiffPreview editorTabDiffPreview = this._preview;
            if (editorTabDiffPreview == null) {
                throw new IllegalArgumentException("Preview already disposed");
            }
            EditorTabDiffPreview preview = editorTabDiffPreview;
            DiffEditorViewer editorViewer = preview.createViewer();
            Disposer.register((Disposable)((Disposable)preview), (Disposable)((Disposable)editorViewer.getDisposable()));
            return editorViewer;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getEditorTabName(@NotNull Project project, @NotNull List<? extends FileEditor> editors) {
            Object object;
            block4: {
                block3: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter(editors, (String)"editors");
                    Iterable $this$filterIsInstance$iv = editors;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof DiffEditorViewerFileEditor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    DiffEditorViewerFileEditor editor = (DiffEditorViewerFileEditor)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
                    object = this._preview;
                    if (object == null) break block3;
                    DiffEditorViewerFileEditor diffEditorViewerFileEditor = editor;
                    if ((object = ((EditorTabDiffPreview)object).getEditorTabName(diffEditorViewerFileEditor != null ? diffEditorViewerFileEditor.getEditorViewer() : null)) != null) break block4;
                }
                String string = DiffBundle.message((String)"label.default.diff.editor.tab.name", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            return object;
        }

        public boolean isValid() {
            return this._preview != null;
        }

        @Override
        @Nullable
        public ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
            EditorTabDiffPreview editorTabDiffPreview = this._preview;
            return editorTabDiffPreview != null ? editorTabDiffPreview.collectDiffProducers(selectedOnly) : null;
        }

        @Override
        @Nullable
        public AnAction createEscapeHandler() {
            EditorTabDiffPreview editorTabDiffPreview = this._preview;
            return editorTabDiffPreview != null ? editorTabDiffPreview.createEscapeHandler() : null;
        }

        private static final void _init_$lambda$0(TabPreviewDiffVirtualFile this$0) {
            this$0._preview = null;
        }
    }
}

