/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByCharRt;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByLineRt;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.IndicatorCancellationChecker;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsImpl;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ComparisonManagerImpl
extends ComparisonManager {
    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        ComparisonManagerImpl comparisonManagerImpl = (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
        if (comparisonManagerImpl == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(0);
        }
        return comparisonManagerImpl;
    }

    @NotNull
    public CancellationChecker createCancellationChecker(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(1);
        }
        return new IndicatorCancellationChecker(indicator);
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(5);
        }
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(text2);
        List<LineFragment> list = this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(8);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(9);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(10);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(12);
        }
        Range boundaryRange = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        List<LineFragment> list = this.compareLines(boundaryRange, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull Range boundaryRange, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(14);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(16);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(17);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(18);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(20);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(boundaryRange.start1, boundaryRange.end1, text1, lineOffsets1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(boundaryRange.start2, boundaryRange.end2, text2, lineOffsets2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        return ComparisonManagerImpl.convertIntoLineFragments(boundaryRange, lineOffsets1, lineOffsets2, (DiffIterable)iterable);
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(22);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(23);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(25);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List list = ByLineRt.convertIntoMergeLineFragments(ranges);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public List<MergeLineFragment> mergeLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(28);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(29);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(30);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(31);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.merge(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List list = ByLineRt.convertIntoMergeLineFragments(ranges);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(32);
        }
        return list;
    }

    public List<MergeLineFragment> mergeLinesWithinRange(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull MergeRange boundaryRange, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(34);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(35);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(36);
        }
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(38);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(boundaryRange.start1, boundaryRange.end1, text1, LineOffsetsImpl.create((CharSequence)text1));
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(boundaryRange.start2, boundaryRange.end2, text2, LineOffsetsImpl.create((CharSequence)text2));
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(boundaryRange.start3, boundaryRange.end3, text3, LineOffsetsImpl.create((CharSequence)text3));
        List<MergeRange> ranges = ByLine.merge(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        return ByLineRt.convertIntoMergeLineFragments(ranges, (MergeRange)boundaryRange);
    }

    public String mergeLinesAdditions(@NotNull CharSequence text1, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(39);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(40);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(41);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(42);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        FairDiffIterable diff = ByLine.compare(lineTexts1, lineTexts3, policy, indicator);
        StringBuilder base = new StringBuilder();
        for (Range range : diff.iterateUnchanged()) {
            for (int i = range.start1; i < range.end1; ++i) {
                if (!base.isEmpty()) {
                    base.append("\n");
                }
                base.append(lineTexts1.get(i));
            }
        }
        return base.toString();
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(43);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(44);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(45);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(46);
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        List<LineFragment> list = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, InnerFragmentsPolicy.WORDS, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(48);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(49);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(50);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(51);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(52);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(53);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(54);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.WORDS && Registry.is((String)"diff.by.word.deprioritize.line.differences")) {
            List<LineFragment> list = this.compareLinesWordFirst(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(55);
            }
            return list;
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            List<LineFragment> list = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(56);
            }
            return list;
        }
        List<LineFragment> list = lineFragments;
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(57);
        }
        return list;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull Range boundaryRange, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(58);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(59);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(60);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(61);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(62);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(63);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(64);
        }
        InnerFragmentsPolicy fragmentsPolicy = innerFragments ? InnerFragmentsPolicy.WORDS : InnerFragmentsPolicy.NONE;
        List<LineFragment> list = this.compareLinesInner(boundaryRange, text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<LineFragment> compareLinesInner(@NotNull Range boundaryRange, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(66);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(67);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(68);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(69);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(70);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(71);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(72);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(73);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.WORDS && Registry.is((String)"diff.by.word.deprioritize.line.differences") && boundaryRange.start1 == 0 && boundaryRange.start2 == 0 && boundaryRange.end1 == lineOffsets1.getLineCount() && boundaryRange.end2 == lineOffsets2.getLineCount()) {
            List<LineFragment> list = this.compareLinesWordFirst(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(74);
            }
            return list;
        }
        List<LineFragment> lineFragments = this.compareLines(boundaryRange, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            List<LineFragment> list = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(75);
            }
            return list;
        }
        List<LineFragment> list = lineFragments;
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(76);
        }
        return list;
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<? extends LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) {
        if (lineFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(77);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(78);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(79);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(80);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(81);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(82);
        }
        ArrayList<LineFragment> result = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment lineFragment : lineFragments) {
            assert (lineFragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result.addAll(ComparisonManagerImpl.createInnerFragments(lineFragment, text1, text2, policy, fragmentsPolicy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e) {
                result.add(lineFragment);
                ++tooBigChunksCount;
            }
        }
        return result;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(83);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(84);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(85);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(86);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(87);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(88);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.NONE) {
            List<LineFragment> list = Collections.singletonList(fragment);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(89);
            }
            return list;
        }
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEqualTexts((CharSequence)subSequence1, (CharSequence)subSequence2, (ComparisonPolicy)policy)) {
                List<LineFragmentImpl> list = Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
                if (list == null) {
                    ComparisonManagerImpl.$$$reportNull$$$0(90);
                }
                return list;
            }
            List<LineFragment> list = Collections.singletonList(fragment);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(91);
            }
            return list;
        }
        if (!tryComputeDifferences) {
            List<LineFragment> list = Collections.singletonList(fragment);
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(92);
            }
            return list;
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.WORDS) {
            return ComparisonManagerImpl.createInnerWordFragments(fragment, subSequence1, subSequence2, policy, indicator);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.CHARS) {
            return ComparisonManagerImpl.createInnerCharFragments(fragment, subSequence1, subSequence2, policy, indicator);
        }
        throw new IllegalArgumentException(fragmentsPolicy.name());
    }

    @NotNull
    private static List<LineFragment> createInnerWordFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(93);
        }
        if (subSequence1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(94);
        }
        if (subSequence2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(95);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(96);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(97);
        }
        List<ByWordRt.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (!lineBlocks.isEmpty());
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i = 0; i < lineBlocks.size(); ++i) {
            ByWordRt.LineBlock block = lineBlocks.get(i);
            Range offsets = block.offsets;
            int currentEndLine1 = i != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        ArrayList<LineFragment> arrayList = chunks;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(98);
        }
        return arrayList;
    }

    @NotNull
    private static List<LineFragment> createInnerCharFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(99);
        }
        if (subSequence1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(100);
        }
        if (subSequence2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(101);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(102);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(103);
        }
        List<DiffFragment> innerChanges = ComparisonManagerImpl.doCompareChars(subSequence1, subSequence2, policy, indicator);
        List<LineFragmentImpl> list = Collections.singletonList(new LineFragmentImpl(fragment, innerChanges));
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(104);
        }
        return list;
    }

    @NotNull
    private static List<DiffFragment> doCompareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(105);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(106);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(107);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(108);
        }
        Object iterable = policy == ComparisonPolicy.DEFAULT ? ByCharRt.compareTwoStep((CharSequence)text1, (CharSequence)text2, (CancellationChecker)new IndicatorCancellationChecker(indicator)) : (policy == ComparisonPolicy.TRIM_WHITESPACES ? ByCharRt.compareTrimWhitespaces((CharSequence)text1, (CharSequence)text2, (CancellationChecker)new IndicatorCancellationChecker(indicator)) : ByCharRt.compareIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2, (CancellationChecker)new IndicatorCancellationChecker(indicator)));
        List list = ByWordRt.convertIntoDiffFragments((DiffIterable)iterable);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(109);
        }
        return list;
    }

    @ApiStatus.Experimental
    @NotNull
    public @Unmodifiable List<LineFragment> compareLinesWordFirst(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(110);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(111);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(112);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(113);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(114);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(115);
        }
        List lineBlocks = ByWordRt.compareWordsFirst((CharSequence)text1, (CharSequence)text2, (LineOffsets)lineOffsets1, (LineOffsets)lineOffsets2, (ComparisonPolicy)policy, (CancellationChecker)new IndicatorCancellationChecker(indicator));
        List list = ContainerUtil.map((Collection)lineBlocks, block -> {
            Range lineRange = block.lineRange;
            LineFragment fragment = ComparisonManagerImpl.createLineFragment(lineRange.start1, lineRange.end1, lineRange.start2, lineRange.end2, lineOffsets1, lineOffsets2);
            return new LineFragmentImpl(fragment, block.fragments);
        });
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(116);
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(117);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(118);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(119);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(120);
        }
        List<DiffFragment> list = ByWord.compare(text1, text2, policy, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(121);
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(122);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(123);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(124);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(125);
        }
        return ComparisonManagerImpl.doCompareChars(text1, text2, policy, indicator);
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(126);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(127);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(128);
        }
        return ComparisonUtil.isEqualTexts((CharSequence)text1, (CharSequence)text2, (ComparisonPolicy)policy);
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull DiffIterable changes) {
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(129);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(130);
        }
        if (changes == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(131);
        }
        Range boundaryRange = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        return ComparisonManagerImpl.convertIntoLineFragments(boundaryRange, lineOffsets1, lineOffsets2, changes);
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull Range boundaryRange, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull DiffIterable changes) {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(132);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(133);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(134);
        }
        if (changes == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(135);
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range range : changes.iterateChanges()) {
            int startLine1 = range.start1 + boundaryRange.start1;
            int startLine2 = range.start2 + boundaryRange.start2;
            int endLine1 = range.end1 + boundaryRange.start1;
            int endLine2 = range.end2 + boundaryRange.start2;
            fragments.add(ComparisonManagerImpl.createLineFragment(startLine1, endLine1, startLine2, endLine2, lineOffsets1, lineOffsets2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(136);
        }
        return arrayList;
    }

    @NotNull
    public static LineFragment createLineFragment(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2) {
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(137);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(138);
        }
        IntPair offsets1 = ComparisonManagerImpl.getOffsets(lineOffsets1, startLine1, endLine1);
        IntPair offsets2 = ComparisonManagerImpl.getOffsets(lineOffsets2, startLine2, endLine2);
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, offsets1.first, offsets1.second, offsets2.first, offsets2.second);
    }

    @NotNull
    private static IntPair getOffsets(@NotNull LineOffsets lineOffsets, int startIndex, int endIndex) {
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(139);
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lineOffsets.getLineCount() ? lineOffsets.getLineStart(startIndex) : lineOffsets.getLineEnd(lineOffsets.getLineCount() - 1, true);
            return new IntPair(offset, offset);
        }
        int offset1 = lineOffsets.getLineStart(startIndex);
        int offset2 = lineOffsets.getLineEnd(endIndex - 1, true);
        return new IntPair(offset1, offset2);
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(140);
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(141);
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<? super List<? extends LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(142);
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(143);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(144);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(145);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(146);
        }
        if (!squash && !trim) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(147);
            }
            return list;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(148);
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<? super List<? extends LineFragment>>)((Consumer)fragments -> newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(149);
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<? extends LineFragment> oldFragments, @NotNull Consumer<? super List<? extends LineFragment>> consumer) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(150);
        }
        if (consumer == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(151);
        }
        int startIndex = 0;
        for (int i = 1; i < oldFragments.size(); ++i) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i - 1), oldFragments.get(i))) continue;
            consumer.consume(oldFragments.subList(startIndex, i));
            startIndex = i;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<? extends LineFragment> processAdjoining(@NotNull List<? extends LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        if (fragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(152);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(153);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(154);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(155);
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !ComparisonUtil.isEquals((CharSequence)sequence1, (CharSequence)sequence2, (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !ComparisonUtil.isEquals((CharSequence)sequence1, (CharSequence)sequence2, (ComparisonPolicy)ComparisonPolicy.IGNORE_WHITESPACES)) break;
                --end;
            }
        }
        if (start == end) {
            List list = Collections.emptyList();
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(156);
            }
            return list;
        }
        if (squash) {
            List<LineFragment> list = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(157);
            }
            return list;
        }
        List<? extends LineFragment> list = fragments.subList(start, end);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(158);
        }
        return list;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<? extends LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(159);
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(160);
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment lineFragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(lineFragment)) {
                int shift1 = lineFragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = lineFragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        return new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(161);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(162);
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(163);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(164);
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(165);
        }
        if (lineFragment.getInnerFragments() != null) {
            List list = lineFragment.getInnerFragments();
            if (list == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(166);
            }
            return list;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(167);
        }
        return list;
    }

    @NotNull
    private static List<CharSequence> getLineContents(@NotNull CharSequence text) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(168);
        }
        LineOffsets lineOffsets = LineOffsetsUtil.create(text);
        return ComparisonManagerImpl.getLineContents(0, lineOffsets.getLineCount(), text, lineOffsets);
    }

    @NotNull
    private static List<CharSequence> getLineContents(int start, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(169);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(170);
        }
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>(end - start);
        for (int line = start; line < end; ++line) {
            lines.add((CharSequence)new CharSequenceSubSequence(text, lineOffsets.getLineStart(line), lineOffsets.getLineEnd(line)));
        }
        ArrayList<CharSequence> arrayList = lines;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(171);
        }
        return arrayList;
    }

    @NotNull
    private static List<CharSequence> getNotIgnoredLineContents(int start, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(172);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(173);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(174);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>(end - start);
        for (int line = start; line < end; ++line) {
            for (int offset = lineOffsets.getLineStart(line); offset < lineOffsets.getLineEnd(line); ++offset) {
                if (ignored.get(offset)) continue;
                sb.append(text.charAt(offset));
            }
            lines.add(sb.toString());
            sb.setLength(0);
        }
        ArrayList<CharSequence> arrayList = lines;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(175);
        }
        return arrayList;
    }

    @NotNull
    public @Unmodifiable List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(176);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(177);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(178);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(179);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(180);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(181);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(182);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(183);
        }
        Range boundaryRange = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        List<LineFragment> list = this.compareLinesWithIgnoredRanges(boundaryRange, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator);
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(184);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<LineFragment> compareLinesWithIgnoredRanges(@NotNull Range boundaryRange, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(185);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(186);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(187);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(188);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(189);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(190);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(191);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(192);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(193);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getNotIgnoredLineContents(boundaryRange.start1, boundaryRange.end1, text1, lineOffsets1, ignored1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getNotIgnoredLineContents(boundaryRange.start2, boundaryRange.end2, text2, lineOffsets2, ignored2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        FairDiffIterable correctedIterable = ComparisonManagerImpl.correctIgnoredRangesSecondStep(boundaryRange, iterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        DiffIterable trimmedIterable = ComparisonManagerImpl.trimIgnoredLines(boundaryRange, correctedIterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(boundaryRange, lineOffsets1, lineOffsets2, trimmedIterable);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, fragmentsPolicy, indicator);
        }
        List list = ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredInnerFragments(fragment, ignored1, ignored2));
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(194);
        }
        return list;
    }

    @NotNull
    public static BitSet collectIgnoredRanges(@NotNull List<? extends TextRange> ignoredRanges) {
        if (ignoredRanges == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(195);
        }
        BitSet set = new BitSet();
        for (TextRange textRange : ignoredRanges) {
            set.set(textRange.getStartOffset(), textRange.getEndOffset());
        }
        BitSet bitSet = set;
        if (bitSet == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(196);
        }
        return bitSet;
    }

    @NotNull
    private static FairDiffIterable correctIgnoredRangesSecondStep(@NotNull Range boundaryRange, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(197);
        }
        if (iterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(198);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(199);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(200);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(201);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(202);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(203);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(204);
        }
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(iterable.getLength1(), iterable.getLength2());
        for (Range ch : iterable.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = ch.start1 + i;
                int index2 = ch.start2 + i;
                if (!ComparisonManagerImpl.areIgnoredEqualLines(boundaryRange.start1 + index1, boundaryRange.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2)) continue;
                builder.markEqual(index1, index2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair((DiffIterable)builder.finish());
        if (fairDiffIterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(205);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable trimIgnoredLines(@NotNull Range boundaryRange, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (boundaryRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(206);
        }
        if (iterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(207);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(208);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(209);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(210);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(211);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(212);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(213);
        }
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range trimmedRange = TrimUtil.trimExpandRange((int)ch.start1, (int)ch.start2, (int)ch.end1, (int)ch.end2, (index1, index2) -> ComparisonManagerImpl.areIgnoredEqualLines(boundaryRange.start1 + index1, boundaryRange.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2), index -> ComparisonManagerImpl.isIgnoredLine(boundaryRange.start1 + index, lineOffsets1, ignored1), index -> ComparisonManagerImpl.isIgnoredLine(boundaryRange.start2 + index, lineOffsets2, ignored2));
            if (trimmedRange.isEmpty()) continue;
            changedRanges.add(trimmedRange);
        }
        DiffIterable diffIterable = DiffIterableUtil.create(changedRanges, (int)iterable.getLength1(), (int)iterable.getLength2());
        if (diffIterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(214);
        }
        return diffIterable;
    }

    @Nullable
    private static LineFragment trimIgnoredInnerFragments(@NotNull LineFragment fragment, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(215);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(216);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(217);
        }
        if (fragment.getInnerFragments() == null) {
            return fragment;
        }
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        List newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
            TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset1(), it.getEndOffset1(), ignored1, startOffset1);
            TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset2(), it.getEndOffset2(), ignored2, startOffset2);
            if (range1.isEmpty() && range2.isEmpty()) {
                return null;
            }
            return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
        });
        if (newInner.isEmpty()) {
            return null;
        }
        return new LineFragmentImpl(fragment, newInner);
    }

    private static boolean isIgnoredLine(int index, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(218);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(219);
        }
        return ComparisonManagerImpl.isIgnoredRange(ignored, lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
    }

    private static boolean areIgnoredEqualLines(int index1, int index2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(220);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(221);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(222);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(223);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(224);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(225);
        }
        int start1 = lineOffsets1.getLineStart(index1);
        int end1 = lineOffsets1.getLineEnd(index1, true);
        int start2 = lineOffsets2.getLineStart(index2);
        int end2 = lineOffsets2.getLineEnd(index2, true);
        Range range = TrimUtil.trimExpand((int)start1, (int)start2, (int)end1, (int)end2, (i1, i2) -> text1.charAt((int)i1) == text2.charAt((int)i2), ignored1::get, ignored2::get);
        if (!range.isEmpty()) {
            return false;
        }
        List<ByWordRt.InlineChunk> words1 = ComparisonManagerImpl.getNonIgnoredWords(index1, text1, lineOffsets1, ignored1);
        List<ByWordRt.InlineChunk> words2 = ComparisonManagerImpl.getNonIgnoredWords(index2, text2, lineOffsets2, ignored2);
        if (words1.size() != words2.size()) {
            return false;
        }
        for (int i = 0; i < words1.size(); ++i) {
            CharSequence word2;
            CharSequence word1 = ComparisonManagerImpl.getWordContent(index1, text1, lineOffsets1, words1.get(i));
            if (ComparisonUtil.isEquals((CharSequence)word1, (CharSequence)(word2 = ComparisonManagerImpl.getWordContent(index2, text2, lineOffsets2, words2.get(i))), (ComparisonPolicy)ComparisonPolicy.DEFAULT)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    ByWordRt.InlineChunk> getNonIgnoredWords(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(226);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(227);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(228);
        }
        int offset = lineOffsets.getLineStart(index);
        List innerChunks = ByWordRt.getInlineChunks((CharSequence)ComparisonManagerImpl.getLineContent(index, text, lineOffsets));
        List list = ContainerUtil.filter((Collection)innerChunks, it -> ByWordRt.isWordChunk((ByWordRt.InlineChunk)it) && !ComparisonManagerImpl.isIgnoredRange(ignored, offset + it.getOffset1(), offset + it.getOffset2()));
        if (list == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(229);
        }
        return list;
    }

    @NotNull
    private static CharSequence getWordContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull ByWordRt.InlineChunk word) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(230);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(231);
        }
        if (word == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(232);
        }
        CharSequence charSequence = ComparisonManagerImpl.getLineContent(index, text, lineOffsets).subSequence(word.getOffset1(), word.getOffset2());
        if (charSequence == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(233);
        }
        return charSequence;
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start, int end, @NotNull BitSet ignored, int offset) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(234);
        }
        IntPair intPair = TrimUtil.trim((int)(offset + start), (int)(offset + end), index -> ignored.get((int)index));
        return new TextRange(intPair.first - offset, intPair.second - offset);
    }

    private static boolean isIgnoredRange(@NotNull BitSet ignored, int start, int end) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(235);
        }
        return ignored.nextClearBit(start) >= end;
    }

    @NotNull
    private static CharSequence getLineContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(236);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(237);
        }
        CharSequence charSequence = text.subSequence(lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
        if (charSequence == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(238);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68, 69, 70, 71, 72, 73, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 93, 94, 95, 96, 97, 99, 100, 101, 102, 103, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 117, 118, 119, 120, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 137, 138, 139, 140, 143, 144, 145, 146, 150, 151, 152, 153, 154, 155, 159, 161, 162, 163, 164, 165, 168, 169, 170, 172, 173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 192, 193, 195, 197, 198, 199, 200, 201, 202, 203, 204, 206, 207, 208, 209, 210, 211, 212, 213, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 230, 231, 232, 234, 235, 236, 237 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 20: 
            case 25: 
            case 31: 
            case 38: 
            case 42: 
            case 46: 
            case 54: 
            case 64: 
            case 73: 
            case 82: 
            case 88: 
            case 97: 
            case 103: 
            case 108: 
            case 115: 
            case 120: 
            case 125: 
            case 183: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 21: 
            case 27: 
            case 33: 
            case 39: 
            case 43: 
            case 48: 
            case 59: 
            case 67: 
            case 78: 
            case 84: 
            case 105: 
            case 110: 
            case 117: 
            case 122: 
            case 126: 
            case 144: 
            case 153: 
            case 176: 
            case 186: 
            case 199: 
            case 208: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 22: 
            case 28: 
            case 34: 
            case 44: 
            case 49: 
            case 60: 
            case 68: 
            case 79: 
            case 85: 
            case 106: 
            case 111: 
            case 118: 
            case 123: 
            case 127: 
            case 145: 
            case 154: 
            case 177: 
            case 187: 
            case 200: 
            case 209: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 24: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 52: 
            case 63: 
            case 71: 
            case 80: 
            case 86: 
            case 96: 
            case 102: 
            case 107: 
            case 114: 
            case 119: 
            case 124: 
            case 128: 
            case 146: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 9: 
            case 17: 
            case 50: 
            case 61: 
            case 69: 
            case 112: 
            case 129: 
            case 133: 
            case 137: 
            case 178: 
            case 188: 
            case 201: 
            case 210: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 10: 
            case 18: 
            case 51: 
            case 62: 
            case 70: 
            case 113: 
            case 130: 
            case 134: 
            case 138: 
            case 179: 
            case 189: 
            case 202: 
            case 211: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 14: 
            case 37: 
            case 58: 
            case 66: 
            case 132: 
            case 185: 
            case 197: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundaryRange";
                break;
            }
            case 23: 
            case 29: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 53: 
            case 72: 
            case 81: 
            case 87: 
            case 182: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentsPolicy";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragments";
                break;
            }
            case 83: 
            case 93: 
            case 99: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 94: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSequence1";
                break;
            }
            case 95: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSequence2";
                break;
            }
            case 131: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 139: 
            case 170: 
            case 173: 
            case 218: 
            case 227: 
            case 231: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 140: 
            case 143: 
            case 150: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFragments";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 161: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFragment";
                break;
            }
            case 162: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFragment";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragment";
                break;
            }
            case 168: 
            case 169: 
            case 172: 
            case 226: 
            case 230: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 174: 
            case 219: 
            case 228: 
            case 234: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 180: 
            case 190: 
            case 203: 
            case 212: 
            case 216: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored1";
                break;
            }
            case 181: 
            case 191: 
            case 204: 
            case 213: 
            case 217: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored2";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges";
                break;
            }
            case 198: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 159: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 168: 
            case 169: 
            case 170: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 230: 
            case 231: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 6: 
            case 13: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLines";
                break;
            }
            case 47: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesInner";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerFragments";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerWordFragments";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerCharFragments";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompareChars";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesWordFirst";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWords";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoLineFragments";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "processBlocks";
                break;
            }
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdjoining";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "doSquash";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "extractInnerFragments";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContents";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotIgnoredLineContents";
                break;
            }
            case 184: 
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIgnoredRanges";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "trimIgnoredLines";
                break;
            }
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredWords";
                break;
            }
            case 233: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordContent";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCancellationChecker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mergeLines";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mergeLinesWithinRange";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mergeLinesAdditions";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesInner";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createInnerFragments";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createInnerWordFragments";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "createInnerCharFragments";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "doCompareChars";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesWordFirst";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "compareWords";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "compareChars";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoLineFragments";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createLineFragment";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getOffsets";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "squash";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "processBlocks";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "processAdjoining";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "doSquash";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoining";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoiningInner";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "extractInnerFragments";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getLineContents";
                break;
            }
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getNotIgnoredLineContents";
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "collectIgnoredRanges";
                break;
            }
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredLines";
                break;
            }
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredInnerFragments";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredLine";
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "areIgnoredEqualLines";
                break;
            }
            case 226: 
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "getNonIgnoredWords";
                break;
            }
            case 230: 
            case 231: 
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "getWordContent";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredRange";
                break;
            }
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredRange";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "getLineContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68, 69, 70, 71, 72, 73, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 93, 94, 95, 96, 97, 99, 100, 101, 102, 103, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 117, 118, 119, 120, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 137, 138, 139, 140, 143, 144, 145, 146, 150, 151, 152, 153, 154, 155, 159, 161, 162, 163, 164, 165, 168, 169, 170, 172, 173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 192, 193, 195, 197, 198, 199, 200, 201, 202, 203, 204, 206, 207, 208, 209, 210, 211, 212, 213, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 230, 231, 232, 234, 235, 236, 237 -> new IllegalArgumentException(string);
        };
    }
}

