/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalDiffToolUtil {
    private static final Logger LOG = Logger.getInstance(ExternalDiffToolUtil.class);

    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(0);
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            return !DiffUtil.isFileWithoutContent(file);
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@Nullable Project project, @NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(2);
        }
        if (content instanceof EmptyContent) {
            return new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file.isInLocalFileSystem()) {
                return new LocalInputFile(file);
            }
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(file, fileName));
        }
        if (content instanceof DocumentContent) {
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(project, (DocumentContent)content, fileName));
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file = ((DirectoryContent)content).getFile();
            if (file.isInLocalFileSystem()) {
                return new LocalInputFile(file);
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(@Nullable Project project, @NotNull DocumentContent content, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        Charset charset = ExternalDiffToolUtil.getContentCharset(project, content);
        Boolean hasBom = content.hasBom();
        if (hasBom == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = content.getDocument().getText();
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file, @NotNull FileNameInfo fileName) throws IOException {
        if (file == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(6);
        }
        byte[] bytes = file.contentsToByteArray();
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static Charset getContentCharset(@Nullable Project project, @NotNull DocumentContent content) {
        Charset charset;
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(7);
        }
        if ((charset = content.getCharset()) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(8);
            }
            return charset2;
        }
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        Charset charset3 = e.getDefaultCharset();
        if (charset3 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(9);
        }
        return charset3;
    }

    @NotNull
    private static OutputFile createOutputFile(@Nullable Project project, @NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(11);
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file.isInLocalFileSystem()) {
                return new LocalOutputFile(file);
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file, fileName);
            return new NonLocalOutputFile(file, tempFile);
        }
        if (content instanceof DocumentContent) {
            DocumentContent documentContent = (DocumentContent)content;
            File tempFile = ExternalDiffToolUtil.createTempFile(project, documentContent, fileName);
            Charset charset = ExternalDiffToolUtil.getContentCharset(project, documentContent);
            return new DocumentOutputFile(documentContent.getDocument(), charset, tempFile);
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createFile(byte @NotNull [] bytes, @NotNull FileNameInfo fileName) throws IOException {
        if (fileName == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(12);
        }
        if (bytes == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(13);
        }
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file = tempFile;
        if (file == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(14);
        }
        return file;
    }

    public static void testDiffTool2(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull TestOutputConsole outputConsole) {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(15);
        }
        if (outputConsole == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(16);
        }
        DiffContentFactory factory = DiffContentFactory.getInstance();
        List<DocumentContent> contents = Arrays.asList(factory.create(DiffBundle.message((String)"settings.external.diff.left.file.content", (Object[])new Object[0]), (FileType)FileTypes.PLAIN_TEXT), factory.create(DiffBundle.message((String)"settings.external.diff.right.file.content", (Object[])new Object[0]), (FileType)FileTypes.PLAIN_TEXT));
        List<String> titles = Arrays.asList("Left", "Right");
        ExternalDiffToolUtil.testDiffTool(project, externalTool, contents, titles, outputConsole);
    }

    public static void testDiffTool3(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull TestOutputConsole outputConsole) {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(17);
        }
        if (outputConsole == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(18);
        }
        DiffContentFactory factory = DiffContentFactory.getInstance();
        List<DocumentContent> contents = Arrays.asList(factory.create(DiffBundle.message((String)"settings.external.diff.left.file.content", (Object[])new Object[0]), (FileType)FileTypes.PLAIN_TEXT), factory.create(DiffBundle.message((String)"settings.external.diff.base.file.content", (Object[])new Object[0]), (FileType)FileTypes.PLAIN_TEXT), factory.create(DiffBundle.message((String)"settings.external.diff.right.file.content", (Object[])new Object[0]), (FileType)FileTypes.PLAIN_TEXT));
        List<String> titles = Arrays.asList("Left", "Base", "Right");
        ExternalDiffToolUtil.testDiffTool(project, externalTool, contents, titles, outputConsole);
    }

    private static void testDiffTool(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @NotNull TestOutputConsole outputConsole) {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(19);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(20);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(21);
        }
        if (outputConsole == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(22);
        }
        JComponent parentComponent = outputConsole.getComponent();
        try {
            GeneralCommandLine commandLine = ExternalDiffToolUtil.createDiffCommandLine(project, externalTool, contents, titles, null);
            TestKillableProcessHandler processHandler = new TestKillableProcessHandler(commandLine);
            ExternalDiffToolUtil.addLoggingListener(outputConsole, commandLine, (ProcessHandler)processHandler);
            processHandler.startNotify();
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)parentComponent, (String)e.getMessage(), (String)DiffBundle.message((String)"error.cannot.show.diff", (Object[])new Object[0]));
        }
    }

    public static void testMergeTool(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull TestOutputConsole outputConsole) {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(23);
        }
        if (outputConsole == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(24);
        }
        JComponent parentComponent = outputConsole.getComponent();
        try {
            DocumentImpl document = new DocumentImpl(DiffBundle.message((String)"settings.external.diff.original.output.file.content", (Object[])new Object[0]));
            Consumer callback = arg_0 -> ExternalDiffToolUtil.lambda$testMergeTool$0((Document)document, arg_0);
            List<String> contents = Arrays.asList(DiffBundle.message((String)"settings.external.diff.left.file.content", (Object[])new Object[0]), DiffBundle.message((String)"settings.external.diff.base.file.content", (Object[])new Object[0]), DiffBundle.message((String)"settings.external.diff.right.file.content", (Object[])new Object[0]));
            List<String> titles = Arrays.asList("Left", "Base", "Right");
            MergeRequest request = DiffRequestFactory.getInstance().createMergeRequest(null, (FileType)PlainTextFileType.INSTANCE, (Document)document, contents, null, titles, callback);
            ExternalDiffToolUtil.handleMergeRequest(request, (ThrowableComputable<Boolean, IOException>)((ThrowableComputable)() -> ExternalDiffToolUtil.runWithTempMergeFiles(project, (ThreesideMergeRequest)request, (outputFile, inputFiles) -> {
                try {
                    GeneralCommandLine commandLine = ExternalDiffToolUtil.createMergeCommandLine(externalTool, outputFile, inputFiles);
                    TestKillableProcessHandler processHandler = new TestKillableProcessHandler(commandLine);
                    ExternalDiffToolUtil.addLoggingListener(outputConsole, commandLine, (ProcessHandler)processHandler);
                    processHandler.startNotify();
                    return ExternalDiffToolUtil.waitMergeProcessWithModal(project, processHandler.getProcess(), externalTool.isMergeTrustExitCode(), parentComponent);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            })));
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)parentComponent, (String)e.getMessage(), (String)DiffBundle.message((String)"error.cannot.show.merge", (Object[])new Object[0]));
        }
    }

    private static void addLoggingListener(final @NotNull TestOutputConsole outputConsole, GeneralCommandLine commandLine, @NotNull ProcessHandler processHandler) {
        if (outputConsole == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(25);
        }
        if (processHandler == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(26);
        }
        outputConsole.appendOutput(ProcessOutputTypes.SYSTEM, commandLine.getCommandLineString());
        processHandler.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                    outputConsole.appendOutput(outputType, event.getText());
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                outputConsole.processTerminated(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void executeDiff(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(27);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(28);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(29);
        }
        try {
            DiffUsageTriggerCollector.logShowExternalTool(project, false);
            GeneralCommandLine commandLine = ExternalDiffToolUtil.createDiffCommandLine(project, externalTool, contents, titles, windowTitle);
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private static GeneralCommandLine createDiffCommandLine(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(30);
        }
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(31);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(32);
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        List<InputFile> files = ExternalDiffToolUtil.createInputFiles(project, contents, titles, windowTitle);
        HashMap<String, String> patterns = new HashMap<String, String>();
        if (files.size() == 2) {
            patterns.put("%1", files.get(0).getPath());
            patterns.put("%2", files.get(1).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", files.get(0).getPath());
            patterns.put("%2", files.get(2).getPath());
            patterns.put("%3", files.get(1).getPath());
        }
        return ExternalDiffToolUtil.createCommandLine(externalTool.getProgramPath(), externalTool.getArgumentPattern(), patterns);
    }

    @RequiresEdt
    public static void executeMerge(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull ThreesideMergeRequest request, @Nullable JComponent parentComponent) throws IOException {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(33);
        }
        if (request == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(34);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DiffUsageTriggerCollector.logShowExternalTool(project, true);
        ExternalDiffToolUtil.handleMergeRequest((MergeRequest)request, (ThrowableComputable<Boolean, IOException>)((ThrowableComputable)() -> ExternalDiffToolUtil.tryExecuteMerge(project, externalTool, request, parentComponent)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMergeRequest(@NotNull MergeRequest request, @NotNull ThrowableComputable<Boolean, IOException> mergeTask) throws IOException {
        if (request == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(35);
        }
        if (mergeTask == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(36);
        }
        request.onAssigned(true);
        try {
            boolean success = false;
            try {
                success = (Boolean)mergeTask.compute();
                request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            }
            catch (Throwable throwable) {
                request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
                throw throwable;
            }
        }
        finally {
            request.onAssigned(false);
        }
    }

    public static boolean tryExecuteMerge(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull ThreesideMergeRequest request, @Nullable JComponent parentComponent) throws IOException {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(37);
        }
        if (request == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(38);
        }
        return ExternalDiffToolUtil.runWithTempMergeFiles(project, request, (outputFile, inputFiles) -> {
            GeneralCommandLine commandLine = ExternalDiffToolUtil.createMergeCommandLine(externalTool, outputFile, inputFiles);
            try {
                Process process = commandLine.createProcess();
                return ExternalDiffToolUtil.waitMergeProcessWithModal(project, process, externalTool.isMergeTrustExitCode(), parentComponent);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        });
    }

    private static boolean waitMergeProcessWithModal(@Nullable Project project, final @NotNull Process process, boolean trustExitCode, @Nullable JComponent parentComponent) {
        if (process == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(39);
        }
        if (trustExitCode) {
            final Ref resultRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                final Semaphore semaphore = new Semaphore(0);
                Thread waiter = new Thread("external process waiter"){

                    @Override
                    public void run() {
                        try {
                            resultRef.set((Object)(process.waitFor() == 0 ? 1 : 0));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                };
                waiter.start();
                try {
                    do {
                        ProgressManager.checkCanceled();
                    } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    waiter.interrupt();
                }
            }, DiffBundle.message((String)"waiting.for.external.tool", (Object[])new Object[0]), true, project, parentComponent);
            return resultRef.get() == Boolean.TRUE;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TimeoutUtil.sleep((long)1000L), DiffBundle.message((String)"launching.external.tool", (Object[])new Object[0]), false, project, parentComponent);
        return Messages.showYesNoDialog((Project)project, (String)DiffBundle.message((String)"press.mark.as.resolve", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.in.external.tool", (Object[])new Object[0]), (String)DiffBundle.message((String)"mark.as.resolved", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.revert", (Object[])new Object[0]), null) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runWithTempMergeFiles(@Nullable Project project, @NotNull ThreesideMergeRequest request, @NotNull MergeTask mergeTask) throws IOException {
        boolean bl;
        List<InputFile> inputFiles;
        block10: {
            if (request == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(40);
            }
            if (mergeTask == null) {
                ExternalDiffToolUtil.$$$reportNull$$$0(41);
            }
            InputFile outputFile = null;
            inputFiles = null;
            try {
                outputFile = ExternalDiffToolUtil.createOutputFile(project, request.getOutputContent(), request.getTitle());
                inputFiles = ExternalDiffToolUtil.createInputFiles(project, request.getContents(), request.getContentTitles(), request.getTitle());
                boolean success = mergeTask.runMerge((OutputFile)outputFile, inputFiles);
                if (success) {
                    outputFile.apply();
                }
                bl = success;
                if (outputFile == null) break block10;
            }
            catch (Throwable throwable) {
                if (outputFile != null) {
                    outputFile.cleanup();
                }
                if (inputFiles != null) {
                    for (InputFile file : inputFiles) {
                        file.cleanup();
                    }
                }
                throw throwable;
            }
            outputFile.cleanup();
        }
        if (inputFiles != null) {
            for (InputFile file : inputFiles) {
                file.cleanup();
            }
        }
        return bl;
    }

    @NotNull
    private static GeneralCommandLine createMergeCommandLine(@NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull OutputFile outputFile, @NotNull List<? extends InputFile> inputFiles) {
        if (externalTool == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(42);
        }
        if (outputFile == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(43);
        }
        if (inputFiles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(44);
        }
        assert (inputFiles.size() == 3);
        HashMap<String, String> patterns = new HashMap<String, String>();
        patterns.put("%1", inputFiles.get(0).getPath());
        patterns.put("%2", inputFiles.get(2).getPath());
        patterns.put("%3", inputFiles.get(1).getPath());
        patterns.put("%4", outputFile.getPath());
        return ExternalDiffToolUtil.createCommandLine(externalTool.getProgramPath(), externalTool.getArgumentPattern(), patterns);
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) {
        if (exePath == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(45);
        }
        if (parametersTemplate == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(46);
        }
        if (patterns == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(47);
        }
        List parameters = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters) {
            String arg = StringUtil.replace((String)parameter, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        if (generalCommandLine2 == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(48);
        }
        return generalCommandLine2;
    }

    @NotNull
    private static List<InputFile> createInputFiles(@Nullable Project project, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException {
        if (contents == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(49);
        }
        if (titles == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(50);
        }
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        for (int i = 0; i < contents.size(); ++i) {
            DiffContent content = contents.get(i);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i);
            inputFiles.add(ExternalDiffToolUtil.createFile(project, content, fileName));
        }
        ArrayList<InputFile> arrayList = inputFiles;
        if (arrayList == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @NotNull
    private static OutputFile createOutputFile(@Nullable Project project, @NotNull DiffContent outputContent, @Nullable String windowTitle) throws IOException {
        if (outputContent == null) {
            ExternalDiffToolUtil.$$$reportNull$$$0(52);
        }
        return ExternalDiffToolUtil.createOutputFile(project, outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
    }

    private static /* synthetic */ void lambda$testMergeTool$0(Document document, MergeResult result) {
        String message = result == MergeResult.CANCEL ? DiffBundle.message((String)"settings.external.diff.merge.conflict.resolve.was.canceled", (Object[])new Object[0]) : DiffBundle.message((String)"settings.external.diff.merge.conflict.resolve.successful", (Object[])new Object[]{StringUtil.shortenPathWithEllipsis((String)document.getText(), (int)60)});
        Messages.showInfoMessage((String)message, (String)DiffBundle.message((String)"settings.external.diff.test.complete", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 14, 48, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalTool";
                break;
            }
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsole";
                break;
            }
            case 20: 
            case 28: 
            case 31: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 21: 
            case 29: 
            case 32: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeTask";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFiles";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersTemplate";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentCharset";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createInputFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFile";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContentCharset";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 48: 
            case 51: {
                break;
            }
            case 10: 
            case 11: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createOutputFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "testDiffTool2";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "testDiffTool3";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "testDiffTool";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "testMergeTool";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addLoggingListener";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "executeDiff";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createDiffCommandLine";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "executeMerge";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "handleMergeRequest";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "tryExecuteMerge";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "waitMergeProcessWithModal";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runWithTempMergeFiles";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createMergeCommandLine";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createInputFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 14, 48, 51 -> new IllegalStateException(string);
        };
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        TempInputFile(@NotNull File localFile) {
            if (localFile == null) {
                TempInputFile.$$$reportNull$$$0(0);
            }
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                TempInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        FileNameInfo(@NotNull @NonNls String prefix, @NotNull @NonNls String name) {
            if (prefix == null) {
                FileNameInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FileNameInfo.$$$reportNull$$$0(1);
            }
            this.prefix = prefix;
            this.name = name;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents == null) {
                FileNameInfo.$$$reportNull$$$0(2);
            }
            if (titles == null) {
                FileNameInfo.$$$reportNull$$$0(3);
            }
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content, @Nullable String windowTitle) {
            if (content == null) {
                FileNameInfo.$$$reportNull$$$0(4);
            }
            String name = FileNameInfo.getFileName(content, null, windowTitle);
            return new FileNameInfo("merge_result", name);
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content == null) {
                FileNameInfo.$$$reportNull$$$0(5);
            }
            if (content instanceof EmptyContent) {
                return "no_content.tmp";
            }
            String fileName = (String)content.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content instanceof FileContent) {
                fileName = ((FileContent)content).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                String string = fileName;
                if (string == null) {
                    FileNameInfo.$$$reportNull$$$0(6);
                }
                return string;
            }
            FileType fileType = content.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            Object name = "";
            if (title != null && windowTitle != null) {
                name = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                Object object = name = title != null ? title : windowTitle;
            }
            if (((String)name).length() > 50) {
                name = ((String)name).substring(0, 50);
            }
            String string2 = PathUtil.suggestFileName((String)((String)name + "." + ext), (boolean)true, (boolean)false);
            if (string2 == null) {
                FileNameInfo.$$$reportNull$$$0(7);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titles";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createMergeResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileName";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        LocalInputFile(@NotNull VirtualFile file) {
            if (file == null) {
                LocalInputFile.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                LocalInputFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void cleanup() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        LocalOutputFile(@NotNull VirtualFile file) {
            if (file == null) {
                LocalOutputFile.$$$reportNull$$$0(0);
            }
            super(file);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        NonLocalOutputFile(@NotNull VirtualFile file, @NotNull File localFile) {
            if (file == null) {
                NonLocalOutputFile.$$$reportNull$$$0(0);
            }
            if (localFile == null) {
                NonLocalOutputFile.$$$reportNull$$$0(1);
            }
            super(localFile);
            this.myFile = file;
        }

        @Override
        public void apply() throws IOException {
            FileUtil.copy((File)this.myLocalFile, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myFile});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        DocumentOutputFile(@NotNull Document document, @NotNull Charset charset, @NotNull File localFile) {
            if (document == null) {
                DocumentOutputFile.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                DocumentOutputFile.$$$reportNull$$$0(1);
            }
            if (localFile == null) {
                DocumentOutputFile.$$$reportNull$$$0(2);
            }
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset;
        }

        @Override
        public void apply() throws IOException {
            String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TestOutputConsole {
        @NotNull
        public JComponent getComponent();

        public void appendOutput(@NotNull Key<?> var1, @NotNull String var2);

        public void processTerminated(int var1);
    }

    private static class TestKillableProcessHandler
    extends KillableProcessHandler {
        private static final BaseOutputReader.Options FULL_LINES_READER_OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.NON_BLOCKING;
            }

            public boolean sendIncompleteLines() {
                return false;
            }
        };

        TestKillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                TestKillableProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = FULL_LINES_READER_OPTIONS;
            if (options == null) {
                TestKillableProcessHandler.$$$reportNull$$$0(1);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TestKillableProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffToolUtil$TestKillableProcessHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }

    private static interface MergeTask {
        public boolean runMerge(@NotNull OutputFile var1, @NotNull List<InputFile> var2) throws IOException;
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }
}

