/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    private static final Logger LOG = Logger.getInstance(FoldingModelSupport.class);
    private static final String PLACEHOLDER = "     ";
    private static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.Cache");
    protected final int myCount;
    @Nullable
    protected final Project myProject;
    protected final EditorEx @NotNull [] myEditors;
    @NotNull
    protected final List<FoldedGroup> myFoldings;
    private FoldedBlock myHoveredBlock;
    private boolean myDuringSynchronize;
    private final Int2ObjectMap<List<FoldedBlock>>[] myLineMappings;
    private final boolean[] myShouldUpdateLineNumbers;
    private boolean myEnabled;

    public FoldingModelSupport(@Nullable Project project, EditorEx @NotNull [] editors, @NotNull Disposable disposable) {
        if (disposable == null) {
            FoldingModelSupport.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            FoldingModelSupport.$$$reportNull$$$0(1);
        }
        this.myFoldings = new ArrayList<FoldedGroup>();
        this.myHoveredBlock = null;
        this.myProject = project;
        this.myEditors = editors;
        this.myCount = this.myEditors.length;
        this.myShouldUpdateLineNumbers = new boolean[this.myCount];
        this.myEnabled = true;
        this.myLineMappings = new Int2ObjectMap[this.myCount];
        for (int i = 0; i < this.myCount; ++i) {
            this.myLineMappings[i] = new Int2ObjectOpenHashMap();
        }
        MyDocumentListener documentListener = new MyDocumentListener();
        List documents = ContainerUtil.map((Object[])this.myEditors, EditorEx::getDocument);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, disposable);
        for (int i = 0; i < this.myCount; ++i) {
            if (this.myCount > 1) {
                this.myEditors[i].getFoldingModel().addListener((FoldingListener)new MyFoldingListener(i), disposable);
            }
            HoveredBlockEditorMouseMotionListener listener = new HoveredBlockEditorMouseMotionListener(i);
            this.myEditors[i].addEditorMouseListener((EditorMouseListener)listener, disposable);
            this.myEditors[i].addEditorMouseMotionListener((EditorMouseMotionListener)listener, disposable);
        }
    }

    public int getCount() {
        return this.myCount;
    }

    protected void repaintSeparators() {
        for (EditorEx editor : this.myEditors) {
            editor.getComponent().repaint();
        }
    }

    @Nullable
    protected Data computeFoldedRanges(@Nullable Iterator<int[]> changedLines, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(2);
        }
        if (changedLines == null || settings.range == -1) {
            return null;
        }
        FoldingBuilder builder = new FoldingBuilder(this.myEditors, settings);
        return builder.build(changedLines);
    }

    protected void install(@Nullable Iterator<int[]> changedLines, @Nullable UserDataHolder context, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(3);
        }
        Data data = this.computeFoldedRanges(changedLines, settings);
        this.install(data, context, settings);
    }

    public void install(@Nullable Data data, @Nullable UserDataHolder context, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(4);
        }
        if (!this.myEnabled) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (FoldedBlock folding : this.getFoldedBlocks()) {
            folding.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.destroyFolding();
            }
            this.myFoldings.clear();
            this.myHoveredBlock = null;
            if (data != null) {
                FoldingInstaller installer = new FoldingInstaller(context, settings);
                installer.install(data);
            }
        });
        this.updateLineNumbers(true);
    }

    protected static int[] countLines(EditorEx @NotNull [] editors) {
        if (editors == null) {
            FoldingModelSupport.$$$reportNull$$$0(5);
        }
        return (int[])EditorThreading.compute(() -> {
            int[] lineCount = new int[editors.length];
            for (int i = 0; i < editors.length; ++i) {
                lineCount[i] = DiffUtil.getLineCount((Document)editors[i].getDocument());
            }
            return lineCount;
        });
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Nullable
    private static String getRangeDescription(@NotNull Project project, int startLine, int endLine, int index, @NotNull DescriptionComputer computer) {
        if (project == null) {
            FoldingModelSupport.$$$reportNull$$$0(6);
        }
        if (computer == null) {
            FoldingModelSupport.$$$reportNull$$$0(7);
        }
        if (startLine == endLine) {
            return null;
        }
        FoldedRangeDescription endDescription = computer.computeDescription(project, endLine, index);
        if (endDescription == null) {
            return null;
        }
        FoldedRangeDescription startDescription = computer.computeDescription(project, startLine, index);
        if (Comparing.equal((Object)startDescription, (Object)endDescription) && (endDescription.anchorLine == -1 || startLine > endDescription.anchorLine)) {
            return null;
        }
        return endDescription.description;
    }

    @Nullable
    public static FoldedRangeDescription getLineSeparatorDescription(@NotNull Project project, @NotNull Document document, int lineNumber) {
        PsiFile psiFile;
        if (project == null) {
            FoldingModelSupport.$$$reportNull$$$0(8);
        }
        if (document == null) {
            FoldingModelSupport.$$$reportNull$$$0(9);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (document.getLineCount() <= lineNumber) {
            return null;
        }
        int offset = document.getLineStartOffset(lineNumber);
        FileBreadcrumbsCollector collector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)project, (VirtualFile)virtualFile);
        ArrayList crumbs = ContainerUtil.newArrayList((Iterable)collector.computeCrumbs(virtualFile, document, offset, Boolean.valueOf(true)));
        if (crumbs.isEmpty()) {
            return null;
        }
        String description = StringUtil.join((Collection)crumbs, it -> it.getText(), (String)" > ");
        Crumb lastCrumb = (Crumb)crumbs.get(crumbs.size() - 1);
        int anchorOffset = lastCrumb instanceof NavigatableCrumb ? ((NavigatableCrumb)lastCrumb).getAnchorOffset() : -1;
        int anchorLine = anchorOffset != -1 ? document.getLineNumber(anchorOffset) : -1;
        return new FoldedRangeDescription(description, anchorLine);
    }

    @Nullable
    public static FoldRegion addFolding(@NotNull EditorEx editor, int start, int end, boolean expanded) {
        if (editor == null) {
            FoldingModelSupport.$$$reportNull$$$0(10);
        }
        DocumentEx document = editor.getDocument();
        int startOffset = document.getLineStartOffset(start);
        int endOffset = document.getLineEndOffset(end - 1);
        FoldRegion region = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, PLACEHOLDER);
        if (region != null) {
            region.setExpanded(expanded);
            region.setInnerHighlightersMuted(true);
            FoldingModelImpl.hideGutterRendererForCollapsedRegion((FoldRegion)region);
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            FoldingModelSupport.$$$reportNull$$$0(11);
        }
        Runnable lastRunnable = runnable;
        for (EditorEx editor : this.myEditors) {
            Runnable finalRunnable = lastRunnable;
            lastRunnable = () -> {
                if (DiffUtil.isFocusedComponent(editor.getComponent())) {
                    editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret(finalRunnable);
                } else {
                    editor.getFoldingModel().runBatchFoldingOperation(finalRunnable);
                }
            };
        }
        this.myDuringSynchronize = true;
        try {
            lastRunnable.run();
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void destroy() {
        for (FoldedBlock folding : this.getFoldedBlocks()) {
            folding.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.destroyFolding();
            }
            this.myFoldings.clear();
            this.myHoveredBlock = null;
        });
    }

    @NotNull
    public IntPredicate hideLineNumberPredicate(int index) {
        IntPredicate intPredicate = lineNumber -> {
            FoldRegion region;
            FoldedBlock foldedBlock = this.getBlockForLine(index, lineNumber);
            return foldedBlock != null && (region = foldedBlock.getRegion(index)) != null && !region.isExpanded();
        };
        if (intPredicate == null) {
            FoldingModelSupport.$$$reportNull$$$0(12);
        }
        return intPredicate;
    }

    private void updateLineNumbers(boolean force) {
        for (int i = 0; i < this.myCount; ++i) {
            if (!this.myShouldUpdateLineNumbers[i] && !force) continue;
            this.myShouldUpdateLineNumbers[i] = false;
            EditorThreading.assertInteractionAllowed();
            Int2ObjectMap<List<FoldedBlock>> mapping = this.myLineMappings[i];
            mapping.clear();
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                int lineNumber = folding.computeLineNumber(i);
                List lineBlocks = (List)mapping.computeIfAbsent(lineNumber, key -> new SmartList());
                lineBlocks.add(folding);
            }
        }
    }

    @Nullable
    private FoldedBlock getBlockForLine(int index, int hoverLine) {
        this.updateLineNumbers(false);
        List blocks = (List)this.myLineMappings[index].get(hoverLine);
        if (blocks == null) {
            return null;
        }
        return (FoldedBlock)ContainerUtil.find((Iterable)blocks, folding -> {
            FoldRegion region = folding.getRegion(index);
            return region != null && !region.isExpanded();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(boolean expanded) {
        if (this.myDuringSynchronize) {
            return;
        }
        this.myDuringSynchronize = true;
        try {
            int i = 0;
            while (i < this.myCount) {
                int index = i++;
                FoldingModelEx model = this.myEditors[index].getFoldingModel();
                model.runBatchFoldingOperation(() -> {
                    for (FoldedBlock folding : this.getFoldedBlocks()) {
                        FoldRegion region = folding.getRegion(index);
                        if (region == null) continue;
                        region.setExpanded(expanded);
                    }
                });
            }
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    @RequiresEdt
    public void updateContext(@NotNull UserDataHolder context, @NotNull Settings settings) {
        if (context == null) {
            FoldingModelSupport.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myFoldings.isEmpty()) {
            return;
        }
        context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(settings));
    }

    @RequiresEdt
    @NotNull
    private FoldingCache getFoldingCache(@NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        List[] result = new List[this.myCount];
        EditorThreading.run(() -> {
            for (int i = 0; i < this.myCount; ++i) {
                result[i] = this.collectFoldedGroupsStates(i);
            }
        });
        return new FoldingCache(result, settings.defaultExpanded);
    }

    @NotNull
    private List<FoldedGroupState> collectFoldedGroupsStates(int index) {
        EditorThreading.assertInteractionAllowed();
        ArrayList<FoldedGroupState> ranges = new ArrayList<FoldedGroupState>();
        DocumentEx document = this.myEditors[index].getDocument();
        for (FoldedGroup group : this.myFoldings) {
            LineRange expanded = null;
            LineRange collapsed = null;
            String[] collapsedDescription = null;
            for (FoldedBlock folding : group.blocks) {
                int line2;
                int line1;
                FoldRegion region = folding.getRegion(index);
                if (region == null || !region.isValid()) continue;
                if (region.isExpanded()) {
                    if (expanded != null) continue;
                    line1 = document.getLineNumber(region.getStartOffset());
                    line2 = document.getLineNumber(region.getEndOffset()) + 1;
                    expanded = new LineRange(line1, line2);
                    continue;
                }
                line1 = document.getLineNumber(region.getStartOffset());
                line2 = document.getLineNumber(region.getEndOffset()) + 1;
                collapsed = new LineRange(line1, line2);
                collapsedDescription = (String[])ContainerUtil.map((Object[])folding.myDescriptions, it -> it != null ? it.getCachedDescription() : null, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
                break;
            }
            if (expanded == null && collapsed == null) continue;
            ranges.add(new FoldedGroupState(expanded, collapsed, collapsedDescription));
        }
        ArrayList<FoldedGroupState> arrayList = ranges;
        if (arrayList == null) {
            FoldingModelSupport.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Iterable<FoldedBlock> getFoldedBlocks() {
        Iterable<FoldedBlock> iterable = () -> new Iterator<FoldedBlock>(){
            private int myGroupIndex = 0;
            private int myBlockIndex = 0;

            @Override
            public boolean hasNext() {
                return this.myGroupIndex < FoldingModelSupport.this.myFoldings.size();
            }

            @Override
            public FoldedBlock next() {
                FoldedGroup group = FoldingModelSupport.this.myFoldings.get(this.myGroupIndex);
                FoldedBlock folding = group.blocks.get(this.myBlockIndex);
                if (group.blocks.size() > this.myBlockIndex + 1) {
                    ++this.myBlockIndex;
                } else {
                    ++this.myGroupIndex;
                    this.myBlockIndex = 0;
                }
                return folding;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            FoldingModelSupport.$$$reportNull$$$0(17);
        }
        return iterable;
    }

    private static int getRangeShift(int range, int number) {
        return switch (number) {
            case 0 -> range;
            case 1 -> range * 2;
            case 2 -> range * 4;
            default -> -1;
        };
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    protected static <T, V> Iterator<V> map(@Nullable List<T> list, final @NotNull Function<? super T, ? extends V> mapping) {
        if (mapping == null) {
            FoldingModelSupport.$$$reportNull$$$0(18);
        }
        if (list == null) {
            return null;
        }
        final Iterator<T> it = list.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return mapping.fun(it.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hideLineNumberPredicate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFoldedGroupsStates";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeFoldedRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "countLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRangeDescription";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFolding";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runBatchOperation";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingCache";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 16, 17 -> new IllegalStateException(string);
        };
    }

    protected class FoldedBlock {
        private final FoldRegion @NotNull [] myRegions;
        @NotNull
        private final List<RangeHighlighter> myHighlighters;
        private final LazyDescription @NotNull [] myDescriptions;
        private final ProgressIndicator myDescriptionsIndicator;

        public FoldedBlock(@NotNull FoldRegion[] regions, @Nullable DescriptionComputer descriptionComputer, String[] cachedDescriptions) {
            if (descriptionComputer == null) {
                FoldedBlock.$$$reportNull$$$0(0);
            }
            if (regions == null) {
                FoldedBlock.$$$reportNull$$$0(1);
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>(FoldingModelSupport.this.myCount);
            this.myDescriptionsIndicator = new EmptyProgressIndicator();
            assert (regions.length == FoldingModelSupport.this.myCount);
            assert (cachedDescriptions == null || cachedDescriptions.length == FoldingModelSupport.this.myCount);
            this.myRegions = regions;
            this.myDescriptions = new LazyDescription[FoldingModelSupport.this.myCount];
            if (FoldingModelSupport.this.myProject != null) {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    String cachedDescription = cachedDescriptions != null ? cachedDescriptions[i] : null;
                    this.myDescriptions[i] = new LazyDescription(FoldingModelSupport.this.myProject, i, descriptionComputer, cachedDescription);
                }
            }
        }

        public void installHighlighter(@NotNull FoldedGroup group) {
            if (group == null) {
                FoldedBlock.$$$reportNull$$$0(2);
            }
            assert (this.myHighlighters.isEmpty());
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null || !region.isValid()) continue;
                this.myHighlighters.addAll(DiffDrawUtil.createLineSeparatorHighlighter((Editor)FoldingModelSupport.this.myEditors[i], region.getStartOffset(), region.getEndOffset(), new MySeparatorPresentation(group, i)));
            }
        }

        public void destroyFolding() {
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null) continue;
                FoldingModelSupport.this.myEditors[i].getFoldingModel().removeFoldRegion(region);
            }
            this.myDescriptionsIndicator.cancel();
        }

        public void destroyHighlighter() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            this.myHighlighters.clear();
        }

        public int computeLineNumber(int index) {
            FoldRegion region = this.myRegions[index];
            if (region == null || !region.isValid()) {
                return -1;
            }
            return FoldingModelSupport.this.myEditors[index].getDocument().getLineNumber(region.getStartOffset());
        }

        @Nullable
        public FoldRegion getRegion(int index) {
            return this.myRegions[index];
        }

        public boolean isHovered() {
            return FoldingModelSupport.this.myHoveredBlock == this;
        }

        public void setExpanded(boolean value) {
            FoldingModelSupport.this.runBatchOperation(() -> {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    FoldRegion region = this.getRegion(i);
                    if (region == null) continue;
                    region.setExpanded(value);
                }
            });
        }

        @NotNull
        private BooleanGetter getHighlighterCondition(@NotNull FoldedGroup group, int index) {
            if (group == null) {
                FoldedBlock.$$$reportNull$$$0(3);
            }
            BooleanGetter booleanGetter = () -> {
                if (!FoldingModelSupport.this.myEditors[index].getFoldingModel().isFoldingEnabled()) {
                    return false;
                }
                for (FoldedBlock folding : group.blocks) {
                    boolean visible;
                    FoldRegion region = folding.getRegion(index);
                    boolean bl = visible = region != null && region.isValid() && !region.isExpanded();
                    if (folding == this) {
                        return visible;
                    }
                    if (!visible) continue;
                    return false;
                }
                return false;
            };
            if (booleanGetter == null) {
                FoldedBlock.$$$reportNull$$$0(4);
            }
            return booleanGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptionComputer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighterCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installHighlighter";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getHighlighterCondition";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        private class LazyDescription {
            @NotNull
            private final Project myProject;
            private final int myIndex;
            @NotNull
            private final DescriptionComputer myDescriptionComputer;
            @NotNull
            private RangeDescription myDescription;
            private boolean myLoadingStarted;

            LazyDescription(Project project, @NotNull int index, @Nullable DescriptionComputer descriptionComputer, String cachedValue) {
                if (project == null) {
                    LazyDescription.$$$reportNull$$$0(0);
                }
                if (descriptionComputer == null) {
                    LazyDescription.$$$reportNull$$$0(1);
                }
                this.myLoadingStarted = false;
                this.myProject = project;
                this.myIndex = index;
                this.myDescriptionComputer = descriptionComputer;
                this.myDescription = new RangeDescription(cachedValue);
            }

            @RequiresEdt
            public String compute() {
                ThreadingAssertions.assertEventDispatchThread();
                if (!this.myLoadingStarted) {
                    this.myLoadingStarted = true;
                    ReadAction.nonBlocking(() -> new RangeDescription(this.computeDescription())).finishOnUiThread(ModalityState.any(), result -> {
                        this.myDescription = result;
                        if (result.description != null) {
                            this.repaintEditor();
                        }
                    }).withDocumentsCommitted(this.myProject).wrapProgress(FoldedBlock.this.myDescriptionsIndicator).submit((Executor)NonUrgentExecutor.getInstance());
                }
                return this.myDescription.description;
            }

            private void repaintEditor() {
                FoldRegion region = FoldedBlock.this.myRegions[this.myIndex];
                if (region == null || !region.isValid()) {
                    return;
                }
                if (FoldingModelSupport.this.myEditors[this.myIndex].isDisposed()) {
                    return;
                }
                FoldingModelSupport.this.myEditors[this.myIndex].repaint(region.getStartOffset(), region.getEndOffset());
            }

            @RequiresBackgroundThread
            @Nullable
            private String computeDescription() {
                ThreadingAssertions.assertBackgroundThread();
                try {
                    ProgressManager.checkCanceled();
                    FoldRegion region = FoldedBlock.this.myRegions[this.myIndex];
                    if (region == null) {
                        return null;
                    }
                    int startOffset = region.getStartOffset();
                    int endOffset = region.getEndOffset();
                    if (startOffset == -1 || endOffset == -1) {
                        return null;
                    }
                    if (!region.isValid()) {
                        return null;
                    }
                    int startLine = FoldingModelSupport.this.myEditors[this.myIndex].getDocument().getLineNumber(startOffset);
                    int endLine = FoldingModelSupport.this.myEditors[this.myIndex].getDocument().getLineNumber(endOffset);
                    return FoldingModelSupport.getRangeDescription(this.myProject, startLine, endLine, this.myIndex, this.myDescriptionComputer);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    return null;
                }
            }

            @RequiresEdt
            @Nullable
            public String getCachedDescription() {
                ThreadingAssertions.assertEventDispatchThread();
                return this.myDescription.description;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptionComputer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock$LazyDescription";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class MySeparatorPresentation
        implements DiffLineSeparatorRenderer.SeparatorPresentation {
            private final FoldedGroup myGroup;
            private final int myIndex;

            private MySeparatorPresentation(FoldedGroup group, int index) {
                if (group == null) {
                    MySeparatorPresentation.$$$reportNull$$$0(0);
                }
                this.myGroup = group;
                this.myIndex = index;
            }

            @Override
            public boolean isVisible() {
                return FoldedBlock.this.getHighlighterCondition(this.myGroup, this.myIndex).get();
            }

            @Override
            public boolean isHovered() {
                return FoldedBlock.this.isHovered();
            }

            @Override
            @Nullable
            public String getDescription() {
                LazyDescription description = FoldedBlock.this.myDescriptions[this.myIndex];
                return description != null ? description.compute() : null;
            }

            @Override
            public void setExpanded(boolean value) {
                FoldedBlock.this.setExpanded(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock$MySeparatorPresentation", "<init>"));
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (FoldingModelSupport.this.myEditors[i].getDocument() != e.getDocument()) continue;
                    FoldingModelSupport.this.myShouldUpdateLineNumbers[i] = true;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/FoldingModelSupport$MyDocumentListener", "documentChanged"));
        }
    }

    private class MyFoldingListener
    implements FoldingListener {
        private final int myIndex;
        @NotNull
        private final Set<FoldRegion> myModifiedRegions = new HashSet<FoldRegion>();

        MyFoldingListener(int index) {
            this.myIndex = index;
        }

        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            if (region == null) {
                MyFoldingListener.$$$reportNull$$$0(0);
            }
            if (FoldingModelSupport.this.myDuringSynchronize) {
                return;
            }
            this.myModifiedRegions.add(region);
        }

        public void onFoldProcessingEnd() {
            if (this.myModifiedRegions.isEmpty()) {
                return;
            }
            FoldingModelSupport.this.myDuringSynchronize = true;
            try {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (i == this.myIndex) continue;
                    int pairedIndex = i;
                    FoldingModelSupport.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(() -> {
                        for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                            FoldRegion pairedRegion;
                            FoldRegion region = folding.getRegion(this.myIndex);
                            if (region == null || !region.isValid() || !this.myModifiedRegions.contains(region) || (pairedRegion = folding.getRegion(pairedIndex)) == null || !pairedRegion.isValid()) continue;
                            pairedRegion.setExpanded(region.isExpanded());
                        }
                    });
                }
                this.myModifiedRegions.clear();
            }
            finally {
                FoldingModelSupport.this.myDuringSynchronize = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$MyFoldingListener", "onFoldRegionStateChange"));
        }
    }

    private class HoveredBlockEditorMouseMotionListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        private final int myIndex;

        HoveredBlockEditorMouseMotionListener(int index) {
            this.myIndex = index;
        }

        public void mouseMoved(@NotNull EditorMouseEvent event) {
            if (event == null) {
                HoveredBlockEditorMouseMotionListener.$$$reportNull$$$0(0);
            }
            FoldedBlock block = this.getSelectedBlock(event);
            this.updateHoveredBlock(block);
        }

        public void mouseExited(@NotNull EditorMouseEvent event) {
            if (event == null) {
                HoveredBlockEditorMouseMotionListener.$$$reportNull$$$0(1);
            }
            this.updateHoveredBlock(null);
        }

        public void mouseClicked(@NotNull EditorMouseEvent event) {
            FoldedBlock block;
            if (event == null) {
                HoveredBlockEditorMouseMotionListener.$$$reportNull$$$0(2);
            }
            if ((block = this.getSelectedBlock(event)) == null) {
                return;
            }
            block.setExpanded(true);
        }

        @Nullable
        private FoldedBlock getSelectedBlock(@NotNull EditorMouseEvent e) {
            FoldRegion region;
            int hoverLine;
            FoldedBlock foldedBlock;
            if (e == null) {
                HoveredBlockEditorMouseMotionListener.$$$reportNull$$$0(3);
            }
            if ((foldedBlock = FoldingModelSupport.this.getBlockForLine(this.myIndex, hoverLine = EditorUtil.yPositionToLogicalLine((Editor)FoldingModelSupport.this.myEditors[this.myIndex], (int)e.getMouseEvent().getY()))) != null && (region = foldedBlock.getRegion(this.myIndex)) != null) {
                return foldedBlock;
            }
            return null;
        }

        private void updateHoveredBlock(@Nullable FoldedBlock newBlock) {
            if (FoldingModelSupport.this.myHoveredBlock == newBlock) {
                return;
            }
            FoldingModelSupport.this.myHoveredBlock = newBlock;
            Cursor cursor = newBlock != null ? Cursor.getPredefinedCursor(12) : null;
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldingModelSupport.this.myEditors[i].setCustomCursor(FoldingModelSupport.class, cursor);
            }
            FoldingModelSupport.this.repaintSeparators();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$HoveredBlockEditorMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Settings {
        public final int range;
        public final boolean defaultExpanded;

        public Settings(int range, boolean defaultExpanded) {
            this.range = range;
            this.defaultExpanded = defaultExpanded;
        }
    }

    private static final class FoldingBuilder
    extends FoldingBuilderBase {
        private final EditorEx @NotNull [] myEditors;

        private FoldingBuilder(EditorEx @NotNull [] editors, @NotNull Settings settings) {
            if (settings == null) {
                FoldingBuilder.$$$reportNull$$$0(0);
            }
            if (editors == null) {
                FoldingBuilder.$$$reportNull$$$0(1);
            }
            super(FoldingModelSupport.countLines(editors), settings);
            this.myEditors = editors;
        }

        @Override
        @Nullable
        protected FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
            if (project == null) {
                FoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingModelSupport.getLineSeparatorDescription(project, (Document)this.myEditors[index].getDocument(), lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDescription";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Data {
        @NotNull
        private final List<Group> groups;
        @NotNull
        private final DescriptionComputer descriptionComputer;

        private Data(@NotNull List<Group> groups, @NotNull DescriptionComputer descriptionComputer) {
            if (groups == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (descriptionComputer == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.groups = groups;
            this.descriptionComputer = descriptionComputer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptionComputer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/FoldingModelSupport$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class Block {
            public final LineRange @NotNull [] ranges;

            private Block(LineRange @NotNull [] ranges) {
                if (ranges == null) {
                    Block.$$$reportNull$$$0(0);
                }
                this.ranges = ranges;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$Data$Block", "<init>"));
            }
        }

        private static final class Group {
            @NotNull
            public final List<Block> blocks;

            private Group(@NotNull List<Block> blocks) {
                if (blocks == null) {
                    Group.$$$reportNull$$$0(0);
                }
                this.blocks = blocks;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/util/FoldingModelSupport$Data$Group", "<init>"));
            }
        }
    }

    private static interface DescriptionComputer {
        @Nullable
        public FoldedRangeDescription computeDescription(@NotNull Project var1, int var2, int var3);
    }

    public static final class FoldedRangeDescription {
        @NotNull
        public final String description;
        public final int anchorLine;

        public FoldedRangeDescription(@NotNull String description, int anchorLine) {
            if (description == null) {
                FoldedRangeDescription.$$$reportNull$$$0(0);
            }
            this.description = description;
            this.anchorLine = anchorLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FoldedRangeDescription that = (FoldedRangeDescription)o;
            return Objects.equals(this.description, that.description) && Objects.equals(this.anchorLine, that.anchorLine);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.anchorLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedRangeDescription", "<init>"));
        }
    }

    private static class FoldingCache {
        public final boolean expandByDefault;
        public final List<FoldedGroupState> @NotNull [] ranges;

        FoldingCache(List<FoldedGroupState> @NotNull [] ranges, boolean expandByDefault) {
            if (ranges == null) {
                FoldingCache.$$$reportNull$$$0(0);
            }
            this.ranges = ranges;
            this.expandByDefault = expandByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingCache", "<init>"));
        }
    }

    private static class FoldedGroup {
        @NotNull
        public final List<FoldedBlock> blocks;

        FoldedGroup(@NotNull List<FoldedBlock> blocks) {
            if (blocks == null) {
                FoldedGroup.$$$reportNull$$$0(0);
            }
            this.blocks = blocks;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedGroup", "<init>"));
        }
    }

    private static class FoldedGroupState {
        @Nullable
        public final LineRange expanded;
        @Nullable
        public final LineRange collapsed;
        public final String @Nullable [] collapsedDescription;

        FoldedGroupState(@Nullable LineRange expanded, @Nullable LineRange collapsed, String @Nullable [] collapsedDescription) {
            assert (expanded != null || collapsed != null);
            this.expanded = expanded;
            this.collapsed = collapsed;
            this.collapsedDescription = collapsedDescription;
        }

        @NotNull
        public LineRange getLineRange() {
            LineRange lineRange = this.expanded != null ? this.expanded : this.collapsed;
            if (lineRange == null) {
                FoldedGroupState.$$$reportNull$$$0(0);
            }
            return lineRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedGroupState", "getLineRange"));
        }
    }

    private class FoldingInstaller {
        @NotNull
        private final ExpandSuggester myExpandSuggester;

        FoldingInstaller(@NotNull UserDataHolder context, Settings settings) {
            if (settings == null) {
                FoldingInstaller.$$$reportNull$$$0(0);
            }
            FoldingCache cache = context != null ? (FoldingCache)context.getUserData(CACHE_KEY) : null;
            this.myExpandSuggester = new ExpandSuggester(cache, settings.defaultExpanded);
        }

        public void install(@NotNull Data data) {
            if (data == null) {
                FoldingInstaller.$$$reportNull$$$0(1);
            }
            for (Data.Group group : data.groups) {
                ArrayList<FoldedBlock> blocks = new ArrayList<FoldedBlock>(3);
                for (Data.Block block : group.blocks) {
                    ContainerUtil.addIfNotNull(blocks, (Object)this.createBlock(data, block, this.myExpandSuggester.isExpanded(block)));
                }
                if (blocks.isEmpty()) continue;
                FoldedGroup foldedGroup = new FoldedGroup(blocks);
                for (FoldedBlock folding : foldedGroup.blocks) {
                    folding.installHighlighter(foldedGroup);
                }
                FoldingModelSupport.this.myFoldings.add(foldedGroup);
            }
        }

        @Nullable
        private FoldedBlock createBlock(@NotNull Data data, @NotNull Data.Block block, boolean expanded) {
            if (data == null) {
                FoldingInstaller.$$$reportNull$$$0(2);
            }
            if (block == null) {
                FoldingInstaller.$$$reportNull$$$0(3);
            }
            Object[] regions = new FoldRegion[FoldingModelSupport.this.myCount];
            String[] cachedDescriptions = null;
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                LineRange range = block.ranges[i];
                if (range == null) continue;
                regions[i] = FoldingModelSupport.addFolding(FoldingModelSupport.this.myEditors[i], range.start, range.end, expanded);
            }
            boolean hasFolding = ContainerUtil.or((Object[])regions, Objects::nonNull);
            boolean hasExpanded = ContainerUtil.or((Object[])regions, region -> region != null && region.isExpanded());
            if (hasExpanded && !expanded) {
                for (Object region2 : regions) {
                    if (region2 == null) continue;
                    region2.setExpanded(true);
                }
            }
            if (!hasExpanded && !expanded) {
                cachedDescriptions = new String[FoldingModelSupport.this.myCount];
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    LineRange range = block.ranges[i];
                    if (range == null) continue;
                    cachedDescriptions[i] = this.myExpandSuggester.getCachedDescription(range.start, range.end, i);
                }
            }
            return hasFolding ? new FoldedBlock((FoldRegion[])regions, data.descriptionComputer, cachedDescriptions) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingInstaller";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RangeDescription {
        @Nullable
        public final String description;

        private RangeDescription(@Nullable String description) {
            this.description = description;
        }
    }

    private class ExpandSuggester {
        @Nullable
        private final FoldingCache myCache;
        private final int[] myIndex;
        private final boolean myDefault;

        ExpandSuggester(FoldingCache cache, boolean defaultValue) {
            this.myIndex = new int[FoldingModelSupport.this.myCount];
            this.myCache = cache;
            this.myDefault = defaultValue;
        }

        public boolean isExpanded(@NotNull Data.Block block) {
            if (block == null) {
                ExpandSuggester.$$$reportNull$$$0(0);
            }
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return this.myDefault;
            }
            if (this.myDefault != this.myCache.expandByDefault) {
                return this.myDefault;
            }
            Boolean state = null;
            for (int index = 0; index < FoldingModelSupport.this.myCount; ++index) {
                Boolean sideState;
                LineRange range = block.ranges[index];
                if (range == null || (sideState = this.getCachedExpanded(range.start, range.end, index)) == null) continue;
                if (state == null) {
                    state = sideState;
                    continue;
                }
                if (state == sideState) continue;
                return this.myDefault;
            }
            return state == null ? this.myDefault : state;
        }

        @Nullable
        private Boolean getCachedExpanded(int start, int end, int index) {
            if (start == end) {
                return null;
            }
            FoldedGroupState range = this.getCachedState(start, end, index);
            if (range == null) {
                return null;
            }
            if (range.collapsed != null && range.collapsed.contains(start, end)) {
                return false;
            }
            if (range.expanded != null && range.expanded.contains(start, end)) {
                return true;
            }
            assert (false) : "Invalid LineRange" + String.valueOf(range.expanded) + ", " + String.valueOf(range.collapsed) + ", " + String.valueOf(new LineRange(start, end));
            return null;
        }

        @Nullable
        public String getCachedDescription(int start, int end, int index) {
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return null;
            }
            FoldedGroupState range = this.getCachedState(start, end, index);
            if (range == null) {
                return null;
            }
            if (range.collapsed != null && range.collapsed.contains(start, end)) {
                return range.collapsedDescription != null ? range.collapsedDescription[index] : null;
            }
            return null;
        }

        @Nullable
        private FoldedGroupState getCachedState(int start, int end, int index) {
            if (start == end) {
                return null;
            }
            List<FoldedGroupState> ranges = this.myCache.ranges[index];
            while (this.myIndex[index] < ranges.size()) {
                FoldedGroupState range = ranges.get(this.myIndex[index]);
                LineRange lineRange = range.getLineRange();
                if (lineRange.end > start) {
                    if (lineRange.contains(start, end)) {
                        return range;
                    }
                    if (lineRange.start >= start) {
                        return null;
                    }
                }
                int n = index;
                this.myIndex[n] = this.myIndex[n] + 1;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/util/FoldingModelSupport$ExpandSuggester", "isExpanded"));
        }
    }

    protected class MyPaintable
    implements DiffDividerDrawUtil.DividerSeparatorPaintable {
        private final int myLeft;
        private final int myRight;

        public MyPaintable(int left, int right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler) {
            if (handler == null) {
                MyPaintable.$$$reportNull$$$0(0);
            }
            block0: for (FoldedGroup group : FoldingModelSupport.this.myFoldings) {
                for (FoldedBlock folding : group.blocks) {
                    int line2;
                    FoldRegion region1 = folding.getRegion(this.myLeft);
                    FoldRegion region2 = folding.getRegion(this.myRight);
                    if (region1 == null || !region1.isValid() || region1.isExpanded() || region2 == null || !region2.isValid() || region2.isExpanded()) continue;
                    int line1 = FoldingModelSupport.this.myEditors[this.myLeft].getDocument().getLineNumber(region1.getStartOffset());
                    if (handler.process(line1, line2 = FoldingModelSupport.this.myEditors[this.myRight].getDocument().getLineNumber(region2.getStartOffset()), folding.isHovered())) continue block0;
                    return;
                }
            }
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyPaintable.$$$reportNull$$$0(1);
            }
            if (divider == null) {
                MyPaintable.$$$reportNull$$$0(2);
            }
            DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), (Editor)FoldingModelSupport.this.myEditors[this.myLeft], (Editor)FoldingModelSupport.this.myEditors[this.myRight], this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class FoldingBuilderBase {
        @NotNull
        private final Settings mySettings;
        private final int @NotNull [] myLineCount;
        private final int myCount;
        @NotNull
        private final List<Data.Group> myGroups;

        public FoldingBuilderBase(int[] lineCount, @NotNull Settings settings) {
            if (settings == null) {
                FoldingBuilderBase.$$$reportNull$$$0(0);
            }
            this.myGroups = new ArrayList<Data.Group>();
            this.mySettings = settings;
            this.myLineCount = lineCount;
            this.myCount = lineCount.length;
        }

        @NotNull
        public Data build(@NotNull Iterator<int[]> changedLines) {
            int i;
            if (changedLines == null) {
                FoldingBuilderBase.$$$reportNull$$$0(1);
            }
            int[] starts = new int[this.myCount];
            int[] ends = new int[this.myCount];
            int[] last = new int[this.myCount];
            for (i = 0; i < this.myCount; ++i) {
                last[i] = Integer.MIN_VALUE;
            }
            while (changedLines.hasNext()) {
                int[] offsets = changedLines.next();
                for (int i2 = 0; i2 < this.myCount; ++i2) {
                    starts[i2] = last[i2];
                    ends[i2] = offsets[i2 * 2];
                    last[i2] = offsets[i2 * 2 + 1];
                }
                this.addGroup(starts, ends);
            }
            for (i = 0; i < this.myCount; ++i) {
                starts[i] = last[i];
                ends[i] = Integer.MAX_VALUE;
            }
            this.addGroup(starts, ends);
            return new Data(this.myGroups, (project, line, index) -> this.getDescription(project, line, index));
        }

        private void addGroup(int[] starts, int[] ends) {
            int shift;
            ArrayList<Data.Block> result = new ArrayList<Data.Block>(3);
            int[] rangeStarts = new int[this.myCount];
            int[] rangeEnds = new int[this.myCount];
            int number = 0;
            while ((shift = FoldingModelSupport.getRangeShift(this.mySettings.range, number)) != -1) {
                for (int i = 0; i < this.myCount; ++i) {
                    rangeStarts[i] = DiffUtil.bound(starts[i] + shift, 0, this.myLineCount[i]);
                    rangeEnds[i] = DiffUtil.bound(ends[i] - shift, 0, this.myLineCount[i]);
                }
                ContainerUtil.addIfNotNull(result, (Object)this.createBlock(rangeStarts, rangeEnds));
                ++number;
            }
            if (!result.isEmpty()) {
                this.myGroups.add(new Data.Group(result));
            }
        }

        @Nullable
        private Data.Block createBlock(int[] starts, int[] ends) {
            Object[] regions = new LineRange[this.myCount];
            for (int i = 0; i < this.myCount; ++i) {
                if (ends[i] - starts[i] < 2) continue;
                regions[i] = new LineRange(starts[i], ends[i]);
            }
            boolean hasFolding = ContainerUtil.or((Object[])regions, Objects::nonNull);
            if (!hasFolding) {
                return null;
            }
            return new Data.Block((LineRange[])regions);
        }

        @Nullable
        protected abstract FoldedRangeDescription getDescription(@NotNull Project var1, int var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changedLines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilderBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "build";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

