/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsPanel;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import java.awt.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class DiffBreadcrumbsPanel
extends BreadcrumbsPanel {
    private boolean myCrumbsShown;

    public DiffBreadcrumbsPanel(@NotNull Editor editor, @NotNull Disposable disposable) {
        if (editor == null) {
            DiffBreadcrumbsPanel.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            DiffBreadcrumbsPanel.$$$reportNull$$$0(1);
        }
        super(editor);
        Disposer.register((Disposable)disposable, (Disposable)this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DiffBreadcrumbsPanel.this.updateVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/breadcrumbs/DiffBreadcrumbsPanel$1", "fileTypesChanged"));
            }
        });
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateVisibility());
    }

    public void setCrumbsShown(boolean value) {
        this.myCrumbsShown = value;
        this.updateVisibility();
    }

    private void updateVisibility() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.stateForComponent((Component)((Object)this)), () -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            boolean hasCollectors = this.updateCollectors(this.myCrumbsShown);
            if (hasCollectors != this.isVisible()) {
                this.setVisible(hasCollectors);
                this.revalidate();
                this.repaint();
            }
            this.queueUpdate();
        });
    }

    protected abstract boolean updateCollectors(boolean var1);

    @Nullable
    private FileBreadcrumbsCollector findCollector(@NotNull VirtualFile file) {
        FileViewProvider viewProvider;
        if (file == null) {
            DiffBreadcrumbsPanel.$$$reportNull$$$0(2);
        }
        if ((viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(file)) == null) {
            return null;
        }
        if (!ContainerUtil.exists((Iterable)viewProvider.getLanguages(), lang -> BreadcrumbsUtilEx.isBreadcrumbsShownFor((Language)lang) && BreadcrumbsUtil.getInfoProvider((Language)lang) != null)) {
            return null;
        }
        return FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)this.myProject, (VirtualFile)file);
    }

    protected int getLeftOffset() {
        if (((EditorEx)this.myEditor).getVerticalScrollbarOrientation() == 0) {
            return 0;
        }
        return super.getLeftOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/breadcrumbs/DiffBreadcrumbsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findCollector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class DiffBreadcrumbCollectorHolder {
        private volatile FileBreadcrumbsCollector myBreadcrumbsCollector;
        @NotNull
        private Disposable myCollectorListenerDisposable = Disposer.newDisposable();

        public boolean update(@Nullable VirtualFile file, boolean enable) {
            FileBreadcrumbsCollector newCollector;
            Disposer.dispose((Disposable)this.myCollectorListenerDisposable);
            FileBreadcrumbsCollector fileBreadcrumbsCollector = newCollector = enable && file != null ? DiffBreadcrumbsPanel.this.findCollector(file) : null;
            if (newCollector != null) {
                Disposable newDisposable = Disposer.newDisposable((Disposable)DiffBreadcrumbsPanel.this);
                newCollector.watchForChanges(file, DiffBreadcrumbsPanel.this.myEditor, newDisposable, () -> DiffBreadcrumbsPanel.this.queueUpdate());
                this.myBreadcrumbsCollector = newCollector;
                this.myCollectorListenerDisposable = newDisposable;
                return true;
            }
            this.myBreadcrumbsCollector = null;
            return false;
        }

        @Nullable
        public FileBreadcrumbsCollector getBreadcrumbsCollector() {
            return this.myBreadcrumbsCollector;
        }
    }
}

