/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocumentContentBase
extends DiffContentBase
implements DocumentContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;

    public DocumentContentBase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            DocumentContentBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDocument = document;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DocumentContentBase.$$$reportNull$$$0(1);
        }
        return document;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            DocumentContentBase.$$$reportNull$$$0(2);
        }
        if (!DiffUtil.canNavigateToFile(this.myProject, this.getHighlightFile())) {
            return null;
        }
        return new MyNavigatable(this.myProject, this.getHighlightFile(), this.getDocument(), position);
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.myDocument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/DocumentContentBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/DocumentContentBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyNavigatable
    implements Navigatable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myTargetFile;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final LineCol myPosition;

        MyNavigatable(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull Document document, @NotNull LineCol position) {
            if (project == null) {
                MyNavigatable.$$$reportNull$$$0(0);
            }
            if (targetFile == null) {
                MyNavigatable.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MyNavigatable.$$$reportNull$$$0(2);
            }
            if (position == null) {
                MyNavigatable.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myTargetFile = targetFile;
            this.myDocument = document;
            this.myPosition = position;
        }

        public void navigate(boolean requestFocus) {
            OpenFileDescriptor descriptor;
            Document targetDocument = FileDocumentManager.getInstance().getDocument(this.myTargetFile);
            LineCol targetPosition = MyNavigatable.translatePosition(this.myDocument, targetDocument, this.myPosition);
            Object object = descriptor = targetDocument != null ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myTargetFile, targetPosition.toOffset(targetDocument)) : new OpenFileDescriptor(this.myProject, this.myTargetFile, targetPosition.line, targetPosition.column);
            if (descriptor.canNavigate()) {
                descriptor.navigate(true);
            }
        }

        public boolean canNavigate() {
            return this.myTargetFile.isValid();
        }

        @NotNull
        private static LineCol translatePosition(@NotNull Document fromDocument, @Nullable Document toDocument, @NotNull LineCol position) {
            block7: {
                LineCol lineCol;
                if (fromDocument == null) {
                    MyNavigatable.$$$reportNull$$$0(4);
                }
                if (position == null) {
                    MyNavigatable.$$$reportNull$$$0(5);
                }
                try {
                    if (toDocument != null) break block7;
                    lineCol = position;
                }
                catch (FilesTooBigForDiffException ignore) {
                    LineCol lineCol2 = position;
                    if (lineCol2 == null) {
                        MyNavigatable.$$$reportNull$$$0(7);
                    }
                    return lineCol2;
                }
                if (lineCol == null) {
                    MyNavigatable.$$$reportNull$$$0(6);
                }
                return lineCol;
            }
            int targetLine = Diff.translateLine((CharSequence)fromDocument.getCharsSequence(), (CharSequence)toDocument.getCharsSequence(), (int)position.line, (boolean)true);
            return new LineCol(targetLine, position.column);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromDocument";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/contents/DocumentContentBase$MyNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/contents/DocumentContentBase$MyNavigatable";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "translatePosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "translatePosition";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

