/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffTableCellRenderer;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffToolbarActions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DirDiffPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirDiffPanel.class);
    public static final DataKey<DirDiffTableModel> DIR_DIFF_MODEL = DataKey.create((String)"DIR_DIFF_MODEL");
    public static final DataKey<JTable> DIR_DIFF_TABLE = DataKey.create((String)"DIR_DIFF_TABLE");
    public static final DataKey<FilterComponent> DIR_DIFF_FILTER = DataKey.create((String)"DIR_DIFF_FILTER");
    private static final String SPLITTER_PROPORTION_KEY = "dir.diff.panel.splitter.proportion";
    private final Project myProject;
    private final DirDiffTableModel myModel;
    private final DirDiffWindow myDiffWindow;
    private final JBTable myTable = new MyJBTable();
    private final TextFieldWithBrowseButton mySourceDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
    private final TextFieldWithBrowseButton myTargetDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
    private final FilterComponent myFilter = new MyFilterComponent();
    private final MyDiffRequestProcessor myDiffRequestProcessor;
    private final MainPanel myRootPanel;
    private final JPanel myFilterPanel;
    private final JPanel myToolbarPanel;

    public DirDiffPanel(DirDiffTableModel model, DirDiffWindow wnd) {
        this.myProject = model.getProject();
        this.myModel = model;
        this.myDiffWindow = wnd;
        this.mySourceDirField.setText(model.getSourceDir().getPath());
        this.myTargetDirField.setText(model.getTargetDir().getPath());
        JBLabel sourceDirLabel = new JBLabel(model.getSourceDir().getIcon());
        JBLabel targetDirLabel = new JBLabel(model.getTargetDir().getIcon());
        this.myModel.setTable(this.myTable);
        this.myModel.setPanel(this);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable.setModel((TableModel)this.myModel);
        TableSpeedSearch.installOn((JTable)this.myTable);
        this.myTable.setExpandableItemsEnabled(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setAutoResizeMode(1);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DirDiffTableCellRenderer());
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int ind;
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int lastIndex = e.getLastIndex();
                int firstIndex = e.getFirstIndex();
                DirDiffElementImpl last = DirDiffPanel.this.myModel.getElementAt(lastIndex);
                DirDiffElementImpl first = DirDiffPanel.this.myModel.getElementAt(firstIndex);
                if (last != null && last.isSeparator()) {
                    DirDiffPanel.this.myModel.setSelectedSeparator(last);
                } else {
                    DirDiffPanel.this.myModel.setSelectedSeparator(null);
                }
                if (last == null || first == null) {
                    DirDiffPanel.this.update(false);
                    return;
                }
                if (last.isSeparator() && selectionModel.isSelectedIndex(lastIndex)) {
                    ind = lastIndex + (lastIndex < firstIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                }
                if (first.isSeparator() && selectionModel.isSelectedIndex(firstIndex)) {
                    ind = firstIndex + (firstIndex < lastIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                } else {
                    DirDiffPanel.this.update(false);
                }
                DirDiffPanel.this.myDiffWindow.setTitle(DirDiffPanel.this.myModel.getTitle());
            }
        });
        if (model.isOperationsEnabled()) {
            DumbAwareAction.create(e -> this.changeOperationForSelection()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{32}), (JComponent)this.myTable);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (e.getButton() == 3) {
                        return false;
                    }
                    if (DirDiffPanel.this.myTable.getRowCount() > 0) {
                        int row = DirDiffPanel.this.myTable.rowAtPoint(e.getPoint());
                        int col = DirDiffPanel.this.myTable.columnAtPoint(e.getPoint());
                        if (row != -1 && col == (DirDiffPanel.this.myTable.getColumnCount() - 1) / 2) {
                            DirDiffPanel.this.changeOperationForSelection();
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$2", "onClick"));
                }
            }.installOn((Component)this.myTable);
        }
        this.myTable.getActionMap().put("selectPreviousRow", this.createNavigationAction(false, false));
        this.myTable.getActionMap().put("selectNextRow", this.createNavigationAction(true, false));
        this.myTable.getActionMap().put("selectPreviousRowExtendSelection", this.createNavigationAction(false, true));
        this.myTable.getActionMap().put("selectNextRowExtendSelection", this.createNavigationAction(true, true));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            DirDiffTableModel.ColumnType type = this.myModel.getColumnType(i);
            TableColumn column = columnModel.getColumn(i);
            if (type == DirDiffTableModel.ColumnType.DATE) {
                column.setPreferredWidth(JBUIScale.scale((int)110));
                column.setMinWidth(JBUIScale.scale((int)90));
                continue;
            }
            if (type == DirDiffTableModel.ColumnType.SIZE) {
                column.setPreferredWidth(JBUIScale.scale((int)120));
                column.setMinWidth(JBUIScale.scale((int)90));
                continue;
            }
            if (type == DirDiffTableModel.ColumnType.NAME) {
                column.setPreferredWidth(JBUIScale.scale((int)800));
                column.setMinWidth(JBUIScale.scale((int)120));
                continue;
            }
            if (type != DirDiffTableModel.ColumnType.OPERATION) continue;
            column.setMaxWidth(JBUIScale.scale((int)25));
            column.setMinWidth(JBUIScale.scale((int)25));
        }
        DirDiffToolbarActions actions = new DirDiffToolbarActions(this.myModel);
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("DirDiff", (ActionGroup)actions, true);
        toolbar.setTargetComponent((JComponent)this.myTable);
        DirDiffPanel.registerCustomShortcuts(actions, (JComponent)this.myTable);
        BorderLayoutPanel filesPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable));
        if (model.isOperationsEnabled()) {
            JBLabel label = new JBLabel(DiffBundle.message((String)"use.space.button.or.mouse.click", (Object[])new Object[0]), 0);
            label.setForeground(NamedColorUtil.getInactiveTextColor());
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)label);
            filesPanel.addToBottom((Component)label);
        }
        PopupHandler.installPopupMenu((JComponent)this.myTable, (String)"DirDiffMenu", (String)"DirDiffPanel");
        this.myFilterPanel = new JPanel(new BorderLayout());
        this.myToolbarPanel = JBUI.Panels.simplePanel((Component)toolbar.getComponent()).addToRight((Component)this.myFilterPanel);
        BorderLayoutPanel sourcePanel = JBUI.Panels.simplePanel((Component)this.mySourceDirField).addToLeft((Component)sourceDirLabel);
        BorderLayoutPanel targetPanel = JBUI.Panels.simplePanel((Component)this.myTargetDirField).addToLeft((Component)targetDirLabel);
        sourcePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        targetPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        GridBag gb = new GridBag().setDefaultFill(2).setDefaultWeightX(1.0);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.add((Component)this.myToolbarPanel, gb.nextLine().next().coverLine());
        headerPanel.add((Component)sourcePanel, gb.nextLine().next());
        headerPanel.add((Component)targetPanel, gb.next());
        OnePixelSplitter tableSplitter = new OnePixelSplitter(true, SPLITTER_PROPORTION_KEY, 0.4f);
        JComponent wrapped = UiDataProvider.wrapComponent((JComponent)filesPanel, sink -> this.uiDataSnapshot(sink));
        tableSplitter.setFirstComponent((JComponent)JBUI.Panels.simplePanel((Component)wrapped).addToTop((Component)headerPanel));
        JBLoadingPanel loadingPanel2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), wnd.getDisposable());
        loadingPanel2.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){
            boolean showHelp = true;

            public void onLoadingFinish() {
                long count;
                if (this.showHelp && DirDiffPanel.this.myModel.isOperationsEnabled() && DirDiffPanel.this.myModel.getRowCount() > 0 && (count = PropertiesComponent.getInstance().getLong("dir.diff.space.button.info", 0L)) < 3L) {
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DiffBundle.message((String)"use.space.button.to.change.operation", (Object[])new Object[0]))).setFadeoutTime(5000L).setContentInsets((Insets)JBUI.insets((int)15)).createBalloon().show(new RelativePoint((Component)DirDiffPanel.this.myTable, new Point(DirDiffPanel.this.myTable.getWidth() / 2, 0)), Balloon.Position.above);
                    PropertiesComponent.getInstance().setValue("dir.diff.space.button.info", String.valueOf(count + 1L));
                }
                this.showHelp = false;
            }
        });
        loadingPanel2.add((Component)tableSplitter, (Object)"Center");
        ComponentUtil.putClientProperty((JComponent)this.myTable, DirDiffTableModel.DECORATOR_KEY, (Object)loadingPanel2);
        this.myTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DirDiffPanel.this.myTable.removeComponentListener((ComponentListener)this);
                DirDiffPanel.this.myModel.reloadModel(false);
            }
        });
        this.myRootPanel = new MainPanel();
        this.myRootPanel.add((Component)loadingPanel2, "Center");
        this.myModel.addModelListener(new DirDiffModelListener(){

            @Override
            public void updateStarted() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)false, (boolean)true);
            }

            @Override
            public void updateFinished() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)true, (boolean)true);
            }
        });
        this.myFilter.getTextEditor().setColumns(35);
        this.myFilter.setFilter(this.myModel.getSettings().getFilter());
        JBLabel filterLabel = new JBLabel();
        LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)DiffBundle.message((String)"button.dirdiff.filter", (Object[])new Object[0])).setToLabel((JLabel)filterLabel);
        filterLabel.setLabelFor((Component)this.myFilter);
        this.myFilterPanel.add((Component)this.myFilter, "Center");
        this.myFilterPanel.add((Component)filterLabel, "West");
        HelpTooltip tooltip = new HelpTooltip().setTitle(DiffBundle.message((String)"dirdiff.filter.help.title", (Object[])new Object[0])).setDescription(DiffBundle.message((String)"dirdiff.filter.help.description", (Object[])new Object[0])).setNeverHideOnTimeout(true);
        this.myFilterPanel.add((Component)ContextHelpLabel.createFromTooltip((HelpTooltip)tooltip), "East");
        this.myFilterPanel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        this.setDirFieldChooser(this.myModel.getSourceDir().getElementChooser(this.myProject), false);
        this.setDirFieldChooser(this.myModel.getTargetDir().getElementChooser(this.myProject), true);
        this.myDiffRequestProcessor = new MyDiffRequestProcessor(this.myProject);
        Disposer.register((Disposable)this, (Disposable)this.myDiffRequestProcessor);
        actions.setUp(this.myModel, this.myDiffRequestProcessor.getComponent());
        tableSplitter.setSecondComponent(this.myDiffRequestProcessor.getComponent());
    }

    private void setDirFieldChooser(final @Nullable Callable<? extends DiffElement<?>> chooser, final boolean isTarget) {
        final @NotNull TextFieldWithBrowseButton dirField = isTarget ? this.myTargetDirField : this.mySourceDirField;
        dirField.setEditable(false);
        if (chooser != null && this.myModel.getSettings().enableChoosers) {
            dirField.setButtonEnabled(true);
            dirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        DiffElement newElement = (DiffElement)chooser.call();
                        if (newElement == null) {
                            return;
                        }
                        if (StringUtil.equals((CharSequence)dirField.getText(), (CharSequence)newElement.getPath())) {
                            return;
                        }
                        dirField.setText(newElement.getPath());
                        if (isTarget) {
                            DirDiffPanel.this.myModel.setTargetDir(newElement);
                        } else {
                            DirDiffPanel.this.myModel.setSourceDir(newElement);
                        }
                        DirDiffPanel.this.myModel.clear();
                        DirDiffPanel.this.myModel.reloadModel(true);
                        DirDiffPanel.this.myModel.updateFromUI();
                    }
                    catch (Exception err) {
                        LOG.warn((Throwable)err);
                    }
                }
            });
        } else {
            Dimension preferredSize = dirField.getPreferredSize();
            dirField.setButtonEnabled(false);
            dirField.getButton().setVisible(false);
            dirField.setPreferredSize(preferredSize);
        }
    }

    @NotNull
    private AbstractAction createNavigationAction(final boolean goDown, final boolean withSelection) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                int n = row = goDown ? DirDiffPanel.this.getNextRow() : DirDiffPanel.this.getPrevRow();
                if (row != -1) {
                    DirDiffPanel.this.selectRow(row, withSelection);
                }
            }
        };
    }

    private int getNextRow() {
        DirDiffElementImpl element;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int rowCount = this.myTable.getRowCount();
        int row = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row >= rowCount) {
                return -1;
            }
            if ((element = this.myModel.getElementAt(++row)) != null) continue;
            return -1;
        } while (element.isSeparator());
        return row;
    }

    private int getPrevRow() {
        DirDiffElementImpl element;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int row = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row <= 0) {
                return -1;
            }
            if ((element = this.myModel.getElementAt(--row)) != null) continue;
            return -1;
        } while (element.isSeparator());
        return row;
    }

    private void selectRow(int row, boolean extend) {
        if (row == -1) {
            return;
        }
        DirDiffElementImpl element = this.myModel.getElementAt(row);
        if (element == null || element.isSeparator()) {
            return;
        }
        this.myTable.changeSelection(row, (this.myModel.getColumnCount() - 1) / 2, false, extend);
    }

    public AnAction @NotNull [] getActions() {
        AnAction[] anActionArray = new DirDiffToolbarActions(this.myModel).getActions();
        if (anActionArray == null) {
            DirDiffPanel.$$$reportNull$$$0(0);
        }
        return anActionArray;
    }

    public JComponent extractFilterPanel() {
        this.myToolbarPanel.setVisible(false);
        return this.myFilterPanel;
    }

    private void changeOperationForSelection() {
        for (int row : this.myTable.getSelectedRows()) {
            DirDiffElementImpl element;
            if (row == -1 || (element = this.myModel.getElementAt(row)) == null) continue;
            element.setNextOperation();
            this.myModel.fireTableRowsUpdated(row, row);
        }
    }

    public void update(boolean force) {
        this.myDiffRequestProcessor.updateRequest(force);
    }

    private static void registerCustomShortcuts(DirDiffToolbarActions actions, JComponent component2) {
        for (AnAction action2 : actions.getActions()) {
            ShortcutSet shortcut;
            if (!(action2 instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action2).getShortcut()) == null) continue;
            action2.registerCustomShortcutSet(shortcut, component2);
        }
    }

    public void focusTable() {
        IdeFocusManager focusManager = this.myProject == null || this.myProject.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)this.myProject);
        focusManager.requestFocus((Component)this.myTable, true);
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private void fireFilterUpdated() {
        String newFilter = this.myFilter.getFilter();
        if (!StringUtil.equals((CharSequence)this.myModel.getSettings().getFilter(), (CharSequence)newFilter)) {
            this.myModel.getSettings().setFilter(newFilter);
            this.myModel.applySettings();
        }
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void dispose() {
        this.myModel.stopUpdating();
    }

    private void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DirDiffPanel.$$$reportNull$$$0(1);
        }
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
        sink.set(DIR_DIFF_MODEL, (Object)this.myModel);
        sink.set(DIR_DIFF_TABLE, (Object)this.myTable);
        sink.set(DIR_DIFF_FILTER, (Object)this.myFilter);
        sink.set(DiffDataKeys.NAVIGATABLE_ARRAY, (Object)this.getNavigatableArray());
        sink.set(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE, (Object)new MyPrevNextDifferenceIterable());
    }

    private Navigatable @NotNull [] getNavigatableArray() {
        List<DirDiffElementImpl> elements = this.myModel.getSelectedElements();
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (DirDiffElementImpl element : elements) {
            Navigatable navigatable2;
            DiffElement source = element.getSource();
            DiffElement target = element.getTarget();
            Navigatable navigatable1 = source != null ? source.getNavigatable(this.myProject) : null;
            Navigatable navigatable = navigatable2 = target != null ? target.getNavigatable(this.myProject) : null;
            if (navigatable1 != null) {
                navigatables.add(navigatable1);
            }
            if (navigatable2 == null) continue;
            navigatables.add(navigatable2);
        }
        Navigatable[] navigatableArray = navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        if (navigatableArray == null) {
            DirDiffPanel.$$$reportNull$$$0(2);
        }
        return navigatableArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class MyJBTable
    extends JBTable {
        private MyJBTable() {
        }

        public void doLayout() {
            super.doLayout();
            int totalWidth1 = 0;
            int totalWidth2 = 0;
            for (int i = 0; i < (this.columnModel.getColumnCount() - 1) / 2; ++i) {
                TableColumn column1 = this.columnModel.getColumn(i);
                TableColumn column2 = this.columnModel.getColumn(this.columnModel.getColumnCount() - i - 1);
                int delta = (column2.getWidth() - column1.getWidth()) / 2;
                if (Math.abs(delta) > 0) {
                    column1.setWidth(column1.getWidth() + delta);
                    column2.setWidth(column2.getWidth() - delta);
                }
                totalWidth1 += column1.getWidth();
                totalWidth2 += column2.getWidth();
            }
            TableColumn column1 = this.columnModel.getColumn(0);
            TableColumn column2 = this.columnModel.getColumn(this.columnModel.getColumnCount() - 1);
            int delta = (totalWidth2 - totalWidth1) / 2;
            if (Math.abs(delta) > 0) {
                column1.setWidth(column1.getWidth() + delta);
                column2.setWidth(column2.getWidth() - delta);
                totalWidth1 += delta;
                totalWidth2 -= delta;
            }
            if (totalWidth1 != totalWidth2 && totalWidth1 % 2 != 0) {
                column1.setWidth(column1.getWidth() - 1);
                column2.setWidth(column2.getWidth() + 1);
            }
        }
    }

    private class MyFilterComponent
    extends FilterComponent {
        MyFilterComponent() {
            super("dir.diff.filter", 15, false);
            DumbAwareAction.create(e -> this.userTriggeredFilter()).registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)this));
        }

        public void filter() {
            DirDiffPanel.this.fireFilterUpdated();
        }

        protected void onEscape(@NotNull KeyEvent e) {
            if (e == null) {
                MyFilterComponent.$$$reportNull$$$0(0);
            }
            e.consume();
            DirDiffPanel.this.focusTable();
        }

        protected JComponent getPopupLocationComponent() {
            return UIUtil.findComponentOfType((JComponent)super.getPopupLocationComponent(), JTextComponent.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyFilterComponent", "onEscape"));
        }
    }

    @ApiStatus.Internal
    public class MainPanel
    extends JPanel {
        private boolean myFirstUpdate;

        MainPanel() {
            super(new BorderLayout());
            this.myFirstUpdate = true;
        }

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.myFirstUpdate) {
                this.myFirstUpdate = false;
                DirDiffPanel.this.myModel.reloadModel(false);
            }
        }
    }

    private class MyDiffRequestProcessor
    extends CacheDiffRequestProcessor<ElementWrapper> {
        MyDiffRequestProcessor(Project project) {
            super(project, "DirDiff");
        }

        @Override
        @Nullable
        protected String getRequestName(@NotNull ElementWrapper element) {
            if (element == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        protected ElementWrapper getCurrentRequestProvider() {
            DirDiffElementImpl element = DirDiffPanel.this.myModel.getElementAt(DirDiffPanel.this.myTable.getSelectedRow());
            return element != null ? new ElementWrapper(element) : null;
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ElementWrapper element, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            if (element == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(2);
            }
            DiffElement sourceElement = element.sourceElement;
            DiffElement targetElement = element.targetElement;
            EmptyContent sourceContent = sourceElement != null ? sourceElement.createDiffContent(DirDiffPanel.this.myProject, indicator) : DiffContentFactory.getInstance().createEmpty();
            EmptyContent targetContent = targetElement != null ? targetElement.createDiffContent(DirDiffPanel.this.myProject, indicator) : DiffContentFactory.getInstance().createEmpty();
            return new SimpleDiffRequest(null, (DiffContent)sourceContent, (DiffContent)targetContent, null, null);
        }

        @Override
        protected boolean hasNextChange(boolean fromUpdate) {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        protected boolean hasPrevChange(boolean fromUpdate) {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        protected void goToNextChange(boolean fromDifferences) {
            this.goToNextChangeImpl(fromDifferences, () -> DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false));
        }

        @Override
        protected void goToPrevChange(boolean fromDifferences) {
            this.goToPrevChangeImpl(fromDifferences, () -> DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false));
        }

        @Override
        protected boolean isNavigationEnabled() {
            return DirDiffPanel.this.myModel.getRowCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyDiffRequestProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRequestName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoPrev() {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        public boolean canGoNext() {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        public void goPrev() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false);
        }

        @Override
        public void goNext() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false);
        }
    }

    private static class ElementWrapper {
        @Nullable
        public final DiffElement sourceElement;
        @Nullable
        public final DiffElement targetElement;

        ElementWrapper(@NotNull DirDiffElementImpl element) {
            if (element == null) {
                ElementWrapper.$$$reportNull$$$0(0);
            }
            this.sourceElement = element.getSource();
            this.targetElement = element.getTarget();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementWrapper wrapper = (ElementWrapper)o;
            return Objects.equals(this.sourceElement, wrapper.sourceElement) && Objects.equals(this.targetElement, wrapper.targetElement);
        }

        public int hashCode() {
            int result = this.sourceElement != null ? this.sourceElement.hashCode() : 0;
            result = 31 * result + (this.targetElement != null ? this.targetElement.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$ElementWrapper", "<init>"));
        }
    }
}

