/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.DiffRequestSelectionChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0016\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J(\u0010\u001a\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J.\u0010\u001a\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0!H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\"\u0010%\u001a\u00020&2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0017H\u0007J\u0010\u0010(\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/diff/tools/external/ExternalDiffTool;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ERROR_NOTIFICATION_GROUP_ID", "", "isEnabled", "", "isDefault", "wantShowExternalToolFor", "diffProducers", "", "Lcom/intellij/diff/chains/DiffRequestProducer;", "getProducerFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "producer", "checkNotTooManyRequests", "project", "Lcom/intellij/openapi/project/Project;", "getExternalToolFor", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "showIfNeeded", "chain", "Lcom/intellij/diff/chains/DiffRequestChain;", "hints", "Lcom/intellij/diff/DiffDialogHints;", "requestProducers", "requestProducer", "Lkotlin/Function0;", "collectRequestsForExternalTool", "Lcom/intellij/diff/tools/external/ExternalDiffTool$RequestsByTool;", "producers", "showRequest", "", "externalDiffTool", "canShow", "RequestsByTool", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExternalDiffTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalDiffTool.kt\ncom/intellij/diff/tools/external/ExternalDiffTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,254:1\n1586#2:255\n1661#2,3:256\n1586#2:260\n1661#2,3:261\n614#3:259\n*S KotlinDebug\n*F\n+ 1 ExternalDiffTool.kt\ncom/intellij/diff/tools/external/ExternalDiffTool\n*L\n88#1:255\n88#1:256,3\n208#1:260\n208#1:261,3\n94#1:259\n*E\n"})
public final class ExternalDiffTool {
    @NotNull
    public static final ExternalDiffTool INSTANCE = new ExternalDiffTool();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String ERROR_NOTIFICATION_GROUP_ID = "Diff Changes Loading Error";

    private ExternalDiffTool() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isEnabled() {
        if (!ExternalDiffSettings.Companion.getInstance().isExternalToolsEnabled()) return false;
        List list = ExternalDiffSettings.Companion.getInstance().getExternalTools().get((Object)ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (((Collection)list).isEmpty()) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isDefault() {
        return ExternalDiffTool.isEnabled() && ExternalDiffSettings.Companion.isNotBuiltinDiffTool();
    }

    @JvmStatic
    public static final boolean wantShowExternalToolFor(@NotNull List<? extends DiffRequestProducer> diffProducers) {
        Intrinsics.checkNotNullParameter(diffProducers, (String)"diffProducers");
        if (ExternalDiffTool.isDefault()) {
            return true;
        }
        return SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)diffProducers), ExternalDiffTool::wantShowExternalToolFor$lambda$0)), ExternalDiffTool::wantShowExternalToolFor$lambda$1)) != null;
    }

    private final FileType getProducerFileType(DiffRequestProducer producer) {
        FileType contentType = producer.getContentType();
        if (contentType != null) {
            return contentType;
        }
        String string = producer.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String filePath = string;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        return fileType;
    }

    @JvmStatic
    public static final boolean checkNotTooManyRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> diffProducers) {
        Intrinsics.checkNotNullParameter(diffProducers, (String)"diffProducers");
        if (diffProducers.size() <= Registry.Companion.intValue("diff.external.tool.file.limit")) {
            return true;
        }
        Object[] objectArray = new Object[]{diffProducers.size()};
        new Notification(ERROR_NOTIFICATION_GROUP_ID, DiffBundle.message((String)"can.t.show.diff.in.external.tool.too.many.files", (Object[])objectArray), NotificationType.WARNING).setDisplayId("diff.external.too.many.selected").notify(project);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final ExternalDiffSettings.ExternalTool getExternalToolFor(DiffRequestProducer producer, DiffRequest request) {
        void $this$sortedBy$iv;
        ExternalDiffSettings.ExternalTool diffTool;
        void $this$mapTo$iv$iv;
        if (!(request instanceof ContentDiffRequest)) {
            return null;
        }
        if (!ExternalDiffTool.canShow(request)) {
            return null;
        }
        List list = ((ContentDiffRequest)request).getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void content;
            DiffContent diffContent = (DiffContent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(content.getContentType());
        }
        List fileTypes = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)this.getProducerFileType(producer));
        Sequence $i$f$map22 = SequencesKt.distinct((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)fileTypes)));
        boolean $i$f$sortedBy = false;
        ExternalDiffSettings.ExternalTool externalTool = diffTool = (ExternalDiffSettings.ExternalTool)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FileType fileType = (FileType)a;
                boolean bl = false;
                int n = fileType != UnknownFileType.INSTANCE ? -1 : 1;
                fileType = (FileType)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(fileType != UnknownFileType.INSTANCE ? -1 : 1));
            }
        }), ExternalDiffTool::getExternalToolFor$lambda$2));
        if (externalTool != null) {
            return externalTool;
        }
        if (ExternalDiffTool.isDefault()) {
            return ExternalDiffSettings.Companion.findDefaultDiffTool();
        }
        return null;
    }

    @JvmStatic
    @RequiresEdt
    public static final boolean showIfNeeded(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        ListSelection listSelection;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        if (chain instanceof AsyncDiffRequestChain) {
            return INSTANCE.showIfNeeded(project, hints, (Function0<? extends List<? extends DiffRequestProducer>>)((Function0)() -> ExternalDiffTool.showIfNeeded$lambda$0(chain)));
        }
        if (chain instanceof DiffRequestSelectionChain) {
            ListSelection listSelection2 = ((DiffRequestSelectionChain)chain).getListSelection();
            listSelection = listSelection2;
            Intrinsics.checkNotNullExpressionValue((Object)listSelection2, (String)"getListSelection(...)");
        } else {
            ListSelection listSelection3 = ListSelection.createAt((List)chain.getRequests(), (int)chain.getIndex());
            listSelection = listSelection3;
            Intrinsics.checkNotNullExpressionValue((Object)listSelection3, (String)"createAt(...)");
        }
        ListSelection listSelection4 = listSelection;
        return INSTANCE.showIfNeeded(project, hints, (Function0<? extends List<? extends DiffRequestProducer>>)((Function0)() -> ExternalDiffTool.showIfNeeded$lambda$1(listSelection4)));
    }

    @JvmStatic
    public static final boolean showIfNeeded(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> requestProducers, @NotNull DiffDialogHints hints) {
        Intrinsics.checkNotNullParameter(requestProducers, (String)"requestProducers");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        return INSTANCE.showIfNeeded(project, hints, (Function0<? extends List<? extends DiffRequestProducer>>)((Function0)() -> ExternalDiffTool.showIfNeeded$lambda$2(requestProducers)));
    }

    private final boolean showIfNeeded(Project project, DiffDialogHints hints, Function0<? extends List<? extends DiffRequestProducer>> requestProducer) {
        try {
            Project project2 = project;
            ModalTaskOwner modalTaskOwner = project2 != null ? ModalTaskOwner.project((Project)project2) : ModalTaskOwner.guess();
            Intrinsics.checkNotNull((Object)modalTaskOwner);
            String string = DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            RequestsByTool requestsByTool2 = (RequestsByTool)TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RequestsByTool>, Object>(requestProducer, project, null){
                int label;
                final /* synthetic */ Function0<List<DiffRequestProducer>> $requestProducer;
                final /* synthetic */ Project $project;
                {
                    this.$requestProducer = $requestProducer;
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> showIfNeeded.requestsByTool.1.invokeSuspend$lambda$0(this.$requestProducer, this.$project, arg_0), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super RequestsByTool> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final RequestsByTool invokeSuspend$lambda$0(Function0 $requestProducer, Project $project, ProgressIndicator it) {
                    List requestProducers = (List)$requestProducer.invoke();
                    return ExternalDiffTool.access$collectRequestsForExternalTool(ExternalDiffTool.INSTANCE, $project, requestProducers);
                }
            }), (int)4, null);
            if (requestsByTool2 == null) {
                return false;
            }
            if (requestsByTool2.getShowByExternalTool().isEmpty()) {
                return false;
            }
            for (Map.Entry entry : requestsByTool2.getShowByExternalTool().entrySet()) {
                ExternalDiffSettings.ExternalTool externalTool = (ExternalDiffSettings.ExternalTool)entry.getKey();
                List requests = (List)entry.getValue();
                for (DiffRequest request : requests) {
                    ExternalDiffTool.showRequest(project, request, externalTool);
                }
            }
            if (!requestsByTool2.getShowInBuiltin().isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(requestsByTool2.getShowInBuiltin()), hints);
            }
            return true;
        }
        catch (ProcessCanceledException requestsByTool2) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final RequestsByTool collectRequestsForExternalTool(Project project, List<? extends DiffRequestProducer> producers) {
        if (!ExternalDiffTool.wantShowExternalToolFor(producers)) {
            return null;
        }
        if (!ExternalDiffTool.checkNotTooManyRequests(project, producers)) {
            return null;
        }
        List showInBuiltin = new ArrayList();
        Map showByExternalTool = new LinkedHashMap();
        UserDataHolderBase context = new UserDataHolderBase();
        List errorRequests = new ArrayList();
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                boolean bl;
                DiffRequest request;
                Intrinsics.checkNotNullExpressionValue((Object)diffRequestProducer.process((UserDataHolder)context, indicator), (String)"process(...)");
                ExternalDiffSettings.ExternalTool externalTool = this.getExternalToolFor(diffRequestProducer, request);
                if (externalTool != null) {
                    List toolRequests;
                    Intrinsics.checkNotNullExpressionValue((Object)showByExternalTool.computeIfAbsent(externalTool, arg_0 -> ExternalDiffTool.collectRequestsForExternalTool$lambda$1(ExternalDiffTool::collectRequestsForExternalTool$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
                    bl = toolRequests.add(request);
                    continue;
                }
                bl = showInBuiltin.add(request);
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(diffRequestProducer);
            }
        }
        if (!errorRequests.isEmpty()) {
            Collection<HtmlChunk> collection;
            void $this$mapTo$iv$iv;
            Iterable iterable = errorRequests;
            HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
            HtmlBuilder htmlBuilder = new HtmlBuilder();
            boolean $i$f$map = false;
            Iterable e = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void producer2;
                DiffRequestProducer diffRequestProducer = (DiffRequestProducer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(HtmlChunk.text((String)producer2.getName()));
            }
            collection = (List)destination$iv$iv;
            HtmlBuilder message = htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
            new Notification(ERROR_NOTIFICATION_GROUP_ID, DiffBundle.message((String)"can.t.load.some.changes", (Object[])new Object[0]), message.toString(), NotificationType.ERROR).setDisplayId("diff.external.cant.load.changes").notify(project);
        }
        return new RequestsByTool(showByExternalTool, showInBuiltin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void showRequest(@Nullable Project project, @NotNull DiffRequest request, @NotNull ExternalDiffSettings.ExternalTool externalDiffTool) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)externalDiffTool, (String)"externalDiffTool");
        ContentDiffRequest cfr_ignored_0 = (ContentDiffRequest)request;
        request.onAssigned(true);
        try {
            List list = ((ContentDiffRequest)request).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            List contents = list;
            List list2 = ((ContentDiffRequest)request).getContentTitles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContentTitles(...)");
            List titles = list2;
            ExternalDiffToolUtil.executeDiff(project, externalDiffTool, contents, titles, request.getTitle());
        }
        finally {
            request.onAssigned(false);
        }
    }

    @JvmStatic
    public static final boolean canShow(@NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List list = ((ContentDiffRequest)request).getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        List contents = list;
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content)) continue;
            return false;
        }
        return true;
    }

    private static final FileType wantShowExternalToolFor$lambda$0(DiffRequestProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        return INSTANCE.getProducerFileType(producer);
    }

    private static final ExternalDiffSettings.ExternalTool wantShowExternalToolFor$lambda$1(FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return ExternalDiffSettings.Companion.findDiffTool(fileType);
    }

    private static final ExternalDiffSettings.ExternalTool getExternalToolFor$lambda$2(FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return ExternalDiffSettings.Companion.findDiffTool(fileType);
    }

    private static final List showIfNeeded$lambda$0(DiffRequestChain $chain) {
        List list = ((AsyncDiffRequestChain)$chain).loadRequestsInBackground().getExplicitSelection();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExplicitSelection(...)");
        return list;
    }

    private static final List showIfNeeded$lambda$1(ListSelection $listSelection) {
        List list = $listSelection.getExplicitSelection();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExplicitSelection(...)");
        return list;
    }

    private static final List showIfNeeded$lambda$2(List $requestProducers) {
        return $requestProducers;
    }

    private static final List collectRequestsForExternalTool$lambda$0(ExternalDiffSettings.ExternalTool it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List collectRequestsForExternalTool$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ RequestsByTool access$collectRequestsForExternalTool(ExternalDiffTool $this, Project project, List producers) {
        return $this.collectRequestsForExternalTool(project, producers);
    }

    static {
        Logger logger = Logger.getInstance(ExternalDiffTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/tools/external/ExternalDiffTool$RequestsByTool;", "", "showByExternalTool", "", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "", "Lcom/intellij/diff/requests/DiffRequest;", "showInBuiltin", "<init>", "(Ljava/util/Map;Ljava/util/List;)V", "getShowByExternalTool", "()Ljava/util/Map;", "getShowInBuiltin", "()Ljava/util/List;", "intellij.platform.diff.impl"})
    private static final class RequestsByTool {
        @NotNull
        private final Map<ExternalDiffSettings.ExternalTool, List<DiffRequest>> showByExternalTool;
        @NotNull
        private final List<DiffRequest> showInBuiltin;

        public RequestsByTool(@NotNull Map<ExternalDiffSettings.ExternalTool, ? extends List<? extends DiffRequest>> showByExternalTool, @NotNull List<? extends DiffRequest> showInBuiltin) {
            Intrinsics.checkNotNullParameter(showByExternalTool, (String)"showByExternalTool");
            Intrinsics.checkNotNullParameter(showInBuiltin, (String)"showInBuiltin");
            this.showByExternalTool = showByExternalTool;
            this.showInBuiltin = showInBuiltin;
        }

        @NotNull
        public final Map<ExternalDiffSettings.ExternalTool, List<DiffRequest>> getShowByExternalTool() {
            return this.showByExternalTool;
        }

        @NotNull
        public final List<DiffRequest> getShowInBuiltin() {
            return this.showInBuiltin;
        }
    }
}

