/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBlockOperations;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LineStatusTrackerListener;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.BitSet;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 v*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004stuvB\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00101\u001a\u00020\"H\u0015J\b\u00102\u001a\u00020\"H\u0014J\u0015\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u00020\u001aH$\u00a2\u0006\u0002\u00105J\u0010\u0010:\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'H\u0016J \u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010@H\u0015J\b\u0010A\u001a\u00020<H\u0007J\u0006\u0010B\u001a\u00020<J$\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020<0GH\u0005J3\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020E2\r\u0010H\u001a\t\u0018\u00010I\u00a2\u0006\u0002\bJ2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020<0GH\u0005J\u0010\u0010K\u001a\u00020<2\u0006\u0010F\u001a\u00020LH\u0017J!\u0010M\u001a\u0002HN\"\u0004\b\u0001\u0010N2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HN0@H\u0016\u00a2\u0006\u0002\u0010OJ\b\u0010P\u001a\u00020<H\u0004J\b\u0010Q\u001a\u00020\"H\u0016J\b\u0010R\u001a\u00020\"H\u0016J\u0017\u0010S\u001a\u0004\u0018\u00018\u00002\u0006\u0010T\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010UJ\u0017\u0010V\u001a\u0004\u0018\u00018\u00002\u0006\u0010W\u001a\u00020XH\u0016\u00a2\u0006\u0002\u0010YJ\u0017\u0010Z\u001a\u0004\u0018\u00018\u00002\u0006\u0010W\u001a\u00020XH\u0016\u00a2\u0006\u0002\u0010YJ\u0018\u0010[\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'2\u0006\u0010\\\u001a\u00020]H\u0016J\u0017\u0010^\u001a\u0004\u0018\u00018\u00002\u0006\u0010W\u001a\u00020XH\u0016\u00a2\u0006\u0002\u0010YJ\u0010\u0010_\u001a\u00020\"2\u0006\u0010W\u001a\u00020XH\u0016J\u0018\u0010`\u001a\u00020\"2\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u00020XH\u0016J\u0018\u0010c\u001a\u00020X2\u0006\u0010W\u001a\u00020X2\u0006\u0010d\u001a\u00020\"H\u0016J\u0018\u0010e\u001a\u00020X2\u0006\u0010W\u001a\u00020X2\u0006\u0010d\u001a\u00020\"H\u0016J\u0010\u0010f\u001a\u00020<2\u0006\u0010T\u001a\u00020\u0002H\u0017J\u0010\u0010f\u001a\u00020<2\u0006\u0010\\\u001a\u00020]H\u0017J\u001c\u0010g\u001a\u00020<2\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020i0GH\u0005J\u0018\u0010j\u001a\u00020<2\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u00020XH\u0002J\u0010\u0010k\u001a\u00020<2\u0006\u0010l\u001a\u00020,H\u0016J\u0010\u0010m\u001a\u00020<2\u0006\u0010l\u001a\u00020,H\u0016J\n\u0010r\u001a\u00020IH\u0096\u0080\u0004R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R'\u0010*\u001a\u0015\u0012\f\u0012\n -*\u0004\u0018\u00010,0,0+\u00a2\u0006\u0002\b.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0016\u00106\u001a\u0004\u0018\u0001078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010n\u001a\u00020o*\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u0010q\u00a8\u0006w"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "vcsDocument", "getVcsDocument", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "getLOCK$intellij_platform_diff_impl", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "blockOperations", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlockOperations", "()Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "documentTracker", "Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "getDocumentTracker", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "value", "", "isReleased", "()Z", "isInitialized", "blocks", "", "getBlocks", "()Ljava/util/List;", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getListeners", "()Lcom/intellij/util/EventDispatcher;", "isDetectWhitespaceChangedLines", "isClearLineModificationFlagOnRollback", "toRange", "block", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/Range;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRanges", "setBaseRevisionContent", "", "vcsContent", "", "beforeUnfreeze", "Lkotlin/Function0;", "dropBaseRevision", "release", "updateDocument", "side", "Lcom/intellij/diff/util/Side;", "task", "Lkotlin/Function1;", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "doFrozen", "Ljava/lang/Runnable;", "readLock", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "updateHighlighters", "isOperational", "isValid", "findRange", "range", "(Lcom/intellij/openapi/vcs/ex/Range;)Lcom/intellij/openapi/vcs/ex/Range;", "getNextRange", "line", "", "(I)Lcom/intellij/openapi/vcs/ex/Range;", "getPrevRange", "getRangesForLines", "lines", "Ljava/util/BitSet;", "getRangeForLine", "isLineModified", "isRangeModified", "startLine", "endLine", "transferLineFromVcs", "approximate", "transferLineToVcs", "rollbackChanges", "runBulkRollback", "condition", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "fireLinesUnchanged", "addListener", "listener", "removeListener", "ourData", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "getOurData", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "toString", "MyBlockOperations", "MyDocumentTrackerHandler", "InnerRangesDocumentTrackerHandler", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nLineStatusTrackerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerBase.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBase\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker\n+ 3 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n*L\n1#1,342:1\n141#2,8:343\n132#2,17:351\n132#2,17:368\n558#3:385\n558#3:386\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerBase.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBase\n*L\n80#1:343,8\n104#1:351,17\n143#1:368,17\n225#1:385\n229#1:386\n*E\n"})
public abstract class LineStatusTrackerBase<R extends Range>
implements LineStatusTrackerI<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final Document vcsDocument;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final DocumentTracker.Lock LOCK;
    @NotNull
    private final LineStatusTrackerBlockOperations<R, DocumentTracker.Block> blockOperations;
    @NotNull
    private final DocumentTracker documentTracker;
    private boolean isReleased;
    private boolean isInitialized;
    @NotNull
    private final EventDispatcher<LineStatusTrackerListener> listeners;
    @NotNull
    private static final Key<Boolean> VCS_DOCUMENT_KEY;
    @NotNull
    private static final Key<Boolean> SEPARATE_UNDO_STACK;

    public LineStatusTrackerBase(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
        this.vcsDocument = Companion.createVcsDocument(this.document);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.LOCK = new DocumentTracker.Lock();
        this.blockOperations = new MyBlockOperations(this.LOCK);
        this.documentTracker = new DocumentTracker(this.vcsDocument, this.document, this.LOCK);
        EventDispatcher eventDispatcher = EventDispatcher.create(LineStatusTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        Disposer.register((Disposable)this.disposable, (Disposable)this.documentTracker);
        this.documentTracker.addHandler(new MyDocumentTrackerHandler());
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public final Document getVcsDocument() {
        return this.vcsDocument;
    }

    @Override
    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final DocumentTracker.Lock getLOCK$intellij_platform_diff_impl() {
        return this.LOCK;
    }

    @NotNull
    public final LineStatusTrackerBlockOperations<R, DocumentTracker.Block> getBlockOperations() {
        return this.blockOperations;
    }

    @NotNull
    public final DocumentTracker getDocumentTracker() {
        return this.documentTracker;
    }

    @Override
    public final boolean isReleased() {
        return this.isReleased;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.documentTracker.getBlocks();
    }

    @NotNull
    protected final EventDispatcher<LineStatusTrackerListener> getListeners() {
        return this.listeners;
    }

    @RequiresEdt
    protected boolean isDetectWhitespaceChangedLines() {
        return false;
    }

    protected boolean isClearLineModificationFlagOnRollback() {
        return false;
    }

    @NotNull
    protected abstract R toRange(@NotNull DocumentTracker.Block var1);

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    @Nullable
    public List<R> getRanges() {
        EditorThreading.Companion.assertInteractionAllowed();
        return this.blockOperations.getRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void setBaseRevisionContent(@NotNull CharSequence vcsContent, @Nullable Function0<Unit> beforeUnfreeze) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isReleased) {
            return;
        }
        DocumentTracker documentTracker = this.documentTracker;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side$iv);
        try {
            boolean bl = false;
            this.updateDocument(Side.LEFT, (Function1<Document, Unit>)((Function1)arg_0 -> LineStatusTrackerBase.setBaseRevisionContent$lambda$0$0(this, vcsContent, arg_0)));
            Function0<Unit> function0 = beforeUnfreeze;
            if (function0 != null) {
                function0.invoke();
            }
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.updateHighlighters();
        }
        if (this.isValid()) {
            ((LineStatusTrackerListener)this.listeners.getMulticaster()).onBecomingValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void dropBaseRevision() {
        void this_$iv$iv;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isReleased || !this.isInitialized) {
            return;
        }
        this.isInitialized = false;
        this.updateHighlighters();
        DocumentTracker this_$iv = this.documentTracker;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                this.updateDocument(Side.LEFT, (Function1<Document, Unit>)((Function1)arg_0 -> LineStatusTrackerBase.dropBaseRevision$lambda$0$0(this, arg_0)));
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    public final void release() {
        Runnable runnable = () -> LineStatusTrackerBase.release$lambda$0(this);
        if (!ApplicationManager.getApplication().isDispatchThread() || this.LOCK.isHeldByCurrentThread()) {
            ApplicationManager.getApplication().invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    @RequiresEdt
    protected final boolean updateDocument(@NotNull Side side, @NotNull Function1<? super Document, Unit> task) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return this.updateDocument(side, null, task);
    }

    @RequiresEdt
    protected final boolean updateDocument(@NotNull Side side, @Nullable String commandName, @NotNull Function1<? super Document, Unit> task) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Document affectedDocument = side.isLeft() ? this.vcsDocument : this.document;
        return Companion.updateDocument(this.getProject(), affectedDocument, commandName, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void doFrozen(@NotNull Runnable task) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DocumentTracker this_$iv = this.documentTracker;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                task.run();
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    @Override
    public <T> T readLock(@NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return this.documentTracker.readLock(task);
    }

    protected final void updateHighlighters() {
        ((LineStatusTrackerListener)this.listeners.getMulticaster()).onRangesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOperational() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.isInitialized && !this.isReleased;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.isOperational() && !this.documentTracker.isFrozen();
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nullable
    public R findRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.blockOperations.findRange(range);
    }

    @Override
    @Nullable
    public R getNextRange(int line) {
        return this.blockOperations.getNextRange(line);
    }

    @Override
    @Nullable
    public R getPrevRange(int line) {
        return this.blockOperations.getPrevRange(line);
    }

    @Override
    @Nullable
    public List<R> getRangesForLines(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return this.blockOperations.getRangesForLines(lines);
    }

    @Override
    @Nullable
    public R getRangeForLine(int line) {
        return this.blockOperations.getRangeForLine(line);
    }

    @Override
    public boolean isLineModified(int line) {
        return this.blockOperations.isLineModified(line);
    }

    @Override
    public boolean isRangeModified(int startLine, int endLine) {
        return this.blockOperations.isRangeModified(startLine, endLine);
    }

    @Override
    public int transferLineFromVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineFromVcs(line, approximate);
    }

    @Override
    public int transferLineToVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineToVcs(line, approximate);
    }

    @Override
    @RequiresEdt
    public void rollbackChanges(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DocumentTracker.Block newRange = this.blockOperations.findBlock(range);
        if (newRange != null) {
            this.runBulkRollback((Function1<DocumentTracker.Block, RangeExclusionState>)((Function1)arg_0 -> LineStatusTrackerBase.rollbackChanges$lambda$0(newRange, arg_0)));
        }
    }

    @Override
    @RequiresEdt
    public void rollbackChanges(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.runBulkRollback((Function1<DocumentTracker.Block, RangeExclusionState>)((Function1)arg_0 -> LineStatusTrackerBase.rollbackChanges$lambda$1(lines, arg_0)));
    }

    @RequiresEdt
    protected final void runBulkRollback(@NotNull Function1<? super DocumentTracker.Block, ? extends RangeExclusionState> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        if (!this.isValid()) {
            return;
        }
        this.updateDocument(Side.RIGHT, DiffBundle.message((String)"rollback.change.command.name", (Object[])new Object[0]), (Function1<Document, Unit>)((Function1)arg_0 -> LineStatusTrackerBase.runBulkRollback$lambda$0(this, condition, arg_0)));
    }

    private final void fireLinesUnchanged(int startLine, int endLine) {
        if (this.isClearLineModificationFlagOnRollback()) {
            DiffUtil.clearLineModificationFlags(this.document, startLine, endLine);
        }
    }

    @Override
    public void addListener(@NotNull LineStatusTrackerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.addListener((EventListener)listener);
    }

    @Override
    public void removeListener(@NotNull LineStatusTrackerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.removeListener((EventListener)listener);
    }

    @NotNull
    protected abstract DocumentTracker.BlockData getOurData(@NotNull DocumentTracker.Block var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void doc;
        String string;
        String string2;
        String string3 = this.getClass().getName();
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null) {
            void file;
            VirtualFile virtualFile2 = virtualFile;
            string2 = string3;
            boolean bl = false;
            string = file.getPath() + (String)(!file.isInLocalFileSystem() ? "@" + (VirtualFile)file : "") + "@" + Integer.toHexString(file.hashCode());
            string3 = string2;
        } else {
            string = null;
        }
        Document document = this.document;
        String string4 = string;
        string2 = string3;
        boolean bl = false;
        String string5 = (Document)doc + "@" + Integer.toHexString(doc.hashCode());
        return string2 + "(file=" + string4 + ", document=" + string5 + ", isReleased=" + this.isReleased + ")@" + Integer.toHexString(this.hashCode());
    }

    private static final Unit setBaseRevisionContent$lambda$0$0(LineStatusTrackerBase this$0, CharSequence $vcsContent, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.vcsDocument.setText($vcsContent);
        return Unit.INSTANCE;
    }

    private static final Unit dropBaseRevision$lambda$0$0(LineStatusTrackerBase this$0, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.vcsDocument.setText(this$0.document.getImmutableCharSequence());
        this$0.documentTracker.setFrozenState(CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    private static final void release$lambda$0(LineStatusTrackerBase this$0) {
        if (this$0.isReleased) {
            return;
        }
        this$0.isReleased = true;
        Disposer.dispose((Disposable)this$0.disposable);
        this$0.listeners.getListeners().clear();
    }

    private static final RangeExclusionState rollbackChanges$lambda$0(DocumentTracker.Block $newRange, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$newRange) ? (RangeExclusionState)RangeExclusionState.Included.INSTANCE : (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
    }

    private static final RangeExclusionState rollbackChanges$lambda$1(BitSet $lines, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LineStatusTrackerBlockOperations.Companion.isSelectedByLine((BlockI)it, $lines) ? (RangeExclusionState)RangeExclusionState.Included.INSTANCE : (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
    }

    private static final Unit runBulkRollback$lambda$0$0(LineStatusTrackerBase this$0, com.intellij.diff.util.Range appliedRange, int shift) {
        Intrinsics.checkNotNullParameter((Object)appliedRange, (String)"appliedRange");
        int start = appliedRange.start2 + shift;
        int length = appliedRange.end1 - appliedRange.start1;
        this$0.fireLinesUnchanged(start, start + length);
        return Unit.INSTANCE;
    }

    private static final Unit runBulkRollback$lambda$0(LineStatusTrackerBase this$0, Function1 $condition, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.documentTracker.partiallyApplyBlocks(Side.RIGHT, (Function1<? super DocumentTracker.Block, ? extends RangeExclusionState>)$condition, (Function2<? super com.intellij.diff.util.Range, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> LineStatusTrackerBase.runBulkRollback$lambda$0$0(this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"LineStatusTrackerBase.VCS_DOCUMENT_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        VCS_DOCUMENT_KEY = key;
        Key key2 = Key.create((String)"LineStatusTrackerBase.SEPARATE_UNDO_STACK");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SEPARATE_UNDO_STACK = key2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ=\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\r\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$Companion;", "", "<init>", "()V", "VCS_DOCUMENT_KEY", "Lcom/intellij/openapi/util/Key;", "", "SEPARATE_UNDO_STACK", "getSEPARATE_UNDO_STACK", "()Lcom/intellij/openapi/util/Key;", "createVcsDocument", "Lcom/intellij/openapi/editor/Document;", "originalDocument", "content", "", "updateDocument", "project", "Lcom/intellij/openapi/project/Project;", "document", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "task", "Lkotlin/Function1;", "", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getSEPARATE_UNDO_STACK() {
            return SEPARATE_UNDO_STACK;
        }

        @NotNull
        public final Document createVcsDocument(@NotNull Document originalDocument) {
            Intrinsics.checkNotNullParameter((Object)originalDocument, (String)"originalDocument");
            CharSequence charSequence = originalDocument.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            return this.createVcsDocument(charSequence);
        }

        @NotNull
        public final Document createVcsDocument(@NotNull CharSequence content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            DocumentImpl result = new DocumentImpl(content, true);
            UndoUtil.disableUndoFor((Document)((Document)result));
            result.putUserData(VCS_DOCUMENT_KEY, (Object)true);
            result.setReadOnly(true);
            return (Document)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final boolean updateDocument(@Nullable Project project, @NotNull Document document, @Nullable String commandName, @NotNull Function1<? super Document, Unit> task) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            UserDataHolder[] userDataHolderArray = new UserDataHolder[]{document};
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)VCS_DOCUMENT_KEY, userDataHolderArray)) {
                document.setReadOnly(false);
                try {
                    task.invoke((Object)document);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    document.setReadOnly(true);
                }
            }
            UserDataHolder[] userDataHolderArray2 = new UserDataHolder[]{document};
            boolean isSeparateUndoStack = DiffUtil.isUserDataFlagSet(this.getSEPARATE_UNDO_STACK(), userDataHolderArray2);
            return DiffUtil.executeWriteCommand(project, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, !isSeparateUndoStack, () -> Companion.updateDocument$lambda$0(task, document));
        }

        private static final void updateDocument$lambda$0(Function1 $task, Document $document) {
            $task.invoke((Object)$document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH&J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0007J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R$\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005*\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$InnerRangesDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;)V", "innerRanges", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "setInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "isDetectWhitespaceChangedLines", "", "onRangeShifted", "", "before", "after", "afterBulkRangeChange", "isDirty", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "updateMissingInnerRanges", "resetInnerRanges", "calcInnerRanges", "block", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerBase.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBase$InnerRangesDocumentTrackerHandler\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n*L\n1#1,342:1\n562#2:343\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerBase.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBase$InnerRangesDocumentTrackerHandler\n*L\n198#1:343\n*E\n"})
    protected abstract class InnerRangesDocumentTrackerHandler
    implements DocumentTracker.Handler {
        @Nullable
        public abstract List<Range.InnerRange> getInnerRanges(@NotNull DocumentTracker.Block var1);

        public abstract void setInnerRanges(@NotNull DocumentTracker.Block var1, @Nullable List<Range.InnerRange> var2);

        public abstract boolean isDetectWhitespaceChangedLines();

        @Override
        public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            this.setInnerRanges(after, this.getInnerRanges(before));
        }

        @Override
        public void afterBulkRangeChange(boolean isDirty) {
            if (!isDirty) {
                this.updateMissingInnerRanges();
            }
        }

        @Override
        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.updateMissingInnerRanges();
        }

        private final void updateMissingInnerRanges() {
            if (!this.isDetectWhitespaceChangedLines()) {
                return;
            }
            if (LineStatusTrackerBase.this.getDocumentTracker().isFrozen()) {
                return;
            }
            for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                if (this.getInnerRanges(block) != null) continue;
                this.setInnerRanges(block, this.calcInnerRanges(block));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @RequiresEdt
        public final void resetInnerRanges() {
            void this_$iv;
            DocumentTracker.Lock lock = LineStatusTrackerBase.this.getLOCK$intellij_platform_diff_impl();
            LineStatusTrackerBase lineStatusTrackerBase = LineStatusTrackerBase.this;
            boolean $i$f$write = false;
            Lock lock2 = this_$iv.getMyLock();
            lock2.lock();
            try {
                boolean bl = false;
                if (this.isDetectWhitespaceChangedLines()) {
                    for (DocumentTracker.Block block : lineStatusTrackerBase.getBlocks()) {
                        this.setInnerRanges(block, this.calcInnerRanges(block));
                    }
                } else {
                    for (DocumentTracker.Block block : lineStatusTrackerBase.getBlocks()) {
                        this.setInnerRanges(block, null);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        private final List<Range.InnerRange> calcInnerRanges(DocumentTracker.Block block) {
            if (block.getStart() == block.getEnd() || block.getVcsStart() == block.getVcsEnd()) {
                return null;
            }
            com.intellij.diff.util.Range range = block.getRange();
            CharSequence charSequence = LineStatusTrackerBase.this.getVcsDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence charSequence2 = LineStatusTrackerBase.this.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
            return RangesBuilder.createInnerRanges(range, charSequence, charSequence2, RangesBuilder.getLineOffsets(LineStatusTrackerBase.this.getVcsDocument()), RangesBuilder.getLineOffsets(LineStatusTrackerBase.this.getDocument()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bH\u0014J\u0011\u0010\t\u001a\u00028\u0000*\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyBlockOperations;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "lock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "getBlocks", "", "toRange", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/Range;", "intellij.platform.diff.impl"})
    private final class MyBlockOperations
    extends LineStatusTrackerBlockOperations<R, DocumentTracker.Block> {
        public MyBlockOperations(DocumentTracker.Lock lock) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            super(lock);
        }

        @Override
        @Nullable
        protected List<DocumentTracker.Block> getBlocks() {
            return LineStatusTrackerBase.this.isValid() ? LineStatusTrackerBase.this.getBlocks() : null;
        }

        @Override
        @NotNull
        protected R toRange(@NotNull DocumentTracker.Block $this$toRange) {
            Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"<this>");
            return LineStatusTrackerBase.this.toRange($this$toRange);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;)V", "afterBulkRangeChange", "", "isDirty", "", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "intellij.platform.diff.impl"})
    private final class MyDocumentTrackerHandler
    implements DocumentTracker.Handler {
        @Override
        public void afterBulkRangeChange(boolean isDirty) {
            LineStatusTrackerBase.this.updateHighlighters();
        }

        @Override
        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            LineStatusTrackerBase.this.updateHighlighters();
            if (LineStatusTrackerBase.this.isValid()) {
                ((LineStatusTrackerListener)LineStatusTrackerBase.this.getListeners().getMulticaster()).onBecomingValid();
            }
        }
    }
}

