/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(0);
        }
        if ((selectedFile = CompareFileWithEditorAction.getSelectedFile(e)) == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        VirtualFile[] array;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(2);
        }
        if ((array = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || array.length != 1 || array[0].isDirectory()) {
            return null;
        }
        return array[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e) {
        FileEditor fileEditor;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(3);
        }
        return (fileEditor = (FileEditor)e.getData(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR)) != null ? fileEditor.getFile() : null;
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(5);
        }
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @NotNull
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(6);
        }
        Project project = e.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        assert (selectedFile != null && currentFile != null);
        MutableDiffRequestChain chain = CompareFileWithEditorAction.createMutableChainFromFiles(project, selectedFile, currentFile);
        DiffContent editorContent = chain.getContent2();
        if (editorContent instanceof DocumentContent && (editor = (Editor)EditorFactory.getInstance().editors(((DocumentContent)editorContent).getDocument()).findFirst().orElse(null)) != null) {
            int currentLine = editor.getCaretModel().getLogicalPosition().line;
            chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        }
        MutableDiffRequestChain mutableDiffRequestChain = chain;
        if (mutableDiffRequestChain == null) {
            CompareFileWithEditorAction.$$$reportNull$$$0(7);
        }
        return mutableDiffRequestChain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareFileWithEditorAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareFileWithEditorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffRequestChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditingFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canCompare";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestChain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

