/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffFileEditorBase;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffEditorViewerListener;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.FileEditorWithTextEditors;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImplKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0002%&B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\"H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/diff/editor/DiffEditorViewerFileEditor;", "Lcom/intellij/diff/editor/DiffFileEditorBase;", "Lcom/intellij/openapi/fileEditor/FileEditorWithTextEditors;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/diff/impl/DiffEditorViewer;)V", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/diff/impl/DiffEditorViewer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditorViewer", "()Lcom/intellij/diff/impl/DiffEditorViewer;", "settings", "Lcom/intellij/diff/impl/DiffSettingsHolder$DiffSettings;", "getSettings", "()Lcom/intellij/diff/impl/DiffSettingsHolder$DiffSettings;", "settings$delegate", "Lkotlin/Lazy;", "dispose", "", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "state", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "selectNotify", "getFilesToRefresh", "", "getEmbeddedEditors", "Lcom/intellij/openapi/editor/Editor;", "MyEditorViewerListener", "Companion", "intellij.platform.diff.impl"})
public class DiffEditorViewerFileEditor
extends DiffFileEditorBase
implements FileEditorWithTextEditors {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final DiffEditorViewer editorViewer;
    @NotNull
    private final Lazy settings$delegate;

    public DiffEditorViewerFileEditor(@Nullable Project project, @NotNull VirtualFile file, @NotNull DiffEditorViewer editorViewer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editorViewer, (String)"editorViewer");
        super(file, editorViewer.getComponent(), editorViewer.getDisposable());
        this.project = project;
        this.editorViewer = editorViewer;
        this.settings$delegate = LazyKt.lazy(DiffEditorViewerFileEditor::settings_delegate$lambda$0);
        this.editorViewer.addListener(new MyEditorViewerListener(), (Disposable)this);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DiffEditorViewer getEditorViewer() {
        return this.editorViewer;
    }

    @Deprecated(message="Use the primary constructor with a 'project' parameter")
    public DiffEditorViewerFileEditor(@NotNull VirtualFile file, @NotNull DiffEditorViewer editorViewer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editorViewer, (String)"editorViewer");
        this(null, file, editorViewer);
    }

    private final DiffSettingsHolder.DiffSettings getSettings() {
        Lazy lazy = this.settings$delegate;
        return (DiffSettingsHolder.DiffSettings)lazy.getValue();
    }

    @Override
    public void dispose() {
        Runnable explicitDisposable = (Runnable)this.editorViewer.getContext().getUserData(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE);
        if (explicitDisposable != null) {
            explicitDisposable.run();
        } else {
            Disposer.dispose((Disposable)((Disposable)this.editorViewer.getDisposable()));
        }
        super.dispose();
    }

    @Override
    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.getSettings().isIncludedInNavigationHistory() == DiffSettingsHolder.IncludeInNavigationHistory.Never) {
            FileEditorState fileEditorState = FileEditorState.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"INSTANCE");
            return fileEditorState;
        }
        return this.editorViewer.getState(level);
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getSettings().isIncludedInNavigationHistory() == DiffSettingsHolder.IncludeInNavigationHistory.Never) {
            return;
        }
        this.editorViewer.setState(state);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.editorViewer.getPreferredFocusedComponent();
    }

    public void selectNotify() {
        DiffFileEditorBase.Companion.editorSelectNotify(this.project, this.editorViewer, this);
    }

    @NotNull
    public List<VirtualFile> getFilesToRefresh() {
        return this.editorViewer.getFilesToRefresh();
    }

    @NotNull
    public List<Editor> getEmbeddedEditors() {
        return this.editorViewer.getEmbeddedEditors();
    }

    private static final DiffSettingsHolder.DiffSettings settings_delegate$lambda$0() {
        return DiffSettingsHolder.DiffSettings.Companion.getSettings();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/editor/DiffEditorViewerFileEditor$Companion;", "", "<init>", "()V", "reloadDiffEditorsForFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "condition", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nDiffEditorViewerFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorViewerFileEditor.kt\ncom/intellij/diff/editor/DiffEditorViewerFileEditor$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n3919#2:106\n4434#2,2:107\n1617#3,9:109\n1869#3:118\n1870#3:120\n1626#3:121\n774#3:122\n865#3,2:123\n1#4:119\n*S KotlinDebug\n*F\n+ 1 DiffEditorViewerFileEditor.kt\ncom/intellij/diff/editor/DiffEditorViewerFileEditor$Companion\n*L\n87#1:106\n87#1:107,2\n88#1:109,9\n88#1:118\n88#1:120\n88#1:121\n89#1:122\n89#1:123,2\n88#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void reloadDiffEditorsForFiles(@NotNull Project project, @NotNull Function1<? super VirtualFile, Boolean> condition) {
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            FileEditor[] fileEditorArray = editorManager.getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] objectArray = fileEditorArray;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                FileEditor it = (FileEditor)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof DiffEditorViewerFileEditor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                FileEditor it = (FileEditor)element$iv$iv;
                boolean bl2 = false;
                if (it.getFile() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)condition.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set diffFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            for (VirtualFile file : diffFiles) {
                FileEditorManagerImplKt.reopenVirtualFileEditor((Project)project, (VirtualFile)file, (VirtualFile)file);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/editor/DiffEditorViewerFileEditor$MyEditorViewerListener;", "Lcom/intellij/diff/impl/DiffEditorViewerListener;", "<init>", "(Lcom/intellij/diff/editor/DiffEditorViewerFileEditor;)V", "onActiveFileChanged", "", "intellij.platform.diff.impl"})
    private final class MyEditorViewerListener
    implements DiffEditorViewerListener {
        @Override
        public void onActiveFileChanged() {
            Project project = DiffEditorViewerFileEditor.this.getEditorViewer().getContext().getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            FileEditorManagerEx.Companion.getInstanceEx(project2).updateFilePresentation(DiffEditorViewerFileEditor.this.getFile());
        }
    }
}

