/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/editor/DiffFileEditorBase;", "Lcom/intellij/diff/util/FileEditorBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "component", "Ljavax/swing/JComponent;", "contentDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljavax/swing/JComponent;Lcom/intellij/openapi/util/CheckedDisposable;)V", "panel", "Lcom/intellij/diff/editor/DiffFileEditorBase$MyPanel;", "getComponent", "isValid", "", "getFile", "getName", "", "Companion", "MyPanel", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDiffFileEditorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffFileEditorBase.kt\ncom/intellij/diff/editor/DiffFileEditorBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n13#2:73\n*S KotlinDebug\n*F\n+ 1 DiffFileEditorBase.kt\ncom/intellij/diff/editor/DiffFileEditorBase\n*L\n32#1:73\n*E\n"})
public abstract class DiffFileEditorBase
extends FileEditorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final CheckedDisposable contentDisposable;
    @NotNull
    private final MyPanel panel;
    @NotNull
    private static final Logger LOG;

    public DiffFileEditorBase(@NotNull VirtualFile file, @NotNull JComponent component2, @NotNull CheckedDisposable contentDisposable) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)contentDisposable, (String)"contentDisposable");
        this.file = file;
        this.contentDisposable = contentDisposable;
        this.panel = new MyPanel(component2);
        Disposer.register((Disposable)((Disposable)this.contentDisposable), () -> DiffFileEditorBase._init_$lambda$0(this));
    }

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && !this.contentDisposable.isDisposed();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final void _init_$lambda$0(DiffFileEditorBase this$0) {
        String string = FileEditor.getPropValid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropValid(...)");
        this$0.firePropertyChange(string, true, false);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffFileEditorBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/editor/DiffFileEditorBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "editorSelectNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "viewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void editorSelectNotify(@Nullable Project project, @NotNull DiffEditorViewer viewer, @NotNull FileEditor fileEditor) {
            Project project2;
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            viewer.fireProcessorActivated();
            Project project3 = project;
            if (project3 == null) {
                project3 = viewer.getContext().getProject();
            }
            if ((project2 = project3) != null) {
                FileEditorManager.getInstance((Project)project2).updateFilePresentation(fileEditor.getFile());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/editor/DiffFileEditorBase$MyPanel;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/diff/editor/DiffFileEditorBase;Ljavax/swing/JComponent;)V", "intellij.platform.diff.impl"})
    private final class MyPanel
    extends JPanel {
        public MyPanel(JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            super(new BorderLayout());
            this.add((Component)component2, "Center");
            this.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    if (DiffFileEditorBase.this.isDisposed()) {
                        return;
                    }
                    LOG.error("DiffRequestProcessor cannot be shown twice, see com.intellij.ide.actions.SplitAction.FORBID_TAB_SPLIT, file: " + DiffFileEditorBase.this.file);
                }
            });
        }
    }
}

