/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeLineFragmentsWithImportMetadata;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.ThreeSide;
import com.intellij.lang.imports.ImportBlockRangeProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diff/merge/MergeImportUtil;", "", "<init>", "()V", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class MergeImportUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final MergeLineFragmentsWithImportMetadata getDividedFromImportsFragments(@NotNull List<? extends CharSequence> sequences, @NotNull ComparisonPolicy policy, @NotNull MergeRange importRange, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return Companion.getDividedFromImportsFragments(sequences, policy, importRange, indicator);
    }

    @JvmStatic
    @Nullable
    public static final MergeRange getImportMergeRange(@Nullable Project project, @NotNull List<PsiFile> psiFiles) {
        return Companion.getImportMergeRange(project, psiFiles);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getPsiFile(@NotNull ThreeSide side, @NotNull Project project, @NotNull TextMergeRequest mergeRequest) {
        return Companion.getPsiFile(side, project, mergeRequest);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\"\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lcom/intellij/diff/merge/MergeImportUtil$Companion;", "", "<init>", "()V", "getDividedFromImportsFragments", "Lcom/intellij/diff/merge/MergeLineFragmentsWithImportMetadata;", "sequences", "", "", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "importRange", "Lcom/intellij/diff/util/MergeRange;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getImportMergeRange", "project", "Lcom/intellij/openapi/project/Project;", "psiFiles", "", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "side", "Lcom/intellij/diff/util/ThreeSide;", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "getImportLineRange", "Lcom/intellij/diff/util/LineRange;", "psiFile", "isEnabledFor", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MergeLineFragmentsWithImportMetadata getDividedFromImportsFragments(@NotNull List<? extends CharSequence> sequences, @NotNull ComparisonPolicy policy, @NotNull MergeRange importRange, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
            Intrinsics.checkNotNullParameter(sequences, (String)"sequences");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)importRange, (String)"importRange");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            ComparisonManager comparisonManager = ComparisonManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
            ComparisonManager manager = comparisonManager;
            List result = new ArrayList();
            Collection collection = result;
            List list = manager.mergeLinesWithinRange(sequences.get(0), sequences.get(1), sequences.get(2), policy, new MergeRange(0, importRange.start1, 0, importRange.start2, 0, importRange.start3), indicator);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mergeLinesWithinRange(...)");
            CollectionsKt.addAll((Collection)collection, (Iterable)list);
            int importBlockStart = result.size();
            Collection collection2 = result;
            List list2 = manager.mergeLinesWithinRange(sequences.get(0), sequences.get(1), sequences.get(2), policy, new MergeRange(importRange.start1, importRange.end1, importRange.start2, importRange.end2, importRange.start3, importRange.end3), indicator);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"mergeLinesWithinRange(...)");
            CollectionsKt.addAll((Collection)collection2, (Iterable)list2);
            int importBlockEnd = result.size();
            Collection collection3 = result;
            List list3 = manager.mergeLinesWithinRange(sequences.get(0), sequences.get(1), sequences.get(2), policy, new MergeRange(importRange.end1, LineOffsetsUtil.create(sequences.get(0)).getLineCount(), importRange.end2, LineOffsetsUtil.create(sequences.get(1)).getLineCount(), importRange.end3, LineOffsetsUtil.create(sequences.get(2)).getLineCount()), indicator);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"mergeLinesWithinRange(...)");
            CollectionsKt.addAll((Collection)collection3, (Iterable)list3);
            return new MergeLineFragmentsWithImportMetadata(result, importBlockStart, importBlockEnd);
        }

        @JvmStatic
        @Nullable
        public final MergeRange getImportMergeRange(@Nullable Project project, @NotNull List<PsiFile> psiFiles) {
            Intrinsics.checkNotNullParameter(psiFiles, (String)"psiFiles");
            if (project == null || psiFiles.size() != 3) {
                return null;
            }
            ArrayList<LineRange> ranges = new ArrayList<LineRange>();
            for (ThreeSide side : ThreeSide.getEntries()) {
                LineRange importRange;
                PsiFile psiFile;
                if ((PsiFile)side.select(psiFiles) == null) {
                    return null;
                }
                if (this.getImportLineRange(psiFile) == null) {
                    return null;
                }
                ranges.add(importRange);
            }
            return new MergeRange(((LineRange)ranges.get((int)0)).start, ((LineRange)ranges.get((int)0)).end, ((LineRange)ranges.get((int)1)).start, ((LineRange)ranges.get((int)1)).end, ((LineRange)ranges.get((int)2)).start, ((LineRange)ranges.get((int)2)).end);
        }

        @JvmStatic
        @Nullable
        public final PsiFile getPsiFile(@NotNull ThreeSide side, @NotNull Project project, @NotNull TextMergeRequest mergeRequest) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
            List list = mergeRequest.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            Document document = ((DocumentContent)side.select(list)).getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document sourceDocument = document;
            VirtualFile file = FileDocumentManager.getInstance().getFile(sourceDocument);
            if (file == null) {
                return null;
            }
            return PsiManager.getInstance((Project)project).findFile(file);
        }

        private final LineRange getImportLineRange(PsiFile psiFile) {
            TextRange textRange = ImportBlockRangeProvider.Companion.getRange(psiFile);
            if (textRange == null) {
                return null;
            }
            TextRange range = textRange;
            Document document = psiFile.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
            Document document2 = document;
            int startLine = document2.getLineNumber(range.getStartOffset());
            int endLine = range.getStartOffset() == range.getEndOffset() ? startLine : document2.getLineNumber(range.getEndOffset()) + 1;
            return new LineRange(startLine, endLine);
        }

        public final boolean isEnabledFor(@Nullable Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            if (project == null) {
                return false;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile file = virtualFile;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return false;
            }
            PsiFile psiFile2 = psiFile;
            return ImportBlockRangeProvider.Companion.isFileSupported(psiFile2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

