/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.actions.RecentBlankContent;
import com.intellij.diff.actions.ShowBlankDiffWindowActionKt;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.UIBundle;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.LinkedListWithSum;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0007J\b\u0010$\u001a\u00020\u0015H\u0002R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/diff/util/BlankDiffWindowUtil;", "", "<init>", "()V", "BLANK_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getBLANK_KEY", "()Lcom/intellij/openapi/util/Key;", "REMEMBER_CONTENT_KEY", "createBlankDiffRequestChain", "Lcom/intellij/diff/actions/impl/MutableDiffRequestChain;", "project", "Lcom/intellij/openapi/project/Project;", "content1", "Lcom/intellij/diff/contents/DocumentContent;", "content2", "baseContent", "setupBlankContext", "", "chain", "Lcom/intellij/diff/chains/DiffRequestChain;", "ourRecentFiles", "Lcom/intellij/util/containers/LinkedListWithSum;", "Lcom/intellij/diff/actions/RecentBlankContent;", "getRecentFiles", "", "getRecentFiles$intellij_platform_diff_impl", "saveRecentContents", "request", "Lcom/intellij/diff/requests/DiffRequest;", "saveRecentContent", "content", "Lcom/intellij/diff/contents/DiffContent;", "deleteAfterAllowedMaximum", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nBlankDiffWindowUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlankDiffWindowUtil.kt\ncom/intellij/diff/util/BlankDiffWindowUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class BlankDiffWindowUtil {
    @NotNull
    public static final BlankDiffWindowUtil INSTANCE = new BlankDiffWindowUtil();
    @NotNull
    private static final Key<Boolean> BLANK_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> REMEMBER_CONTENT_KEY;
    @NotNull
    private static final LinkedListWithSum<RecentBlankContent> ourRecentFiles;

    private BlankDiffWindowUtil() {
    }

    @NotNull
    public final Key<Boolean> getBLANK_KEY() {
        return BLANK_KEY;
    }

    @JvmStatic
    @NotNull
    public static final MutableDiffRequestChain createBlankDiffRequestChain(@Nullable Project project) {
        return BlankDiffWindowUtil.createBlankDiffRequestChain$default(ShowBlankDiffWindowActionKt.createEditableContent$default(project, null, 2, null), ShowBlankDiffWindowActionKt.createEditableContent$default(project, null, 2, null), null, project, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MutableDiffRequestChain createBlankDiffRequestChain(@NotNull DocumentContent content1, @NotNull DocumentContent content2, @Nullable DocumentContent baseContent, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        MutableDiffRequestChain chain = new MutableDiffRequestChain((DiffContent)content1, (DiffContent)baseContent, (DiffContent)content2, project);
        chain.putUserData(BLANK_KEY, true);
        return chain;
    }

    public static /* synthetic */ MutableDiffRequestChain createBlankDiffRequestChain$default(DocumentContent documentContent, DocumentContent documentContent2, DocumentContent documentContent3, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            documentContent3 = null;
        }
        if ((n & 8) != 0) {
            project = null;
        }
        return BlankDiffWindowUtil.createBlankDiffRequestChain(documentContent, documentContent2, documentContent3, project);
    }

    @JvmStatic
    public static final void setupBlankContext(@NotNull DiffRequestChain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"BlankDiffWindow");
        chain.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)Side.LEFT);
        chain.putUserData(DiffUserDataKeysEx.DISABLE_CONTENTS_EQUALS_NOTIFICATION, (Object)true);
    }

    @NotNull
    public final List<RecentBlankContent> getRecentFiles$intellij_platform_diff_impl() {
        return CollectionsKt.toList((Iterable)((Iterable)ourRecentFiles));
    }

    @RequiresEdt
    public final void saveRecentContents(@NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof ContentDiffRequest) {
            for (DiffContent content : ((ContentDiffRequest)request).getContents()) {
                Intrinsics.checkNotNull((Object)content);
                this.saveRecentContent(content);
            }
        }
    }

    @RequiresEdt
    public final void saveRecentContent(@NotNull DiffContent content) {
        Object v1;
        String text;
        block6: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            if (!(content instanceof DocumentContent)) {
                return;
            }
            UserDataHolder[] userDataHolderArray = new UserDataHolder[]{content};
            if (!DiffUtil.isUserDataFlagSet(REMEMBER_CONTENT_KEY, userDataHolderArray)) {
                return;
            }
            String string = ((DocumentContent)content).getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            text = string;
            if (StringsKt.isBlank((CharSequence)text)) {
                return;
            }
            Iterable iterable = (Iterable)ourRecentFiles;
            for (Object t : iterable) {
                RecentBlankContent it = (RecentBlankContent)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)text)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        RecentBlankContent oldValue = v1;
        if (oldValue != null) {
            ourRecentFiles.remove((Object)oldValue);
            ourRecentFiles.add(0, (Object)oldValue);
        } else {
            ourRecentFiles.add(0, (Object)new RecentBlankContent(text, System.currentTimeMillis()));
            this.deleteAfterAllowedMaximum();
        }
    }

    private final void deleteAfterAllowedMaximum() {
        int maxCount = Math.max(1, Registry.Companion.intValue("blank.diff.history.max.items"));
        int maxMemory = Math.max(0, Registry.Companion.intValue("blank.diff.history.max.memory"));
        CopyPasteManagerEx.deleteAfterAllowedMaximum(ourRecentFiles, (int)maxCount, (int)maxMemory, arg_0 -> BlankDiffWindowUtil.deleteAfterAllowedMaximum$lambda$1(BlankDiffWindowUtil::deleteAfterAllowedMaximum$lambda$0, arg_0));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MutableDiffRequestChain createBlankDiffRequestChain(@NotNull DocumentContent content1, @NotNull DocumentContent content2, @Nullable DocumentContent baseContent) {
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        return BlankDiffWindowUtil.createBlankDiffRequestChain$default(content1, content2, baseContent, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MutableDiffRequestChain createBlankDiffRequestChain(@NotNull DocumentContent content1, @NotNull DocumentContent content2) {
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        return BlankDiffWindowUtil.createBlankDiffRequestChain$default(content1, content2, null, null, 12, null);
    }

    private static final int ourRecentFiles$lambda$0(RecentBlankContent it) {
        return it.getText().length();
    }

    private static final int ourRecentFiles$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final RecentBlankContent deleteAfterAllowedMaximum$lambda$0(RecentBlankContent item) {
        String string = UIBundle.message((String)"clipboard.history.purged.item", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new RecentBlankContent(string, item.getTimestamp());
    }

    private static final RecentBlankContent deleteAfterAllowedMaximum$lambda$1(Function1 $tmp0, Object p0) {
        return (RecentBlankContent)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"Diff.BlankWindow");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BLANK_KEY = key;
        Key key2 = Key.create((String)"Diff.BlankWindow.BlankContent");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        REMEMBER_CONTENT_KEY = key2;
        ourRecentFiles = new LinkedListWithSum(arg_0 -> BlankDiffWindowUtil.ourRecentFiles$lambda$1(BlankDiffWindowUtil::ourRecentFiles$lambda$0, arg_0));
    }
}

