/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffTool;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DiffUsageTriggerCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.diff.trigger", 8);
    private static final StringEventField DIFF_PLACE_FIELD = EventFields.String((String)"diff_place", List.of("Default", "ChangesView", "VcsLogView", "CommitDialog", "TestsFiledAssertions", "Merge", "DirDiff", "External", "unknown"));
    private static final EventId2<HighlightPolicy, String> TOGGLE_HIGHLIGHT_POLICY = GROUP.registerEvent("toggle.highlight.policy", (EventField)EventFields.Enum((String)"value", HighlightPolicy.class, value -> value.name()), (EventField)DIFF_PLACE_FIELD);
    private static final EventId2<IgnorePolicy, String> TOGGLE_IGNORE_POLICY = GROUP.registerEvent("toggle.ignore.policy", (EventField)EventFields.Enum((String)"value", IgnorePolicy.class, value -> value.name()), (EventField)DIFF_PLACE_FIELD);
    private static final ClassEventField DIFF_TOOL_CLASS = EventFields.Class((String)"value");
    private static final EventId3<PluginInfo, Class<?>, String> TOGGLE_DIFF_TOOL = GROUP.registerEvent("toggle.diff.tool", (EventField)EventFields.PluginInfo, (EventField)DIFF_TOOL_CLASS, (EventField)DIFF_PLACE_FIELD);
    private static final EventId TOGGLE_COMBINED_DIFF_BLOCK_COLLAPSE = GROUP.registerEvent("toggle.combined.diff.block.collapse");
    private static final EventId3<PluginInfo, Class<?>, String> SHOW_DIFF_TOOL = GROUP.registerEvent("show.diff.tool", (EventField)EventFields.PluginInfo, (EventField)DIFF_TOOL_CLASS, (EventField)DIFF_PLACE_FIELD);
    private static final BooleanEventField IS_MERGE = EventFields.Boolean((String)"is_merge");
    private static final EventId1<Boolean> SHOW_EXTERNAL_DIFF_TOOL = GROUP.registerEvent("show.external.diff.tool", (EventField)IS_MERGE);
    private static final EventId MARKER_POPUP_SHOWN = GROUP.registerEvent("marker.popup.shown");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logToggleHighlightPolicy(@NotNull HighlightPolicy value, @Nullable @NonNls String place) {
        if (value == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        TOGGLE_HIGHLIGHT_POLICY.log((Object)value, (Object)DiffUsageTriggerCollector.getPlaceName(place));
    }

    public static void logToggleIgnorePolicy(@NotNull IgnorePolicy value, @Nullable @NonNls String place) {
        if (value == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        TOGGLE_IGNORE_POLICY.log((Object)value, (Object)DiffUsageTriggerCollector.getPlaceName(place));
    }

    public static void logToggleDiffTool(@Nullable Project project, @NotNull DiffTool diffTool, @Nullable @NonNls String place) {
        if (diffTool == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        TOGGLE_DIFF_TOOL.log(project, (Object)PluginInfoDetectorKt.getPluginInfo((Class)diffTool.getClass()), (Object)diffTool.getClass(), (Object)DiffUsageTriggerCollector.getPlaceName(place));
    }

    public static void logShowDiffTool(@Nullable Project project, @NotNull DiffTool diffTool, @Nullable @NonNls String place) {
        if (diffTool == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        SHOW_DIFF_TOOL.log(project, (Object)PluginInfoDetectorKt.getPluginInfo((Class)diffTool.getClass()), (Object)diffTool.getClass(), (Object)DiffUsageTriggerCollector.getPlaceName(place));
    }

    public static void logShowExternalTool(@Nullable Project project, boolean isMerge) {
        SHOW_EXTERNAL_DIFF_TOOL.log(project, (Object)isMerge);
    }

    public static void logShowCombinedDiffTool(@Nullable Project project, @NotNull DiffTool diffTool, @Nullable @NonNls String place) {
        if (diffTool == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        SHOW_DIFF_TOOL.log(project, (Object)PluginInfoDetectorKt.getPluginInfo((Class)diffTool.getClass()), (Object)diffTool.getClass(), (Object)DiffUsageTriggerCollector.getPlaceName(place));
    }

    public static void logToggleCombinedDiffBlockCollapse(@Nullable Project project) {
        TOGGLE_COMBINED_DIFF_BLOCK_COLLAPSE.log(project);
    }

    public static void logShowMarkerPopup(@Nullable Project project) {
        MARKER_POPUP_SHOWN.log(project);
    }

    @NotNull
    private static String getPlaceName(@NonNls @Nullable String place) {
        String string = StringUtil.notNullize((String)place, (String)"unknown");
        if (string == null) {
            DiffUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffTool";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/DiffUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/DiffUsageTriggerCollector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logToggleHighlightPolicy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "logToggleIgnorePolicy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logToggleDiffTool";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logShowDiffTool";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logShowCombinedDiffTool";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

