/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final Map<String, TextAttributes> myAttributesTempMap = new ConcurrentHashMap<String, TextAttributes>();
    private boolean isVisible = true;
    private boolean isSaveNeeded;

    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    @Override
    public void setSaveNeeded(boolean value) {
        this.isSaveNeeded = value;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = this.isSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        if (schemeState == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(0);
        }
        return schemeState;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isReadOnly() {
        return false;
    }

    @ApiStatus.Internal
    public boolean isFromIntellij() {
        return false;
    }

    public void setVisible(boolean value) {
        this.isVisible = value;
    }

    public void setAttributes(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (key == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(2);
        }
        if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
            this.myAttributesTempMap.put(key.getExternalName(), attributes);
        } else if (attributes == INHERITED_ATTRS_MARKER || !Comparing.equal((Object)attributes, (Object)this.getDirectlyDefinedAttributes(key))) {
            this.attributesMap.put(key.getExternalName(), attributes);
            this.myAttributesTempMap.clear();
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (color == NULL_COLOR_MARKER || color == INHERITED_COLOR_MARKER) {
            this.colorMap.put(key, color);
            return;
        }
        Color directlyDefinedColor = this.getDirectlyDefinedColor(key);
        if (directlyDefinedColor == NULL_COLOR_MARKER || directlyDefinedColor == INHERITED_COLOR_MARKER || !EditorColorsSchemeImpl.colorsEqual(color, directlyDefinedColor)) {
            this.colorMap.put(key, (Color)ObjectUtils.notNull((Object)color, (Object)NULL_COLOR_MARKER));
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
        return this.getAttributes(key, true);
    }

    public TextAttributes getAttributes(TextAttributesKey key, boolean useDefaults) {
        if (key != null) {
            if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
                return this.myAttributesTempMap.get(key.getExternalName());
            }
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (attributes != null && attributes != INHERITED_ATTRS_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.parentScheme.getAttributes(key, useDefaults);
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (key != null) {
            Color color = this.getDirectlyDefinedColor(key);
            if (color == NULL_COLOR_MARKER) {
                return null;
            }
            if (color != null && color != INHERITED_COLOR_MARKER) {
                return color;
            }
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null && (color = this.getFallbackColor(fallbackKey)) != null) {
                return color;
            }
        }
        return this.parentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.parentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme, boolean useDefaults) {
        return this.compareAttributes(otherScheme, new ArrayList<Predicate<? super TextAttributesKey>>(), useDefaults);
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        ArrayList<Predicate<? super ColorKey>> filters = new ArrayList<Predicate<? super ColorKey>>();
        if (colorKeyFilter != null) {
            filters.add(colorKeyFilter);
        }
        return this.compareColors(otherScheme, filters);
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<? super TextAttributesKey>> filters, boolean useDefaults) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(3);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(4);
        }
        for (String keyName : this.attributesMap.keySet()) {
            TextAttributesKey key2 = TextAttributesKey.find((String)keyName);
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters, key2) || this.getAttributes(key2, useDefaults).equals((Object)otherScheme.getAttributes(key2, useDefaults))) continue;
            return false;
        }
        filters.add(key -> this.attributesMap.containsKey(key.getExternalName()));
        return !(this.parentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.parentScheme).compareAttributes(otherScheme, filters, useDefaults);
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<? super ColorKey>> filters) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(5);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(6);
        }
        for (ColorKey key2 : this.colorMap.keySet()) {
            Color thisColor = this.getColor(key2);
            Color otherColor = otherScheme.getColor(key2);
            if (!EditorColorsSchemeImpl.isColorKeyAccepted(filters, key2) || Comparing.equal((Object)thisColor, (Object)otherColor)) continue;
            return false;
        }
        filters.add(key -> !this.colorMap.containsKey(key));
        return !(this.parentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.parentScheme).compareColors(otherScheme, filters);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<? extends Predicate<? super TextAttributesKey>> filters, TextAttributesKey key) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(7);
        }
        for (Predicate<? super TextAttributesKey> predicate : filters) {
            if (!predicate.test((TextAttributesKey)key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isColorKeyAccepted(@NotNull Collection<? extends Predicate<? super ColorKey>> filters, @NotNull ColorKey key) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(8);
        }
        if (key == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(9);
        }
        for (Predicate<? super ColorKey> predicate : filters) {
            if (predicate.test((ColorKey)key)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherScheme";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareColors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTextAttributeKeyIgnored";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isColorKeyAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

