/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PsiTodoSearchHelperImpl
implements PsiTodoSearchHelper {
    private final Project myProject;

    public PsiTodoSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public @NotNull PsiFile @NotNull [] findFilesWithTodoItems() {
        HashSet<@NotNull E> files = new HashSet();
        this.processFilesWithTodoItems((Processor<? super PsiFile>)new CommonProcessors.CollectProcessor(files));
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(files);
        if (psiFileArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    public boolean processFilesWithTodoItems(@NotNull @NotNull Processor<? super @NotNull PsiFile> processor) {
        if (processor == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(2);
        }
        return TodoCacheManager.getInstance((Project)this.myProject).processFilesWithTodoItems(processor);
    }

    public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file) {
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(3);
        }
        TodoItem[] todoItemArray = this.findTodoItems(file, 0, file.getTextLength());
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(4);
        }
        return todoItemArray;
    }

    @NotNull
    public @NotNull TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(5);
        }
        ArrayList<TodoItem> occurrences = new ArrayList<TodoItem>();
        TodoItemCreator todoItemCreator = new TodoItemCreator();
        boolean multiLine = TodoConfiguration.getInstance().isMultiLine();
        for (IndexPatternProvider provider : IndexPatternProvider.EP_NAME.getExtensionList()) {
            Collection collection = IndexPatternSearch.search((PsiFile)file, (IndexPatternProvider)provider, (int)startOffset, (int)endOffset, (boolean)multiLine).findAll();
            for (IndexPatternOccurrence occurrence : collection) {
                if (!occurrence.getTextRange().intersects(startOffset, endOffset)) continue;
                occurrences.add(todoItemCreator.createTodo(occurrence));
            }
        }
        TodoItem[] todoItemArray = occurrences.isEmpty() ? TodoItem.EMPTY_ARRAY : occurrences.toArray(TodoItem.EMPTY_ARRAY);
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(6);
        }
        return todoItemArray;
    }

    @NotNull
    public @NotNull TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file) {
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(7);
        }
        TodoItem[] todoItemArray = this.findTodoItemsLight(file, 0, file.getTextLength());
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(8);
        }
        return todoItemArray;
    }

    @NotNull
    public @NotNull TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(9);
        }
        ArrayList<TodoItem> occurrences = new ArrayList<TodoItem>();
        TodoItemCreator todoItemCreator = new TodoItemCreator();
        for (IndexPatternProvider provider : IndexPatternProvider.EP_NAME.getExtensionList()) {
            Collection collection = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(file, provider, TodoConfiguration.getInstance().isMultiLine())).findAll();
            for (IndexPatternOccurrence occurrence : collection) {
                if (!occurrence.getTextRange().intersects(startOffset, endOffset)) continue;
                occurrences.add(todoItemCreator.createTodo(occurrence));
            }
        }
        TodoItem[] todoItemArray = occurrences.isEmpty() ? TodoItem.EMPTY_ARRAY : occurrences.toArray(TodoItem.EMPTY_ARRAY);
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(10);
        }
        return todoItemArray;
    }

    public int getTodoItemsCount(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(11);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return 0;
        }
        int total = 0;
        for (IndexPatternProvider provider : IndexPatternProvider.EP_NAME.getExtensionList()) {
            int count = TodoCacheManager.getInstance((Project)this.myProject).getTodoCount(virtualFile, provider);
            if (count == -1) {
                return this.findTodoItems(file).length;
            }
            total += count;
        }
        return total;
    }

    public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
        TodoItem[] items;
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        int count = 0;
        if (virtualFile != null && (count = TodoCacheManager.getInstance((Project)this.myProject).getTodoCount(virtualFile, pattern.getIndexPattern())) != -1) {
            return count;
        }
        for (TodoItem item : items = this.findTodoItems(file)) {
            if (!Objects.equals(item.getPattern(), pattern)) continue;
            ++count;
        }
        return count;
    }

    public boolean shouldHighlightInEditor(@NotNull PsiFile file) {
        if (file == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(14);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithTodoItems";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTodoItems";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTodoItemsLight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithTodoItems";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTodoItems";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTodoItemsLight";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTodoItemsCount";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightInEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

