/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"SCHEME_ELEMENT", "", "loadState", "", "Lcom/intellij/openapi/editor/colors/impl/DefaultColorsScheme;", "oldSchemes", "intellij.platform.editor.ex"})
public final class DefaultColorSchemesManagerKt {
    @NotNull
    private static final String SCHEME_ELEMENT = "scheme";

    private static final List<DefaultColorsScheme> loadState(List<? extends DefaultColorsScheme> oldSchemes) {
        byte[] byArray = ResourceUtil.getResourceAsBytes((String)"DefaultColorSchemesManager.xml", (ClassLoader)DefaultColorSchemesManager.class.getClassLoader());
        Intrinsics.checkNotNull((Object)byArray);
        Element element = JDOMUtil.load((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element state = element;
        ArrayList<DefaultColorsScheme> schemes = new ArrayList<DefaultColorsScheme>();
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            boolean isUpdated = false;
            Attribute nameAttr = schemeElement.getAttribute("name");
            if (nameAttr != null) {
                for (DefaultColorsScheme defaultColorsScheme : oldSchemes) {
                    if (!Intrinsics.areEqual((Object)nameAttr.getValue(), (Object)defaultColorsScheme.getName())) continue;
                    defaultColorsScheme.readExternal(schemeElement);
                    schemes.add(defaultColorsScheme);
                    isUpdated = true;
                }
            }
            if (isUpdated) continue;
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            schemes.add(newScheme);
        }
        schemes.add(EmptyColorScheme.getEmptyScheme());
        List<DefaultColorsScheme> list = List.copyOf((Collection)schemes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"copyOf(...)");
        return list;
    }

    public static final /* synthetic */ List access$loadState(List oldSchemes) {
        return DefaultColorSchemesManagerKt.loadState(oldSchemes);
    }
}

