/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FontPreferencesImpl
extends ModifiableFontPreferences {
    @NotNull
    private final Object2FloatMap<String> myFontSizes = new Object2FloatOpenHashMap();
    @NotNull
    private final List<String> myEffectiveFontFamilies = new ArrayList<String>();
    @NotNull
    private final List<String> myRealFontFamilies = new ArrayList<String>();
    @Nullable
    private String myRegularSubFamily;
    @Nullable
    private String myBoldSubFamily;
    @NotNull
    private final @NotNull HashSet<@NotNull String> myCharacterVariants = new HashSet();
    private boolean myUseLigatures;
    private float myLineSpacing = 1.2f;
    @NotNull
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private float myTemplateFontSize = DEFAULT_FONT_SIZE;
    private static final Logger LOG = Logger.getInstance(FontPreferencesImpl.class);

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            FontPreferencesImpl.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher.addListener((EventListener)changeListener);
    }

    public void addChangeListener(@NotNull ChangeListener changeListener, @NotNull Disposable parentDisposable) {
        if (changeListener == null) {
            FontPreferencesImpl.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            FontPreferencesImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener((EventListener)changeListener, parentDisposable);
    }

    public void clear() {
        this.myFontSizes.clear();
        this.clearFonts();
    }

    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myUseLigatures = false;
        this.myRegularSubFamily = null;
        this.myBoldSubFamily = null;
        this.myCharacterVariants.clear();
        this.notifyStateChanged();
    }

    private void notifyStateChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            FontPreferencesImpl.$$$reportNull$$$0(3);
        }
        return this.myFontSizes.containsKey((Object)fontName);
    }

    public float getLineSpacing() {
        return this.myLineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(4);
        }
        return (int)((double)this.getSize2D(fontFamily) + 0.5);
    }

    public float getSize2D(@NotNull String fontFamily) {
        float result;
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(5);
        }
        if ((result = this.myFontSizes.getFloat((Object)fontFamily)) <= 0.0f) {
            result = this.myTemplateFontSize;
        }
        return result > 0.0f ? result : (float)DEFAULT_FONT_SIZE;
    }

    public void setSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(6);
        }
        this.setSize(fontFamily, (float)size);
    }

    public void setSize(@NotNull String fontFamily, float size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(7);
        }
        this.logSizeChangeIfNeeded(size);
        this.myFontSizes.put((Object)fontFamily, size);
        this.myTemplateFontSize = size;
        this.notifyStateChanged();
    }

    private void logSizeChangeIfNeeded(float size) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        EditorColorsManager colorsManager = (EditorColorsManager)ApplicationManager.getApplication().getServiceIfCreated(EditorColorsManager.class);
        if (colorsManager == null || colorsManager.getGlobalScheme().getFontPreferences() != this) {
            return;
        }
        LOG.debug("Will set size %s to global font (presentationMode=%b)".formatted(Float.valueOf(size), UISettings.getInstance().getPresentationMode()));
        LOG.debug(ExceptionUtil.currentStackTrace());
    }

    public @NotNull List<@NlsSafe String> getEffectiveFontFamilies() {
        List<String> list = this.myEffectiveFontFamilies;
        if (list == null) {
            FontPreferencesImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public @NotNull List<@NlsSafe String> getRealFontFamilies() {
        List<String> list = this.myRealFontFamilies;
        if (list == null) {
            FontPreferencesImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void register(@NotNull @NonNls String fontFamily, int size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(10);
        }
        this.register(fontFamily, (float)size);
    }

    public void register(@NotNull @NonNls String fontFamily, float size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(11);
        }
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        if (!this.myEffectiveFontFamilies.contains(fontFamily)) {
            this.myEffectiveFontFamilies.add(fontFamily);
        }
        this.setSize(fontFamily, size);
    }

    @NotNull
    @NlsSafe
    public String getFontFamily() {
        String string = this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
        if (string == null) {
            FontPreferencesImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void addFontFamily(@NotNull String fontFamily) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(13);
        }
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        if (!this.myEffectiveFontFamilies.contains(fontFamily)) {
            this.myEffectiveFontFamilies.add(fontFamily);
        }
        this.notifyStateChanged();
    }

    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            FontPreferencesImpl.$$$reportNull$$$0(14);
        }
        if (preferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiablePreferences = (ModifiableFontPreferences)preferences;
            modifiablePreferences.setEffectiveFontFamilies(this.myEffectiveFontFamilies);
            modifiablePreferences.setRealFontFamilies(this.myRealFontFamilies);
            modifiablePreferences.setTemplateFontSize(this.myTemplateFontSize);
            modifiablePreferences.resetFontSizes();
            for (String fontFamily : this.myRealFontFamilies) {
                if (!this.myFontSizes.containsKey((Object)fontFamily)) continue;
                modifiablePreferences.setFontSize(fontFamily, this.myFontSizes.getFloat((Object)fontFamily));
            }
            modifiablePreferences.setUseLigatures(this.myUseLigatures);
            modifiablePreferences.setLineSpacing(this.myLineSpacing);
            modifiablePreferences.setRegularSubFamily(this.myRegularSubFamily);
            modifiablePreferences.setBoldSubFamily(this.myBoldSubFamily);
            modifiablePreferences.setCharacterVariants(this.myCharacterVariants);
        }
    }

    public void resetFontSizes() {
        this.myFontSizes.clear();
    }

    public void setFontSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(15);
        }
        this.setFontSize(fontFamily, (float)size);
    }

    public void setFontSize(@NotNull String fontFamily, float size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(16);
        }
        this.myFontSizes.put((Object)fontFamily, size);
    }

    public void setTemplateFontSize(int size) {
        this.setTemplateFontSize((float)size);
    }

    public void setTemplateFontSize(float size) {
        this.myTemplateFontSize = size;
    }

    public void setEffectiveFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            FontPreferencesImpl.$$$reportNull$$$0(17);
        }
        this.myEffectiveFontFamilies.clear();
        this.myEffectiveFontFamilies.addAll(fontFamilies);
    }

    public void setRealFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            FontPreferencesImpl.$$$reportNull$$$0(18);
        }
        this.myRealFontFamilies.clear();
        this.myRealFontFamilies.addAll(fontFamilies);
    }

    public int hashCode() {
        return this.myRealFontFamilies.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FontPreferencesImpl that = (FontPreferencesImpl)((Object)o);
        if (!this.myRealFontFamilies.equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.getFloat((Object)fontFamily) == that.myFontSizes.getFloat((Object)fontFamily)) continue;
            return false;
        }
        if (this.myUseLigatures != that.myUseLigatures) {
            return false;
        }
        if (this.myLineSpacing != that.myLineSpacing) {
            return false;
        }
        if (!Objects.equals(this.myRegularSubFamily, that.myRegularSubFamily)) {
            return false;
        }
        if (!Objects.equals(this.myBoldSubFamily, that.myBoldSubFamily)) {
            return false;
        }
        return Objects.equals(this.myCharacterVariants, that.myCharacterVariants);
    }

    public boolean useLigatures() {
        return this.myUseLigatures;
    }

    public void setUseLigatures(boolean useLigatures) {
        if (useLigatures != this.myUseLigatures) {
            this.myUseLigatures = useLigatures;
            this.notifyStateChanged();
        }
    }

    @Nullable
    public String getRegularSubFamily() {
        return this.myRegularSubFamily;
    }

    @Nullable
    public String getBoldSubFamily() {
        return this.myBoldSubFamily;
    }

    public void setRegularSubFamily(String subFamily) {
        if (!Objects.equals(this.myRegularSubFamily, subFamily)) {
            this.myRegularSubFamily = subFamily;
            this.notifyStateChanged();
        }
    }

    public void setBoldSubFamily(String subFamily) {
        if (!Objects.equals(this.myBoldSubFamily, subFamily)) {
            this.myBoldSubFamily = subFamily;
            this.notifyStateChanged();
        }
    }

    @NonNls
    public String toString() {
        return "Effective font families: " + String.valueOf(this.myEffectiveFontFamilies);
    }

    @NotNull
    public @NotNull Set<@NotNull String> getCharacterVariants() {
        HashSet<String> hashSet = this.myCharacterVariants;
        if (hashSet == null) {
            FontPreferencesImpl.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    public void setCharacterVariants(@NotNull @Unmodifiable @NotNull Set<@NotNull String> variants) {
        if (variants == null) {
            FontPreferencesImpl.$$$reportNull$$$0(20);
        }
        this.myCharacterVariants.clear();
        this.myCharacterVariants.addAll(variants);
        this.notifyStateChanged();
    }

    public void setCharacterVariant(@NotNull String variant, boolean enabled) {
        if (variant == null) {
            FontPreferencesImpl.$$$reportNull$$$0(21);
        }
        if (enabled) {
            this.myCharacterVariants.add(variant);
        } else {
            this.myCharacterVariants.remove(variant);
        }
        this.notifyStateChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamilies";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFontFamilies";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealFontFamilies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontFamily";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharacterVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSize2D";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addFontFamily";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setFontSize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setEffectiveFontFamilies";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRealFontFamilies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCharacterVariants";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setCharacterVariant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 19 -> new IllegalStateException(string);
        };
    }
}

