/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SelectionModel {
    @NotNull
    public Editor getEditor();

    default public int getSelectionStart() {
        return this.getEditor().getCaretModel().getCurrentCaret().getSelectionStart();
    }

    @Nullable
    default public VisualPosition getSelectionStartPosition() {
        return this.getEditor().getCaretModel().getCurrentCaret().getSelectionStartPosition();
    }

    default public int getSelectionEnd() {
        return this.getEditor().getCaretModel().getCurrentCaret().getSelectionEnd();
    }

    @Nullable
    default public VisualPosition getSelectionEndPosition() {
        return this.getEditor().getCaretModel().getCurrentCaret().getSelectionEndPosition();
    }

    @Nullable
    @NlsSafe
    default public String getSelectedText() {
        return this.getSelectedText(false);
    }

    @Nullable
    @NlsSafe
    default public String getSelectedText(boolean allCarets) {
        if (allCarets && this.getEditor().getCaretModel().supportsMultipleCarets()) {
            StringBuilder buf = new StringBuilder();
            String separator = "";
            for (Caret caret : this.getEditor().getCaretModel().getAllCarets()) {
                buf.append(separator);
                String caretSelectedText = caret.getSelectedText();
                if (caretSelectedText != null) {
                    buf.append(caretSelectedText);
                }
                separator = "\n";
            }
            return buf.toString();
        }
        return this.getEditor().getCaretModel().getCurrentCaret().getSelectedText();
    }

    default public int getLeadSelectionOffset() {
        return this.getEditor().getCaretModel().getCurrentCaret().getLeadSelectionOffset();
    }

    @Nullable
    default public VisualPosition getLeadSelectionPosition() {
        return this.getEditor().getCaretModel().getCurrentCaret().getLeadSelectionPosition();
    }

    default public boolean hasSelection() {
        return this.hasSelection(false);
    }

    default public boolean hasSelection(boolean anyCaret) {
        if (!anyCaret) {
            return this.getEditor().getCaretModel().getCurrentCaret().hasSelection();
        }
        for (Caret caret : this.getEditor().getCaretModel().getAllCarets()) {
            if (!caret.hasSelection()) continue;
            return true;
        }
        return false;
    }

    default public void setSelection(int startOffset, int endOffset) {
        this.getEditor().getCaretModel().getCurrentCaret().setSelection(startOffset, endOffset);
    }

    default public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getEditor().getCaretModel().getCurrentCaret().setSelection(startOffset, endPosition, endOffset);
    }

    default public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getEditor().getCaretModel().getCurrentCaret().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    default public void removeSelection() {
        this.removeSelection(false);
    }

    default public void removeSelection(boolean allCarets) {
        if (!allCarets) {
            this.getEditor().getCaretModel().getCurrentCaret().removeSelection();
        } else {
            for (Caret caret : this.getEditor().getCaretModel().getAllCarets()) {
                caret.removeSelection();
            }
        }
    }

    public void addSelectionListener(@NotNull SelectionListener var1);

    default public void addSelectionListener(@NotNull SelectionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            SelectionModel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            SelectionModel.$$$reportNull$$$0(1);
        }
        this.addSelectionListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removeSelectionListener(listener));
    }

    public void removeSelectionListener(@NotNull SelectionListener var1);

    default public void selectLineAtCaret() {
        this.getEditor().getCaretModel().getCurrentCaret().selectLineAtCaret();
    }

    default public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.getEditor().getCaretModel().getCurrentCaret().selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard();

    public void setBlockSelection(@NotNull LogicalPosition var1, @NotNull LogicalPosition var2);

    public int @NotNull [] getBlockSelectionStarts();

    public int @NotNull [] getBlockSelectionEnds();

    public TextAttributes getTextAttributes();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/SelectionModel";
        objectArray[2] = "addSelectionListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

