/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusImpl;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileStatusFactory {
    private static final FileStatusFactory ourInstance = new FileStatusFactory();
    private final MultiMap<@Nullable PluginId, FileStatus> myStatuses = new MultiMap();

    @NotNull
    public static FileStatusFactory getInstance() {
        FileStatusFactory fileStatusFactory = ourInstance;
        if (fileStatusFactory == null) {
            FileStatusFactory.$$$reportNull$$$0(0);
        }
        return fileStatusFactory;
    }

    @ApiStatus.Internal
    public static String getFilestatusColorKeyPrefix() {
        return "FILESTATUS_";
    }

    @ApiStatus.Internal
    public static String getFilestatusUiThemePrefix() {
        return "VersionControl.FileStatus.";
    }

    @Deprecated
    public FileStatus createFileStatus(@NonNls @NotNull String id, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String description, @Nullable Color color) {
        if (id == null) {
            FileStatusFactory.$$$reportNull$$$0(1);
        }
        if (description == null) {
            FileStatusFactory.$$$reportNull$$$0(2);
        }
        return this.createFileStatus(id, () -> description, color, null);
    }

    @NotNull
    public FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String> description, @Nullable PluginId pluginId) {
        if (id == null) {
            FileStatusFactory.$$$reportNull$$$0(3);
        }
        if (description == null) {
            FileStatusFactory.$$$reportNull$$$0(4);
        }
        FileStatus fileStatus = this.createFileStatus(id, description, null, pluginId);
        if (fileStatus == null) {
            FileStatusFactory.$$$reportNull$$$0(5);
        }
        return fileStatus;
    }

    @NotNull
    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String> description, @Nullable Color color, @Nullable PluginId pluginId) {
        if (id == null) {
            FileStatusFactory.$$$reportNull$$$0(6);
        }
        if (description == null) {
            FileStatusFactory.$$$reportNull$$$0(7);
        }
        ColorKey colorKey = ColorKey.createColorKey((String)(FileStatusFactory.getFilestatusColorKeyPrefix() + id), (Color)color);
        FileStatusImpl result = new FileStatusImpl(id, colorKey, description);
        this.myStatuses.putValue((Object)pluginId, (Object)result);
        FileStatusImpl fileStatusImpl = result;
        if (fileStatusImpl == null) {
            FileStatusFactory.$$$reportNull$$$0(8);
        }
        return fileStatusImpl;
    }

    @ApiStatus.Internal
    @NotNull
    public @NotNull FileStatus @NotNull [] getAllFileStatuses() {
        FileStatus[] fileStatusArray = this.myStatuses.values().toArray(new FileStatus[0]);
        if (fileStatusArray == null) {
            FileStatusFactory.$$$reportNull$$$0(9);
        }
        return fileStatusArray;
    }

    @ApiStatus.Internal
    @NotNull
    public Collection<FileStatus> getGlobalFileStatuses() {
        Collection collection = this.myStatuses.get(null);
        if (collection == null) {
            FileStatusFactory.$$$reportNull$$$0(10);
        }
        return collection;
    }

    synchronized void onPluginUnload(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            FileStatusFactory.$$$reportNull$$$0(11);
        }
        this.myStatuses.remove((Object)pluginId);
    }

    private FileStatusFactory() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/FileStatusFactory";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/FileStatusFactory";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileStatuses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalFileStatuses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileStatus";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onPluginUnload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 11 -> new IllegalArgumentException(string);
        };
    }
}

