/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class TreeCollector<T> {
    private final AtomicReference<List<T>> reference;
    private final BiPredicate<? super T, ? super T> predicate;

    private TreeCollector(@NotNull BiPredicate<? super T, ? super T> predicate) {
        if (predicate == null) {
            TreeCollector.$$$reportNull$$$0(0);
        }
        this.reference = new AtomicReference();
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<T> get() {
        AtomicReference<List<T>> atomicReference = this.reference;
        // MONITORENTER : atomicReference
        List list2 = this.reference.getAndSet(null);
        List list = list2 != null ? list2 : Collections.emptyList();
        // MONITOREXIT : atomicReference
        if (list != null) return list;
        TreeCollector.$$$reportNull$$$0(1);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NotNull T object) {
        if (object == null) {
            TreeCollector.$$$reportNull$$$0(2);
        }
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List<T> list = this.reference.get();
            if (list != null) {
                return TreeCollector.add(this.predicate, list, object);
            }
            this.reference.set((List<T>)new SmartList(object));
            return true;
        }
    }

    @NotNull
    private static <T> List<T> collect(@NotNull BiPredicate<? super T, ? super T> predicate, T ... objects) {
        if (predicate == null) {
            TreeCollector.$$$reportNull$$$0(3);
        }
        return ArrayUtil.isEmpty((Object[])objects) ? new ArrayList() : TreeCollector.collect(predicate, Arrays.asList(objects));
    }

    @NotNull
    private static <T> List<T> collect(@NotNull BiPredicate<? super T, ? super T> predicate, @NotNull Collection<? extends T> objects) {
        if (predicate == null) {
            TreeCollector.$$$reportNull$$$0(4);
        }
        if (objects == null) {
            TreeCollector.$$$reportNull$$$0(5);
        }
        ArrayList list = new ArrayList(objects.size());
        for (T object : objects) {
            if (object == null) continue;
            TreeCollector.add(predicate, list, object);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            TreeCollector.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static <T> boolean add(@NotNull BiPredicate<? super T, ? super T> predicate, @NotNull List<T> list, @NotNull T object) {
        if (predicate == null) {
            TreeCollector.$$$reportNull$$$0(7);
        }
        if (list == null) {
            TreeCollector.$$$reportNull$$$0(8);
        }
        if (object == null) {
            TreeCollector.$$$reportNull$$$0(9);
        }
        for (T each2 : list) {
            if (!predicate.test(each2, object)) continue;
            return false;
        }
        list.removeIf(each -> predicate.test(object, each));
        list.add(object);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreeCollector";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreeCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }

    public static final class TreePathRoots {
        private static final BiPredicate<TreePath, TreePath> PREDICATE = (parent, child) -> parent.isDescendant((TreePath)child);

        @NotNull
        public static TreeCollector<TreePath> create() {
            return new TreeCollector<TreePath>(PREDICATE);
        }

        @NotNull
        public static List<TreePath> collect(TreePath ... paths) {
            List<TreePath> list = TreeCollector.collect(PREDICATE, paths);
            if (list == null) {
                TreePathRoots.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public static List<TreePath> collect(@NotNull Collection<? extends TreePath> paths) {
            if (paths == null) {
                TreePathRoots.$$$reportNull$$$0(1);
            }
            List<TreePath> list = TreeCollector.collect(PREDICATE, paths);
            if (list == null) {
                TreePathRoots.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeCollector$TreePathRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeCollector$TreePathRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class TreePathLeafs {
        private static final BiPredicate<TreePath, TreePath> PREDICATE = (child, parent) -> parent.isDescendant((TreePath)child);

        @NotNull
        public static TreeCollector<TreePath> create() {
            return new TreeCollector<TreePath>(PREDICATE);
        }

        @NotNull
        public static List<TreePath> collect(TreePath ... paths) {
            List<TreePath> list = TreeCollector.collect(PREDICATE, paths);
            if (list == null) {
                TreePathLeafs.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public static List<TreePath> collect(@NotNull Collection<? extends TreePath> paths) {
            if (paths == null) {
                TreePathLeafs.$$$reportNull$$$0(1);
            }
            List<TreePath> list = TreeCollector.collect(PREDICATE, paths);
            if (list == null) {
                TreePathLeafs.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeCollector$TreePathLeafs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeCollector$TreePathLeafs";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class VirtualFileRoots {
        private static final BiPredicate<VirtualFile, VirtualFile> PREDICATE = (parent, child) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);

        @NotNull
        public static TreeCollector<VirtualFile> create() {
            return new TreeCollector<VirtualFile>(PREDICATE);
        }

        @NotNull
        public static List<VirtualFile> collect(VirtualFile ... files) {
            List<VirtualFile> list = TreeCollector.collect(PREDICATE, files);
            if (list == null) {
                VirtualFileRoots.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public static List<VirtualFile> collect(@NotNull Collection<? extends VirtualFile> files) {
            if (files == null) {
                VirtualFileRoots.$$$reportNull$$$0(1);
            }
            List<VirtualFile> list = TreeCollector.collect(PREDICATE, files);
            if (list == null) {
                VirtualFileRoots.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeCollector$VirtualFileRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeCollector$VirtualFileRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class VirtualFileLeafs {
        private static final BiPredicate<VirtualFile, VirtualFile> PREDICATE = (child, parent) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);

        @NotNull
        public static TreeCollector<VirtualFile> create() {
            return new TreeCollector<VirtualFile>(PREDICATE);
        }

        @NotNull
        public static List<VirtualFile> collect(VirtualFile ... files) {
            List<VirtualFile> list = TreeCollector.collect(PREDICATE, files);
            if (list == null) {
                VirtualFileLeafs.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public static List<VirtualFile> collect(@NotNull Collection<? extends VirtualFile> files) {
            if (files == null) {
                VirtualFileLeafs.$$$reportNull$$$0(1);
            }
            List<VirtualFile> list = TreeCollector.collect(PREDICATE, files);
            if (list == null) {
                VirtualFileLeafs.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeCollector$VirtualFileLeafs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeCollector$VirtualFileLeafs";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

