/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@ApiStatus.Internal
public final class LightEditFilePatterns {
    public static final String[] DEFAULT_PATTERNS = new String[]{"*.txt", "*.log", "*.md", "*.json", "*.xml", "*.sh", "*.ini", "*.yml", "*.conf"};
    public static final String PATTERN_SEPARATOR = ";";
    private final Set<String> myPatterns;
    private final Object myPatternLock;
    private volatile List<FileNameMatcher> myMatchers;

    public LightEditFilePatterns() {
        this(Arrays.asList(DEFAULT_PATTERNS));
    }

    private LightEditFilePatterns(@NotNull List<String> filePatterns) {
        if (filePatterns == null) {
            LightEditFilePatterns.$$$reportNull$$$0(0);
        }
        this.myPatterns = new HashSet<String>();
        this.myPatternLock = new Object();
        this.myMatchers = null;
        this.myPatterns.addAll(filePatterns);
    }

    public static LightEditFilePatterns parse(@NotNull String patternString) {
        if (patternString == null) {
            LightEditFilePatterns.$$$reportNull$$$0(1);
        }
        ArrayList<String> filePatterns = new ArrayList<String>();
        for (String pattern : patternString.split(PATTERN_SEPARATOR)) {
            if (StringUtil.isEmptyOrSpaces((String)pattern)) continue;
            filePatterns.add(pattern);
        }
        return new LightEditFilePatterns(filePatterns);
    }

    @NlsSafe
    public String toSeparatedString() {
        return String.join((CharSequence)PATTERN_SEPARATOR, this.getPatterns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getPatterns() {
        Object object = this.myPatternLock;
        // MONITORENTER : object
        List<String> list = this.myPatterns.stream().sorted().collect(Collectors.toList());
        // MONITOREXIT : object
        if (list != null) return list;
        LightEditFilePatterns.$$$reportNull$$$0(2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            LightEditFilePatterns.$$$reportNull$$$0(3);
        }
        Object object = this.myPatternLock;
        synchronized (object) {
            this.myPatterns.clear();
            this.myPatterns.addAll(patterns);
            this.myMatchers = null;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof LightEditFilePatterns && this.getPatterns().equals(((LightEditFilePatterns)obj).getPatterns());
    }

    public int hashCode() {
        return this.getPatterns().hashCode();
    }

    public boolean match(@NotNull VirtualFile file) {
        if (file == null) {
            LightEditFilePatterns.$$$reportNull$$$0(4);
        }
        for (FileNameMatcher matcher : this.getMatchers()) {
            if (!matcher.acceptsCharSequence(file.getNameSequence())) continue;
            return true;
        }
        return false;
    }

    private List<FileNameMatcher> getMatchers() {
        List matchers = this.myMatchers;
        if (matchers == null) {
            this.myMatchers = matchers = ContainerUtil.map(this.getPatterns(), pattern -> FileNameMatcherFactory.getInstance().createMatcher(pattern));
        }
        return matchers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditFilePatterns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditFilePatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

