/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.Stack;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EditorColors {
    public static final ColorKey CARET_ROW_COLOR = ColorKey.createColorKey((String)"CARET_ROW_COLOR");
    public static final ColorKey CARET_COLOR = ColorKey.createColorKey((String)"CARET_COLOR");
    public static final ColorKey RIGHT_MARGIN_COLOR = ColorKey.createColorKey((String)"RIGHT_MARGIN_COLOR");
    public static final ColorKey LINE_NUMBERS_COLOR = ColorKey.createColorKey((String)"LINE_NUMBERS_COLOR");
    public static final ColorKey LINE_NUMBER_ON_CARET_ROW_COLOR = ColorKey.createColorKey((String)"LINE_NUMBER_ON_CARET_ROW_COLOR");
    public static final ColorKey ANNOTATIONS_COLOR = ColorKey.createColorKey((String)"ANNOTATIONS_COLOR");
    public static final ColorKey ANNOTATIONS_LAST_COMMIT_COLOR = ColorKey.createColorKeyWithFallback((String)"ANNOTATIONS_LAST_COMMIT_COLOR", (ColorKey)ANNOTATIONS_COLOR);
    public static final ColorKey READONLY_BACKGROUND_COLOR = ColorKey.createColorKey((String)"READONLY_BACKGROUND");
    public static final ColorKey READONLY_FRAGMENT_BACKGROUND_COLOR = ColorKey.createColorKey((String)"READONLY_FRAGMENT_BACKGROUND");
    public static final ColorKey WHITESPACES_COLOR = ColorKey.createColorKey((String)"WHITESPACES");
    public static final ColorKey TABS_COLOR = ColorKey.createColorKeyWithFallback((String)"TABS", (ColorKey)WHITESPACES_COLOR);
    public static final ColorKey INDENT_GUIDE_COLOR = ColorKey.createColorKey((String)"INDENT_GUIDE");
    public static final ColorKey STRING_CONTENT_INDENT_GUIDE_COLOR = ColorKey.createColorKey((String)"STRING_CONTENT_INDENT_GUIDE");
    public static final ColorKey SOFT_WRAP_SIGN_COLOR = ColorKey.createColorKey((String)"SOFT_WRAP_SIGN_COLOR");
    public static final ColorKey SELECTED_INDENT_GUIDE_COLOR = ColorKey.createColorKey((String)"SELECTED_INDENT_GUIDE");
    public static final ColorKey MATCHED_BRACES_INDENT_GUIDE_COLOR = ColorKey.createColorKey((String)"MATCHED_BRACES_INDENT_GUIDE_COLOR");
    public static final ColorKey SELECTION_BACKGROUND_COLOR = ColorKey.createColorKey((String)"SELECTION_BACKGROUND");
    public static final ColorKey SELECTION_FOREGROUND_COLOR = ColorKey.createColorKey((String)"SELECTION_FOREGROUND");
    @Deprecated(forRemoval=true)
    public static final ColorKey SCROLLBAR_THUMB_COLOR = ColorKey.createColorKey((String)(SystemInfo.isMac ? "ScrollBar.Mac.thumbColor" : "ScrollBar.thumbColor"));
    public static final TextAttributesKey TAB_SELECTED = TextAttributesKey.createTextAttributesKey((String)"TAB_SELECTED");
    public static final TextAttributesKey TAB_SELECTED_INACTIVE = TextAttributesKey.createTextAttributesKey((String)"TAB_SELECTED_INACTIVE");
    public static final ColorKey TAB_UNDERLINE = ColorKey.createColorKey((String)"TAB_UNDERLINE");
    public static final ColorKey TAB_UNDERLINE_INACTIVE = ColorKey.createColorKey((String)"TAB_UNDERLINE_INACTIVE");
    public static final ColorKey MODIFIED_TAB_ICON_COLOR = ColorKey.createColorKey((String)"MODIFIED_TAB_ICON");
    public static final TextAttributesKey REFERENCE_HYPERLINK_COLOR = TextAttributesKey.createTextAttributesKey((String)"CTRL_CLICKABLE", (TextAttributes)new TextAttributes((Color)JBColor.blue, null, (Color)JBColor.blue, EffectType.LINE_UNDERSCORE, 0));
    public static final TextAttributesKey SEARCH_RESULT_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"SEARCH_RESULT_ATTRIBUTES");
    public static final TextAttributesKey LIVE_TEMPLATE_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"LIVE_TEMPLATE_ATTRIBUTES");
    public static final TextAttributesKey LIVE_TEMPLATE_INACTIVE_SEGMENT = TextAttributesKey.createTextAttributesKey((String)"LIVE_TEMPLATE_INACTIVE_SEGMENT");
    public static final TextAttributesKey WRITE_SEARCH_RESULT_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"WRITE_SEARCH_RESULT_ATTRIBUTES");
    public static final TextAttributesKey IDENTIFIER_UNDER_CARET_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"IDENTIFIER_UNDER_CARET_ATTRIBUTES");
    public static final TextAttributesKey WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES");
    public static final TextAttributesKey TEXT_SEARCH_RESULT_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"TEXT_SEARCH_RESULT_ATTRIBUTES");
    public static final TextAttributesKey FOLDED_TEXT_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"FOLDED_TEXT_ATTRIBUTES");
    public static final ColorKey FOLDED_TEXT_BORDER_COLOR = ColorKey.createColorKey((String)"FOLDED_TEXT_BORDER_COLOR");
    public static final TextAttributesKey DELETED_TEXT_ATTRIBUTES = TextAttributesKey.createTextAttributesKey((String)"DELETED_TEXT_ATTRIBUTES");
    public static final ColorKey GUTTER_BACKGROUND = ColorKey.createColorKey((String)"GUTTER_BACKGROUND", (Color)new JBColor(0xF0F0F0, 0x313335));
    public static final ColorKey EDITOR_GUTTER_BACKGROUND = ColorKey.createColorKey((String)"EDITOR_GUTTER_BACKGROUND");
    public static final ColorKey NOTIFICATION_BACKGROUND = ColorKey.createColorKey((String)"NOTIFICATION_BACKGROUND");
    public static final ColorKey TEARLINE_COLOR = ColorKey.createColorKey((String)"TEARLINE_COLOR");
    public static final ColorKey SELECTED_TEARLINE_COLOR = ColorKey.createColorKey((String)"SELECTED_TEARLINE_COLOR");
    public static final ColorKey ADDED_LINES_COLOR = ColorKey.createColorKey((String)"ADDED_LINES_COLOR");
    public static final ColorKey MODIFIED_LINES_COLOR = ColorKey.createColorKey((String)"MODIFIED_LINES_COLOR");
    public static final ColorKey DELETED_LINES_COLOR = ColorKey.createColorKey((String)"DELETED_LINES_COLOR");
    public static final ColorKey WHITESPACES_MODIFIED_LINES_COLOR = ColorKey.createColorKey((String)"WHITESPACES_MODIFIED_LINES_COLOR");
    public static final ColorKey BORDER_LINES_COLOR = ColorKey.createColorKey((String)"BORDER_LINES_COLOR");
    public static final ColorKey IGNORED_ADDED_LINES_BORDER_COLOR = ColorKey.createColorKey((String)"IGNORED_ADDED_LINES_BORDER_COLOR");
    public static final ColorKey IGNORED_MODIFIED_LINES_BORDER_COLOR = ColorKey.createColorKey((String)"IGNORED_MODIFIED_LINES_BORDER_COLOR");
    public static final ColorKey IGNORED_DELETED_LINES_BORDER_COLOR = ColorKey.createColorKey((String)"IGNORED_DELETED_LINES_BORDER_COLOR");
    public static final ColorKey CHANGED_LINES_POPUP = ColorKey.createColorKey((String)"CHANGED_LINES_POPUP");
    public static final ColorKey DIFF_BLOCK_AREA_HIGHLIGHT_MARKER = ColorKey.createColorKeyWithFallback((String)"DIFF_BLOCK_AREA_HIGHLIGHT_MARKER", (ColorKey)DELETED_LINES_COLOR);
    public static final TextAttributesKey INJECTED_LANGUAGE_FRAGMENT = TextAttributesKey.createTextAttributesKey((String)"INJECTED_LANGUAGE_FRAGMENT");
    public static final TextAttributesKey BREADCRUMBS_DEFAULT = TextAttributesKey.createTextAttributesKey((String)"BREADCRUMBS_DEFAULT");
    public static final TextAttributesKey BREADCRUMBS_HOVERED = TextAttributesKey.createTextAttributesKey((String)"BREADCRUMBS_HOVERED");
    public static final TextAttributesKey BREADCRUMBS_CURRENT = TextAttributesKey.createTextAttributesKey((String)"BREADCRUMBS_CURRENT");
    public static final TextAttributesKey BREADCRUMBS_INACTIVE = TextAttributesKey.createTextAttributesKey((String)"BREADCRUMBS_INACTIVE");
    public static final ColorKey BREADCRUMBS_BORDER_COLOR = ColorKey.createColorKeyWithFallback((String)"BREADCRUMBS_BORDER_COLOR", (ColorKey)INDENT_GUIDE_COLOR);
    public static final TextAttributesKey CODE_LENS_BORDER_COLOR = TextAttributesKey.createTextAttributesKey((String)"CODE_LENS_BORDER_COLOR");
    public static final ColorKey VISUAL_INDENT_GUIDE_COLOR = ColorKey.createColorKey((String)"VISUAL_INDENT_GUIDE");
    public static final ColorKey DOCUMENTATION_COLOR = ColorKey.createColorKey((String)"DOCUMENTATION_COLOR");
    public static final ColorKey PREVIEW_BACKGROUND = ColorKey.createColorKey((String)"PREVIEW_BACKGROUND");
    public static final ColorKey PREVIEW_BORDER_COLOR = ColorKey.createColorKeyWithFallback((String)"PREVIEW_BORDER_COLOR", (ColorKey)INDENT_GUIDE_COLOR);
    public static final ColorKey STICKY_LINES_BACKGROUND = ColorKey.createColorKey((String)"STICKY_LINES_BACKGROUND");
    public static final ColorKey STICKY_LINES_HOVERED_COLOR = ColorKey.createColorKeyWithFallback((String)"STICKY_LINES_HOVERED_COLOR", (ColorKey)CARET_ROW_COLOR);
    public static final ColorKey STICKY_LINES_BORDER_COLOR = ColorKey.createColorKeyWithFallback((String)"STICKY_LINES_BORDER_COLOR", (ColorKey)RIGHT_MARGIN_COLOR);

    @NotNull
    public static TextAttributesKey createInjectedLanguageFragmentKey(@Nullable Language language) {
        Stack languages = new Stack();
        while (language != null && language != Language.ANY) {
            languages.push((Object)language);
            language = language.getBaseLanguage();
        }
        TextAttributesKey currentKey = INJECTED_LANGUAGE_FRAGMENT;
        while (!languages.empty()) {
            Language current = (Language)languages.pop();
            currentKey = TextAttributesKey.createTextAttributesKey((String)(current.getID() + ":INJECTED_LANGUAGE_FRAGMENT"), (TextAttributesKey)currentKey);
        }
        TextAttributesKey textAttributesKey = currentKey;
        if (textAttributesKey == null) {
            EditorColors.$$$reportNull$$$0(0);
        }
        return textAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/EditorColors", "createInjectedLanguageFragmentKey"));
    }

    public static final class GlobalScheme {
        @Nullable
        public static Color getColor(@NotNull ColorKey key) {
            if (key == null) {
                GlobalScheme.$$$reportNull$$$0(0);
            }
            return EditorColorsManager.getInstance().getGlobalScheme().getColor(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/EditorColors$GlobalScheme", "getColor"));
        }
    }
}

