/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.CompressingLayoutStrategy;
import com.intellij.openapi.actionSystem.toolbarLayout.Kind;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a*\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a0\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a8\u0010\u0010\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a=\u0010\u0015\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\u001a\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"getNonCompressibleWidth", "", "component", "Ljava/awt/Component;", "collectResizableComponents", "", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "kind", "Lcom/intellij/openapi/actionSystem/toolbarLayout/Kind;", "getKind", "(Ljava/awt/Component;)Lcom/intellij/openapi/actionSystem/toolbarLayout/Kind;", "calculateResizableComponentWidths", "", "availableWidth", "components", "calculateComponentWidths", "resizableComponentWidths", "", "result", "", "calculateComponentSizes", "", "componentWidths", "bounds", "Ljava/awt/Rectangle;", "([Ljava/awt/Component;Ljava/util/Map;Ljava/util/List;)V", "layoutComponents", "toolbarComponent", "Ljavax/swing/JComponent;", "rightAlignComponents", "intellij.platform.editor.ui"})
@SourceDebugExtension(value={"SMAP\nCompressingLayoutStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressingLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/CompressingLayoutStrategyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1285#2,2:244\n1299#2,4:246\n1285#2,2:250\n1299#2,4:252\n774#2:256\n865#2,2:257\n*S KotlinDebug\n*F\n+ 1 CompressingLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/CompressingLayoutStrategyKt\n*L\n145#1:244,2\n145#1:246,4\n150#1:250,2\n150#1:252,4\n157#1:256\n157#1:257,2\n*E\n"})
public final class CompressingLayoutStrategyKt {
    private static final int getNonCompressibleWidth(Component component) {
        if (!component.isVisible()) {
            return 0;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[CompressingLayoutStrategyKt.getKind(component).ordinal()]) {
            case 1 -> {
                void var1_1;
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                (JComponent)component;
                int result = ((JComponent)component).getInsets().left + ((JComponent)component).getInsets().right;
                Component[] v0 = ((JComponent)component).getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getComponents(...)");
                for (Component component : v0) {
                    Intrinsics.checkNotNull((Object)component);
                    result += CompressingLayoutStrategyKt.getNonCompressibleWidth(component);
                }
                yield var1_1;
            }
            case 2 -> component.getPreferredSize().width;
            case 3 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final List<Component> collectResizableComponents(ActionToolbar toolbar) {
        block6: {
            block5: {
                if (!toolbar.getComponent().isVisible()) break block5;
                JComponent jComponent = toolbar.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                if (CompressingLayoutStrategyKt.getKind(jComponent) == Kind.RESIZABLE_TOOLBAR) break block6;
            }
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        Component[] componentArray = toolbar.getComponent().getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            if (!component.isVisible()) continue;
            if (component instanceof ActionToolbar) {
                CollectionsKt.addAll((Collection)result, (Iterable)CompressingLayoutStrategyKt.collectResizableComponents((ActionToolbar)((Object)component)));
                continue;
            }
            Intrinsics.checkNotNull((Object)component);
            if (CompressingLayoutStrategyKt.getKind(component) != Kind.RESIZABLE_COMPONENT) continue;
            ((Collection)result).add(component);
        }
        return result;
    }

    private static final Kind getKind(Component $this$kind) {
        return !$this$kind.isVisible() ? Kind.NON_RESIZABLE : ($this$kind instanceof ActionToolbar ? (((ActionToolbar)((Object)$this$kind)).getLayoutStrategy() instanceof CompressingLayoutStrategy ? Kind.RESIZABLE_TOOLBAR : Kind.NON_RESIZABLE) : ($this$kind.getMinimumSize().width < $this$kind.getPreferredSize().width ? Kind.RESIZABLE_COMPONENT : Kind.NON_RESIZABLE));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Component, Integer> calculateResizableComponentWidths(int availableWidth, List<? extends Component> components) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateWithTo$iv$iv;
        Integer n;
        Object object;
        Object object2;
        void $this$associateWithTo$iv$iv2;
        Iterable $this$associateWith$iv = components;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void it;
            Component component = (Component)element$iv$iv;
            object2 = element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            n = it.getPreferredSize().width;
            object.put(object2, n);
        }
        Object preferredWidths = destination$iv$iv;
        if (availableWidth >= CollectionsKt.sumOfInt((Iterable)preferredWidths.values())) {
            return preferredWidths;
        }
        Iterable $this$associateWith$iv2 = components;
        boolean $i$f$associateWith2 = false;
        Object result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv2;
        Map destination$iv$iv2 = (Map)result$iv2;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Component bl = (Component)element$iv$iv;
            object2 = element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            n = it.getMinimumSize().width;
            object.put(object2, n);
        }
        Map calculatedWidths = MapsKt.toMutableMap((Map)destination$iv$iv2);
        int currentWidthSum = CollectionsKt.sumOfInt((Iterable)calculatedWidths.values());
        result$iv2 = new Function1[]{arg_0 -> CompressingLayoutStrategyKt.calculateResizableComponentWidths$lambda$2(calculatedWidths, arg_0), arg_0 -> CompressingLayoutStrategyKt.calculateResizableComponentWidths$lambda$3((Map)preferredWidths, arg_0)};
        PriorityQueue<Component> compressibleComponents = new PriorityQueue<Component>(ComparisonsKt.compareBy((Function1[])result$iv2));
        result$iv2 = components;
        object = compressibleComponents;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Component it = (Component)element$iv$iv;
            boolean bl = false;
            if (!(((Number)MapsKt.getValue((Map)calculatedWidths, (Object)it)).intValue() < ((Number)MapsKt.getValue((Map)preferredWidths, (Object)it)).intValue())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        ((AbstractQueue)object).addAll((List)destination$iv$iv3);
        while (currentWidthSum < availableWidth && !compressibleComponents.isEmpty()) {
            int n2;
            Object e = compressibleComponents.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            Component minWidthComponent = (Component)e;
            int oldWidth = ((Number)MapsKt.getValue((Map)calculatedWidths, (Object)minWidthComponent)).intValue();
            int preferredWidth = ((Number)MapsKt.getValue((Map)preferredWidths, (Object)minWidthComponent)).intValue();
            int maxAllowedWidth = oldWidth + (availableWidth - currentWidthSum);
            Component nextCompressibleComponent = (Component)compressibleComponents.peek();
            if (nextCompressibleComponent == null) {
                n2 = RangesKt.coerceAtMost((int)preferredWidth, (int)maxAllowedWidth);
            } else {
                int nextWidth = ((Number)MapsKt.getValue((Map)calculatedWidths, (Object)nextCompressibleComponent)).intValue();
                n2 = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)(nextWidth + 1), (int)maxAllowedWidth), (int)preferredWidth);
            }
            int newWidth = n2;
            calculatedWidths.put(minWidthComponent, newWidth);
            currentWidthSum += newWidth - oldWidth;
            if (newWidth >= preferredWidth) continue;
            compressibleComponents.add(minWidthComponent);
        }
        return calculatedWidths;
    }

    private static final Map<Component, Integer> calculateComponentWidths(ActionToolbar toolbar, Map<Component, Integer> resizableComponentWidths) {
        HashMap result = new HashMap();
        CompressingLayoutStrategyKt.calculateComponentWidths(result, toolbar, resizableComponentWidths);
        return result;
    }

    private static final void calculateComponentWidths(Map<Component, Integer> result, ActionToolbar toolbar, Map<Component, Integer> resizableComponentWidths) {
        if (!toolbar.getComponent().isVisible()) {
            return;
        }
        int toolbarWidth = toolbar.getComponent().getInsets().left + toolbar.getComponent().getInsets().right;
        Component[] componentArray = toolbar.getComponent().getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            if (!component.isVisible()) continue;
            Intrinsics.checkNotNull((Object)component);
            switch (WhenMappings.$EnumSwitchMapping$0[CompressingLayoutStrategyKt.getKind(component).ordinal()]) {
                case 1: {
                    CompressingLayoutStrategyKt.calculateComponentWidths(result, (ActionToolbar)((Object)component), resizableComponentWidths);
                    break;
                }
                case 3: {
                    result.put(component, (Integer)MapsKt.getValue(resizableComponentWidths, (Object)component));
                    break;
                }
                case 2: {
                    result.put(component, component.getPreferredSize().width);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            toolbarWidth += ((Number)MapsKt.getValue(result, (Object)component)).intValue();
        }
        result.put(toolbar.getComponent(), toolbarWidth);
    }

    private static final void calculateComponentSizes(Component[] components, Map<Component, Integer> componentWidths, List<? extends Rectangle> bounds) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            Component component = components[i];
            if (component.isVisible()) {
                bounds.get((int)i2).width = ((Number)MapsKt.getValue(componentWidths, (Object)component)).intValue();
                bounds.get((int)i2).height = component.getPreferredSize().height;
                continue;
            }
            bounds.get((int)i2).width = 0;
            bounds.get((int)i2).height = 0;
        }
    }

    private static final void layoutComponents(JComponent toolbarComponent, List<? extends Rectangle> bounds) {
        int toolbarHeight = toolbarComponent.getHeight();
        int minHeight = ActionToolbar.experimentalToolbarMinimumButtonSize().height;
        int x = toolbarComponent.getInsets().left;
        for (Rectangle rectangle : bounds) {
            rectangle.height = RangesKt.coerceAtLeast((int)rectangle.height, (int)minHeight);
            rectangle.x = x;
            rectangle.y = (toolbarHeight - rectangle.height) / 2;
            x += rectangle.width;
        }
    }

    private static final void rightAlignComponents(JComponent toolbarComponent, List<? extends Rectangle> bounds) {
        int componentWidth = toolbarComponent.getWidth();
        int rightOffset = toolbarComponent.getInsets().right;
        int n = ((Collection)bounds).size() + -1;
        if (0 <= n) {
            do {
                Component child;
                int i = n--;
                Intrinsics.checkNotNullExpressionValue((Object)toolbarComponent.getComponent(i), (String)"getComponent(...)");
                if (!(child instanceof JComponent) || !Intrinsics.areEqual((Object)((JComponent)child).getClientProperty("RIGHT_ALIGN"), (Object)true)) continue;
                bounds.get((int)i).x = componentWidth - (rightOffset += bounds.get((int)i).width);
            } while (0 <= n);
        }
    }

    private static final Comparable calculateResizableComponentWidths$lambda$2(Map $calculatedWidths, Component it) {
        return (Comparable)MapsKt.getValue((Map)$calculatedWidths, (Object)it);
    }

    private static final Comparable calculateResizableComponentWidths$lambda$3(Map $preferredWidths, Component it) {
        return Integer.valueOf(-((Number)MapsKt.getValue((Map)$preferredWidths, (Object)it)).intValue());
    }

    public static final /* synthetic */ int access$getNonCompressibleWidth(Component component) {
        return CompressingLayoutStrategyKt.getNonCompressibleWidth(component);
    }

    public static final /* synthetic */ List access$collectResizableComponents(ActionToolbar toolbar) {
        return CompressingLayoutStrategyKt.collectResizableComponents(toolbar);
    }

    public static final /* synthetic */ Map access$calculateResizableComponentWidths(int availableWidth, List components) {
        return CompressingLayoutStrategyKt.calculateResizableComponentWidths(availableWidth, components);
    }

    public static final /* synthetic */ Map access$calculateComponentWidths(ActionToolbar toolbar, Map resizableComponentWidths) {
        return CompressingLayoutStrategyKt.calculateComponentWidths(toolbar, resizableComponentWidths);
    }

    public static final /* synthetic */ void access$calculateComponentSizes(Component[] components, Map componentWidths, List bounds) {
        CompressingLayoutStrategyKt.calculateComponentSizes(components, componentWidths, bounds);
    }

    public static final /* synthetic */ void access$layoutComponents(JComponent toolbarComponent, List bounds) {
        CompressingLayoutStrategyKt.layoutComponents(toolbarComponent, bounds);
    }

    public static final /* synthetic */ void access$rightAlignComponents(JComponent toolbarComponent, List bounds) {
        CompressingLayoutStrategyKt.rightAlignComponents(toolbarComponent, bounds);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Kind.values().length];
            try {
                nArray[Kind.RESIZABLE_TOOLBAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.NON_RESIZABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Kind.RESIZABLE_COMPONENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

