/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LogicalPosition
implements Comparable<LogicalPosition> {
    public final int line;
    public final int column;
    public final boolean leansForward;

    public LogicalPosition(int line, int column) throws IllegalArgumentException {
        this(line, column, false);
    }

    public LogicalPosition(int line, int column, boolean leansForward) throws IllegalArgumentException {
        if (line < 0) {
            throw new IllegalArgumentException("line must be non negative: " + line);
        }
        if (column < 0) {
            throw new IllegalArgumentException("column must be non negative: " + column);
        }
        this.line = line;
        this.column = column;
        this.leansForward = leansForward;
    }

    @VisibleForTesting
    public int getLine() {
        return this.line;
    }

    @VisibleForTesting
    public int getColumn() {
        return this.column;
    }

    public LogicalPosition leanForward(boolean value) {
        return new LogicalPosition(this.line, this.column, value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPosition)) {
            return false;
        }
        LogicalPosition logicalPosition = (LogicalPosition)o;
        return this.column == logicalPosition.column && this.line == logicalPosition.line;
    }

    public int hashCode() {
        return 29 * this.line + this.column;
    }

    @NonNls
    public String toString() {
        return "LogicalPosition: (" + this.line + ", " + this.column + ")" + (this.leansForward ? "; leans forward" : "");
    }

    @Override
    public int compareTo(@NotNull LogicalPosition position) {
        if (position == null) {
            LogicalPosition.$$$reportNull$$$0(0);
        }
        if (this.line != position.line) {
            return this.line - position.line;
        }
        return this.column - position.column;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/LogicalPosition", "compareTo"));
    }
}

