/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface FileEditor
extends UserDataHolder,
Disposable {
    public static final FileEditor[] EMPTY_ARRAY = new FileEditor[0];
    @ApiStatus.Internal
    public static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");

    @NotNull
    public static String getPropModified() {
        return "modified";
    }

    @NotNull
    public static String getPropValid() {
        return "valid";
    }

    @NotNull
    public JComponent getComponent();

    @Nullable
    public JComponent getPreferredFocusedComponent();

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getName();

    @NotNull
    default public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            FileEditor.$$$reportNull$$$0(0);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            FileEditor.$$$reportNull$$$0(1);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState var1);

    default public void setState(@NotNull FileEditorState state, boolean exactState) {
        if (state == null) {
            FileEditor.$$$reportNull$$$0(2);
        }
        this.setState(state);
    }

    public boolean isModified();

    public boolean isValid();

    default public void selectNotify() {
    }

    default public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    public void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    @Nullable
    default public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    default public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    default public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    default public VirtualFile getFile() {
        PluginException.reportDeprecatedDefault(this.getClass(), (String)"getFile", (String)"A proper @NotNull implementation required");
        return (VirtualFile)FILE_KEY.get((UserDataHolder)this);
    }

    @NotNull
    default public @Unmodifiable @NotNull List<@NotNull VirtualFile> getFilesToRefresh() {
        VirtualFile file = this.getFile();
        List list = ContainerUtil.createMaybeSingletonList((Object)file);
        if (list == null) {
            FileEditor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    default public ActionGroup getTabActions() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

