/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ElementStatusTracker;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel,
ProvidingTreeModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final List<FileEditorPositionListener> myListeners;
    private final List<ModelListener> myModelListeners;
    private final CaretListener myEditorCaretListener;
    private Disposable myEditorCaretListenerDisposable;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(0);
        }
        this(PsiEditorUtil.findEditor((PsiElement)psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    protected TextEditorBasedStructureViewModel(Editor editor, PsiFile file) {
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myModelListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditor = editor;
        this.myPsiFile = file;
        this.myEditorCaretListener = new CaretListener(){

            @Override
            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getEditor().equals(TextEditorBasedStructureViewModel.this.myEditor)) {
                    for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                        listener.onCurrentElementChanged();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel$1", "caretPositionChanged"));
            }
        };
    }

    @Override
    public final void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(1);
        }
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            this.myEditorCaretListenerDisposable = Disposer.newDisposable();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myEditorCaretListener, this.myEditorCaretListenerDisposable);
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener);
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            Disposer.dispose((Disposable)this.myEditorCaretListenerDisposable);
            this.myEditorCaretListenerDisposable = null;
        }
    }

    @Override
    public void dispose() {
        if (this.myEditorCaretListenerDisposable != null) {
            Disposer.dispose((Disposable)this.myEditorCaretListenerDisposable);
        }
        this.myModelListeners.clear();
    }

    public void fireModelUpdate() {
        for (ModelListener listener : this.myModelListeners) {
            listener.onModelChanged();
        }
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        Object o2;
        if (this.myEditor == null) {
            return null;
        }
        PsiFile file = this.getPsiFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Object o1 = this.findAcceptableElement(file.getViewProvider().findElementAt(offset, file.getLanguage()));
        Object object = o2 = offset == 0 ? o1 : this.findAcceptableElement(file.getViewProvider().findElementAt(offset - 1, file.getLanguage()));
        if (o1 != o2 && o1 instanceof PsiElement) {
            PsiElement e2;
            PsiElement e1 = (PsiElement)o1;
            if (o2 instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)e1, (PsiElement)(e2 = (PsiElement)o2), (boolean)false)) {
                return o2;
            }
        }
        return o1;
    }

    @Override
    @NotNull
    public FileStatus getElementStatus(Object element) {
        if (this.myEditor == null || this.myPsiFile == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                TextEditorBasedStructureViewModel.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }
        if (!(element instanceof PsiElement)) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                TextEditorBasedStructureViewModel.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }
        PsiElement psiElement = (PsiElement)element;
        if (!psiElement.isValid() || psiElement.getContainingFile() != this.myPsiFile) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                TextEditorBasedStructureViewModel.$$$reportNull$$$0(5);
            }
            return fileStatus;
        }
        FileStatus fileStatus = ElementStatusTracker.getInstance(this.myPsiFile.getProject()).getElementStatus(psiElement);
        if (fileStatus == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(6);
        }
        return fileStatus;
    }

    @Nullable
    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            if (this.isSuitable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    public boolean isValid() {
        return this.myPsiFile != null && this.myPsiFile.isValid();
    }

    protected boolean isSuitable(PsiElement element) {
        Class<?>[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class<?> suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionUtil.isAssignable(suitableClass, (Class)element.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(7);
        }
        this.myModelListeners.add(modelListener);
    }

    @Override
    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(8);
        }
        this.myModelListeners.remove(modelListener);
    }

    protected Class<?> @NotNull [] getSuitableClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(9);
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public Grouper @NotNull [] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(10);
        }
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    public Sorter @NotNull [] getSorters() {
        if (Sorter.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(11);
        }
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    public Filter @NotNull [] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(12);
        }
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<NodeProvider<?>> getNodeProviders() {
        List<NodeProvider<?>> list = Collections.emptyList();
        if (list == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    public boolean isEnabled(@NotNull NodeProvider<?> provider) {
        if (provider == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(14);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/TextEditorBasedStructureViewModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelListener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/TextEditorBasedStructureViewModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addEditorPositionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorPositionListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

