/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSnapshotProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizedDataContext
implements DataContext,
UserDataHolder,
AnActionEvent.InjectedDataContextSupplier {
    public static final Object EXPLICIT_NULL = ObjectUtils.sentinel((String)"explicit.null");
    @NotNull
    private final DataContext myParent;
    @Nullable
    private final UserDataHolder myDataHolder;
    @NotNull
    private final DataContext myCustomized;

    protected CustomizedDataContext(@NotNull DataContext parent, @NotNull DataProvider provider, @Nullable UserDataHolder dataHolder) {
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            CustomizedDataContext.$$$reportNull$$$0(1);
        }
        this.myParent = parent;
        this.myDataHolder = dataHolder;
        this.myCustomized = DataManager.getInstance().customizeDataContext(this.myParent, provider);
    }

    protected CustomizedDataContext(@NotNull DataContext parent, @NotNull DataProvider provider, boolean delegateUserData) {
        UserDataHolderBase userDataHolderBase;
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            CustomizedDataContext.$$$reportNull$$$0(3);
        }
        if (delegateUserData && parent instanceof UserDataHolder) {
            UserDataHolder o = (UserDataHolder)parent;
            userDataHolderBase = o;
        } else {
            userDataHolderBase = new UserDataHolderBase();
        }
        this(parent, provider, (UserDataHolder)userDataHolderBase);
    }

    private CustomizedDataContext(@NotNull DataContext parent, @Nullable UserDataHolder dataHolder, @NotNull DataContext customized) {
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(4);
        }
        if (customized == null) {
            CustomizedDataContext.$$$reportNull$$$0(5);
        }
        this.myParent = parent;
        this.myDataHolder = dataHolder;
        this.myCustomized = customized;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    protected CustomizedDataContext(@NotNull DataContext parent, boolean delegateUserData) {
        UserDataHolderBase userDataHolderBase;
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(6);
        }
        this.myParent = parent;
        if (delegateUserData && parent instanceof UserDataHolder) {
            UserDataHolder o = (UserDataHolder)parent;
            userDataHolderBase = o;
        } else {
            userDataHolderBase = new UserDataHolderBase();
        }
        this.myDataHolder = userDataHolderBase;
        this.myCustomized = this.myParent;
    }

    @ApiStatus.NonExtendable
    @NotNull
    public DataContext getParent() {
        DataContext dataContext = this.myParent;
        if (dataContext == null) {
            CustomizedDataContext.$$$reportNull$$$0(7);
        }
        return dataContext;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.OverrideOnly
    @Nullable
    public Object getRawCustomData(@NotNull String dataId) {
        if (dataId == null) {
            CustomizedDataContext.$$$reportNull$$$0(8);
        }
        return null;
    }

    @ApiStatus.NonExtendable
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            CustomizedDataContext.$$$reportNull$$$0(9);
        }
        return this.myCustomized.getData(dataId);
    }

    @Nullable
    public final <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CustomizedDataContext.$$$reportNull$$$0(10);
        }
        return (T)(this.myDataHolder == null ? null : this.myDataHolder.getUserData(key));
    }

    public final <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CustomizedDataContext.$$$reportNull$$$0(11);
        }
        if (this.myDataHolder != null) {
            this.myDataHolder.putUserData(key, value);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final DataContext getCustomizedDelegate() {
        DataContext dataContext = this.myCustomized;
        if (dataContext == null) {
            CustomizedDataContext.$$$reportNull$$$0(12);
        }
        return dataContext;
    }

    @Override
    @NotNull
    public DataContext getInjectedDataContext() {
        DataContext customized = AnActionEvent.getInjectedDataContext(this.myCustomized);
        return customized == this.myCustomized ? this : new CustomizedDataContext(this.myParent, this.myDataHolder, customized);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static CustomizedDataContext create(@NotNull DataContext parent, @NotNull DataProvider provider) {
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            CustomizedDataContext.$$$reportNull$$$0(14);
        }
        return new CustomizedDataContext(parent, provider, true);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static DataContext withProvider(@NotNull DataContext parent, @NotNull DataProvider provider) {
        UserDataHolder o;
        UserDataHolder o2;
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(15);
        }
        if (provider == null) {
            CustomizedDataContext.$$$reportNull$$$0(16);
        }
        DataContext customized = DataManager.getInstance().customizeDataContext(parent, provider);
        UserDataHolder holder = parent instanceof UserDataHolder ? (o2 = (UserDataHolder)parent) : (customized instanceof UserDataHolder ? (o = (UserDataHolder)customized) : new UserDataHolderBase());
        return new CustomizedDataContext(parent, holder, customized);
    }

    @NotNull
    public static DataContext withSnapshot(@NotNull DataContext parent, @NotNull DataSnapshotProvider provider) {
        UserDataHolder o;
        UserDataHolder o2;
        if (parent == null) {
            CustomizedDataContext.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            CustomizedDataContext.$$$reportNull$$$0(18);
        }
        DataContext customized = DataManager.getInstance().customizeDataContext(parent, provider);
        UserDataHolder holder = parent instanceof UserDataHolder ? (o2 = (UserDataHolder)parent) : (customized instanceof UserDataHolder ? (o = (UserDataHolder)customized) : new UserDataHolderBase());
        return new CustomizedDataContext(parent, holder, customized);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customized";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/CustomizedDataContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/CustomizedDataContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizedDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRawCustomData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withProvider";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12 -> new IllegalStateException(string);
        };
    }
}

