/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorColorsManager {
    @Topic.AppLevel
    public static final Topic<EditorColorsListener> TOPIC = new Topic(EditorColorsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    @Deprecated
    @NonNls
    public static final String DEFAULT_SCHEME_NAME = "Default";

    @NonNls
    @NotNull
    public static String getDefaultSchemeName() {
        return DEFAULT_SCHEME_NAME;
    }

    @NonNls
    @NotNull
    public static String getColorSchemeFileExtension() {
        return ".icls";
    }

    public static EditorColorsManager getInstance() {
        return (EditorColorsManager)ApplicationManager.getApplication().getService(EditorColorsManager.class);
    }

    @ApiStatus.Internal
    protected EditorColorsManager() {
    }

    public abstract void addColorScheme(@NotNull EditorColorsScheme var1);

    public abstract EditorColorsScheme @NotNull [] getAllSchemes();

    public abstract void setGlobalScheme(@Nullable EditorColorsScheme var1);

    @ApiStatus.Internal
    @RequiresEdt
    public abstract void setCurrentSchemeOnLafChange(@NotNull EditorColorsScheme var1);

    @NotNull
    public abstract EditorColorsScheme getGlobalScheme();

    @Nullable
    public abstract EditorColorsScheme getActiveVisibleScheme();

    @Nullable
    public abstract EditorColorsScheme getScheme(@NotNull String var1);

    @ApiStatus.Internal
    @NotNull
    public EditorColorsScheme getDefaultScheme() {
        EditorColorsScheme result = this.getScheme(EditorColorsManager.getDefaultSchemeName());
        if (result == null) {
            result = this.getGlobalScheme();
        }
        EditorColorsScheme editorColorsScheme = result;
        if (editorColorsScheme == null) {
            EditorColorsManager.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    public abstract boolean isDefaultScheme(EditorColorsScheme var1);

    public abstract boolean isUseOnlyMonospacedFonts();

    public abstract void setUseOnlyMonospacedFonts(boolean var1);

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editorColorsScheme = this.getGlobalScheme();
        if (editorColorsScheme == null) {
            EditorColorsManager.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    public boolean isDarkEditor() {
        return ColorUtil.isDark((Color)this.getGlobalScheme().getDefaultBackground());
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorsManager.$$$reportNull$$$0(2);
        }
    }

    public void reloadKeepingActiveScheme() {
    }

    @ApiStatus.Experimental
    public abstract long getSchemeModificationCounter();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/EditorColorsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeForCurrentUITheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/EditorColorsManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemeParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

