/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ide;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.EventListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class CopyPasteManager {
    private static final Logger LOG = Logger.getInstance(CopyPasteManager.class);
    @Deprecated
    public static final Color CUT_COLOR = Gray._160;

    @NotNull
    public static Color getCutColor() {
        Color color = CUT_COLOR;
        if (color == null) {
            CopyPasteManager.$$$reportNull$$$0(0);
        }
        return color;
    }

    public static CopyPasteManager getInstance() {
        return (CopyPasteManager)ApplicationManager.getApplication().getService(CopyPasteManager.class);
    }

    @ApiStatus.Internal
    protected CopyPasteManager() {
    }

    @Deprecated
    public abstract void addContentChangedListener(@NotNull ContentChangedListener var1);

    public abstract void addContentChangedListener(@NotNull ContentChangedListener var1, @NotNull Disposable var2);

    public abstract void removeContentChangedListener(@NotNull ContentChangedListener var1);

    public abstract boolean areDataFlavorsAvailable(DataFlavor ... var1);

    @Nullable
    public abstract Transferable getContents();

    @Nullable
    public abstract <T> T getContents(@NotNull DataFlavor var1);

    public abstract Transferable @NotNull [] getAllContents();

    public abstract void setContents(@NotNull Transferable var1);

    public abstract boolean isCutElement(@Nullable Object var1);

    public abstract void stopKillRings();

    public abstract void stopKillRings(@NotNull Document var1);

    public boolean isSystemSelectionSupported() {
        return false;
    }

    @Nullable
    public Transferable getSystemSelectionContents() {
        return null;
    }

    public void setSystemSelectionContents(@NotNull Transferable content) {
        if (content == null) {
            CopyPasteManager.$$$reportNull$$$0(1);
        }
    }

    public static void copyTextToClipboard(@NotNull String text) {
        if (text == null) {
            CopyPasteManager.$$$reportNull$$$0(2);
        }
        try {
            StringSelection transferable = new StringSelection(text);
            if (ApplicationManager.getApplication() == null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
            } else {
                CopyPasteManager.getInstance().setContents(transferable);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ide/CopyPasteManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCutColor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ide/CopyPasteManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSystemSelectionContents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyTextToClipboard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface ContentChangedListener
    extends EventListener {
        public void contentChanged(@Nullable Transferable var1, Transferable var2);
    }
}

