/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.platform.core.nio.fs.FileSystemTracingListener;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider;
import com.intellij.platform.eel.impl.fs.telemetry.MeasuringFileSystemListener;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\u000bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\f\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/eel/impl/fs/GlobalEelMrfsBackendProvider;", "", "<init>", "()V", "isComputing", "Ljava/lang/ThreadLocal;", "", "install", "provider", "Lcom/intellij/platform/core/nio/fs/MultiRoutingFileSystemProvider;", "compute", "Ljava/nio/file/FileSystem;", "localFS", "sanitizedPath", "", "getCustomRoots", "", "Ljava/nio/file/Path;", "getCustomFileStores", "Ljava/nio/file/FileStore;", "intellij.platform.eel.impl"})
@VisibleForTesting
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGlobalEelMrfsBackendProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalEelMrfsBackendProvider.kt\ncom/intellij/platform/eel/impl/fs/GlobalEelMrfsBackendProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n13#2:76\n1391#3:77\n1480#3,2:78\n1586#3:80\n1661#3,3:81\n1482#3,3:84\n1391#3:87\n1480#3,5:88\n*S KotlinDebug\n*F\n+ 1 GlobalEelMrfsBackendProvider.kt\ncom/intellij/platform/eel/impl/fs/GlobalEelMrfsBackendProvider\n*L\n51#1:76\n67#1:77\n67#1:78,2\n68#1:80\n68#1:81,3\n67#1:84,3\n72#1:87\n72#1:88,5\n*E\n"})
public final class GlobalEelMrfsBackendProvider {
    @NotNull
    public static final GlobalEelMrfsBackendProvider INSTANCE = new GlobalEelMrfsBackendProvider();
    @NotNull
    private static final ThreadLocal<Unit> isComputing = new ThreadLocal();

    private GlobalEelMrfsBackendProvider() {
    }

    public final void install(@NotNull MultiRoutingFileSystemProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        provider.getTheOnlyFileSystem().setBackendProvider(this::compute, this::getCustomRoots, this::getCustomFileStores);
        if (Boolean.parseBoolean(System.getProperty("nio.mrfs.telemetry.enable", "false"))) {
            provider.setTraceListener((FileSystemTracingListener)new MeasuringFileSystemListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FileSystem compute(@NotNull FileSystem localFS, @NotNull String sanitizedPath) {
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
        if (isComputing.get() == null) {
            try {
                FileSystem nonDefaultCandidate;
                Application application;
                block10: {
                    List list;
                    ExtensionPoint extensionPoint;
                    ExtensionsArea extensionsArea;
                    isComputing.set(Unit.INSTANCE);
                    application = ApplicationManager.getApplication();
                    if (application != null && (extensionsArea = application.getExtensionArea()) != null && (extensionPoint = extensionsArea.getExtensionPointIfRegistered(MultiRoutingFileSystemBackend.EP_NAME.getName())) != null && (list = extensionPoint.getExtensionList()) != null) {
                        for (MultiRoutingFileSystemBackend backend : (Iterable)list) {
                            FileSystem fileSystem;
                            FileSystem fileSystem2;
                            boolean bl = false;
                            try {
                                fileSystem2 = backend.compute(localFS, sanitizedPath);
                            }
                            catch (Exception err) {
                                boolean $i$f$logger = false;
                                Logger logger = Logger.getInstance(GlobalEelMrfsBackendProvider.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.error(backend + " threw an error trying to handle " + sanitizedPath, (Throwable)err);
                                fileSystem2 = null;
                            }
                            if ((fileSystem = fileSystem2) == null) continue;
                            v1 = fileSystem;
                            break block10;
                        }
                        v1 = null;
                    } else {
                        v1 = nonDefaultCandidate = null;
                    }
                }
                if (nonDefaultCandidate != null) {
                    application = nonDefaultCandidate;
                    return application;
                }
            }
            finally {
                isComputing.set(null);
            }
        }
        return localFS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Path> getCustomRoots(@NotNull FileSystem localFS) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Iterable $this$flatMap$iv = MultiRoutingFileSystemBackend.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            MultiRoutingFileSystemBackend eelProvider = (MultiRoutingFileSystemBackend)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = eelProvider.getCustomRoots();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(localFS.getPath((String)it, new String[0]));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FileStore> getCustomFileStores(@NotNull FileSystem localFS) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Iterable $this$flatMap$iv = MultiRoutingFileSystemBackend.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MultiRoutingFileSystemBackend eelProvider = (MultiRoutingFileSystemBackend)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = eelProvider.getCustomFileStores(localFS);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        MultiRoutingFileSystemBackend.EP_NAME.getExtensionList();
    }
}

