/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.LocalEelApi;
import com.intellij.platform.eel.provider.EelProvider;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.LocalPosixEelApi;
import com.intellij.platform.eel.provider.LocalWindowsEelApi;
import com.intellij.util.system.OS;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0007\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0007\u001a\u0014\u0010\f\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0007\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\u0001H\u0007\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000bH\u0007\"\u001b\u0010\u0004\u001a\u00020\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"getEelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/project/Project;", "localEel", "Lcom/intellij/platform/eel/LocalEelApi;", "getLocalEel", "()Lcom/intellij/platform/eel/LocalEelApi;", "localEel$delegate", "Lkotlin/Lazy;", "upgradeBlocking", "Lcom/intellij/platform/eel/EelApi;", "toEelApiBlocking", "Lcom/intellij/platform/eel/EelMachine;", "descriptor", "systemOs", "Lcom/intellij/util/system/OS;", "intellij.platform.eel.provider"})
@JvmName(name="EelProviderUtil")
@SourceDebugExtension(value={"SMAP\nEelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/EelProviderUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,210:1\n1#2:211\n30#3,2:212\n*S KotlinDebug\n*F\n+ 1 EelProvider.kt\ncom/intellij/platform/eel/provider/EelProviderUtil\n*L\n121#1:212,2\n*E\n"})
public final class EelProviderUtil {
    @NotNull
    private static final Lazy localEel$delegate = LazyKt.lazy(EelProviderUtil::localEel_delegate$lambda$0);

    @ApiStatus.Experimental
    @NotNull
    public static final EelDescriptor getEelDescriptor(@NotNull Path $this$getEelDescriptor) {
        EelDescriptor eelDescriptor;
        EelDescriptor eelDescriptor2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getEelDescriptor, (String)"<this>");
            for (EelProvider eelProvider : (Iterable)EelProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                EelDescriptor eelDescriptor3 = eelProvider.getEelDescriptor($this$getEelDescriptor);
                if (eelDescriptor3 == null) continue;
                eelDescriptor2 = eelDescriptor3;
                break block2;
            }
            eelDescriptor2 = eelDescriptor = null;
        }
        if (eelDescriptor2 == null) {
            eelDescriptor = LocalEelDescriptor.INSTANCE;
        }
        return eelDescriptor;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelDescriptor getEelDescriptor(@NotNull Project $this$getEelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getEelDescriptor, (String)"<this>");
        String filePath = $this$getEelDescriptor.getProjectFilePath();
        if (filePath == null) {
            return LocalEelDescriptor.INSTANCE;
        }
        Path path = Path.of(filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return EelProviderUtil.getEelDescriptor(path);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final LocalEelApi getLocalEel() {
        Lazy lazy = localEel$delegate;
        return (LocalEelApi)lazy.getValue();
    }

    @Deprecated(message="Use toEelApiBlocking() instead", replaceWith=@ReplaceWith(expression="toEelApiBlocking()", imports={}))
    @ApiStatus.Internal
    @NotNull
    public static final EelApi upgradeBlocking(@NotNull EelDescriptor $this$upgradeBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$upgradeBlocking, (String)"<this>");
        return EelProviderUtil.toEelApiBlocking($this$upgradeBlocking);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelApi toEelApiBlocking(@NotNull EelMachine $this$toEelApiBlocking, @NotNull EelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelApiBlocking, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (EelApi)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelApi>, Object>($this$toEelApiBlocking, descriptor, null){
            int label;
            final /* synthetic */ EelMachine $this_toEelApiBlocking;
            final /* synthetic */ EelDescriptor $descriptor;
            {
                this.$this_toEelApiBlocking = $receiver;
                this.$descriptor = $descriptor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$this_toEelApiBlocking.toEelApi(this.$descriptor, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelApi> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelApi toEelApiBlocking(@NotNull EelDescriptor $this$toEelApiBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelApiBlocking, (String)"<this>");
        if ($this$toEelApiBlocking == LocalEelDescriptor.INSTANCE) {
            return (EelApi)EelProviderUtil.getLocalEel();
        }
        return (EelApi)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelApi>, Object>($this$toEelApiBlocking, null){
            int label;
            final /* synthetic */ EelDescriptor $this_toEelApiBlocking;
            {
                this.$this_toEelApiBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$this_toEelApiBlocking.toEelApi((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelApi> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Internal
    @NotNull
    public static final OS systemOs(@NotNull EelApi $this$systemOs) {
        OS oS;
        Intrinsics.checkNotNullParameter((Object)$this$systemOs, (String)"<this>");
        EelPlatform eelPlatform = $this$systemOs.getPlatform();
        if (eelPlatform instanceof EelPlatform.Linux) {
            oS = OS.Linux;
        } else if (eelPlatform instanceof EelPlatform.Darwin) {
            oS = OS.macOS;
        } else if (eelPlatform instanceof EelPlatform.Windows) {
            oS = OS.Windows;
        } else if (eelPlatform instanceof EelPlatform.FreeBSD) {
            oS = OS.FreeBSD;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return oS;
    }

    private static final LocalEelApi localEel_delegate$lambda$0() {
        LocalEelApi localEelApi;
        if (SystemInfo.isWindows) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<LocalWindowsEelApi> serviceClass$iv = LocalWindowsEelApi.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            localEelApi = (LocalEelApi)object;
        } else {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<LocalPosixEelApi> serviceClass$iv = LocalPosixEelApi.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            localEelApi = (LocalEelApi)object;
        }
        return localEelApi;
    }
}

