/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider.utils;

import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelChannelUtilsKt;
import externalApp.ExternalAppEntry;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/eel/provider/utils/EelExternalAppEntry;", "LexternalApp/ExternalAppEntry;", "process", "Lcom/intellij/platform/eel/EelExecApi$ExternalCliProcess;", "<init>", "(Lcom/intellij/platform/eel/EelExecApi$ExternalCliProcess;)V", "getProcess", "()Lcom/intellij/platform/eel/EelExecApi$ExternalCliProcess;", "myStderr", "Ljava/io/PrintStream;", "getMyStderr", "()Ljava/io/PrintStream;", "myStdout", "getMyStdout", "myStdin", "Ljava/io/InputStream;", "getMyStdin", "()Ljava/io/InputStream;", "getArgs", "", "", "()[Ljava/lang/String;", "getEnvironment", "", "getWorkingDirectory", "getStderr", "getStdout", "getStdin", "getExecutablePath", "Ljava/nio/file/Path;", "intellij.platform.eel.provider"})
@SourceDebugExtension(value={"SMAP\neelExternalCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 eelExternalCli.kt\ncom/intellij/platform/eel/provider/utils/EelExternalAppEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,42:1\n1#2:43\n37#3,2:44\n*S KotlinDebug\n*F\n+ 1 eelExternalCli.kt\ncom/intellij/platform/eel/provider/utils/EelExternalAppEntry\n*L\n22#1:44,2\n*E\n"})
final class EelExternalAppEntry
implements ExternalAppEntry {
    @NotNull
    private final EelExecApi.ExternalCliProcess process;
    @NotNull
    private final PrintStream myStderr;
    @NotNull
    private final PrintStream myStdout;
    @NotNull
    private final InputStream myStdin;

    public EelExternalAppEntry(@NotNull EelExecApi.ExternalCliProcess process) {
        OutputStream p0;
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.process = process;
        OutputStream outputStream = EelChannelUtilsKt.asOutputStream$default(this.process.getStderr(), null, 1, null);
        EelExternalAppEntry eelExternalAppEntry = this;
        boolean bl = false;
        eelExternalAppEntry.myStderr = new PrintStream(p0);
        p0 = EelChannelUtilsKt.asOutputStream$default(this.process.getStdout(), null, 1, null);
        eelExternalAppEntry = this;
        boolean bl2 = false;
        eelExternalAppEntry.myStdout = new PrintStream(p0);
        this.myStdin = EelChannelUtilsKt.consumeAsInputStream$default(this.process.getStdin(), null, 1, null);
    }

    @NotNull
    public final EelExecApi.ExternalCliProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final PrintStream getMyStderr() {
        return this.myStderr;
    }

    @NotNull
    public final PrintStream getMyStdout() {
        return this.myStdout;
    }

    @NotNull
    public final InputStream getMyStdin() {
        return this.myStdin;
    }

    @NotNull
    public String[] getArgs() {
        Collection $this$toTypedArray$iv = this.process.getArgs();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return this.process.getEnvironment();
    }

    @NotNull
    public String getWorkingDirectory() {
        return ((Object)EelNioBridgeServiceKt.asNioPath(this.process.getWorkingDir())).toString();
    }

    @NotNull
    public PrintStream getStderr() {
        return this.myStderr;
    }

    @NotNull
    public PrintStream getStdout() {
        return this.myStdout;
    }

    @NotNull
    public InputStream getStdin() {
        return this.myStdin;
    }

    @NotNull
    public Path getExecutablePath() {
        return EelNioBridgeServiceKt.asNioPath(this.process.getExecutableName());
    }
}

