/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider.utils;

import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.provider.utils.EelOutputChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/eel/provider/utils/InputStreamAdapterImpl;", "Ljava/io/InputStream;", "receiveChannel", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "blockingContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/intellij/platform/eel/channels/EelReceiveChannel;Lkotlin/coroutines/CoroutineContext;)V", "oneByte", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "read", "", "close", "", "available", "b", "", "off", "len", "dst", "intellij.platform.eel.provider"})
public final class InputStreamAdapterImpl
extends InputStream {
    @NotNull
    private final EelReceiveChannel receiveChannel;
    @NotNull
    private final CoroutineContext blockingContext;
    private final ByteBuffer oneByte;

    public InputStreamAdapterImpl(@NotNull EelReceiveChannel receiveChannel, @NotNull CoroutineContext blockingContext) {
        Intrinsics.checkNotNullParameter((Object)receiveChannel, (String)"receiveChannel");
        Intrinsics.checkNotNullParameter((Object)blockingContext, (String)"blockingContext");
        this.receiveChannel = receiveChannel;
        this.blockingContext = blockingContext;
        this.oneByte = ByteBuffer.allocate(1);
    }

    @Override
    public int read() {
        this.oneByte.clear();
        ByteBuffer byteBuffer = this.oneByte;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"oneByte");
        if (this.read(byteBuffer, 1) == -1) {
            return -1;
        }
        return this.oneByte.flip().get();
    }

    @Override
    public void close() {
        BuildersKt.runBlocking((CoroutineContext)this.blockingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ InputStreamAdapterImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = InputStreamAdapterImpl.access$getReceiveChannel$p(this.this$0).closeForReceive((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public int available() {
        return this.receiveChannel.available();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ByteBuffer byteBuffer = ByteBuffer.wrap(b, off, len);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return this.read(byteBuffer, len);
    }

    private final int read(ByteBuffer dst, int len) throws IOException {
        if (!dst.hasRemaining() || len == 0) {
            return 0;
        }
        block4: while (true) {
            ReadResult r2 = this.receiveChannel instanceof EelOutputChannel && ((EelOutputChannel)this.receiveChannel).available() > 0 ? ((EelOutputChannel)this.receiveChannel).receiveAvailable(dst) : (ReadResult)BuildersKt.runBlocking((CoroutineContext)this.blockingContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ReadResult>, Object>(this, dst, null){
                int label;
                final /* synthetic */ InputStreamAdapterImpl this$0;
                final /* synthetic */ ByteBuffer $dst;
                {
                    this.this$0 = $receiver;
                    this.$dst = $dst;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InputStreamAdapterImpl.access$getReceiveChannel$p(this.this$0).receive(this.$dst, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ReadResult> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            switch (WhenMappings.$EnumSwitchMapping$0[r2.ordinal()]) {
                case 1: {
                    return -1;
                }
                case 2: {
                    int bytesRead;
                    if ((bytesRead = len - dst.remaining()) <= 0) continue block4;
                    return bytesRead;
                }
            }
            break;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final /* synthetic */ EelReceiveChannel access$getReceiveChannel$p(InputStreamAdapterImpl $this) {
        return $this.receiveChannel;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadResult.values().length];
            try {
                nArray[ReadResult.EOF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadResult.NOT_EOF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

