/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel;

import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.EnvironmentVariablesOptionsImpl;
import com.intellij.platform.eel.ExecuteProcessException;
import com.intellij.platform.eel.ExecuteProcessOptionsImpl;
import com.intellij.platform.eel.GeneratedBuilder;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.path.EelPath;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/eel/EelExecApiHelpers;", "", "<init>", "()V", "EnvironmentVariables", "Execute", "SpawnProcess", "intellij.platform.eel"})
@ApiStatus.Experimental
public final class EelExecApiHelpers {
    @NotNull
    public static final EelExecApiHelpers INSTANCE = new EelExecApiHelpers();

    private EelExecApiHelpers() {
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0096@\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/eel/EelExecApiHelpers$EnvironmentVariables;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lkotlinx/coroutines/Deferred;", "", "", "owner", "Lcom/intellij/platform/eel/EelExecApi;", "<init>", "(Lcom/intellij/platform/eel/EelExecApi;)V", "onlyActual", "", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Experimental
    public static final class EnvironmentVariables
    implements OwnedBuilder<Deferred<? extends Map<String, ? extends String>>> {
        @NotNull
        private final EelExecApi owner;
        private boolean onlyActual;

        public EnvironmentVariables(@NotNull EelExecApi owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
        }

        @NotNull
        public final EnvironmentVariables onlyActual(boolean arg) {
            EnvironmentVariables environmentVariables;
            EnvironmentVariables $this$onlyActual_u24lambda_u240 = environmentVariables = this;
            boolean bl = false;
            $this$onlyActual_u24lambda_u240.onlyActual = arg;
            return environmentVariables;
        }

        @Override
        @Nullable
        public Object eelIt(@NotNull Continuation<? super Deferred<? extends Map<String, String>>> $completion) {
            return this.owner.environmentVariables(new EnvironmentVariablesOptionsImpl(this.onlyActual));
        }
    }

    @GeneratedBuilder.Result
    @Deprecated(message="Use spawnProcess instead")
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0007J\u001f\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0018\"\u00020\b\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\r\u001a\u00020\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0007J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0012\u0010\u000f\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u0015\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0007J\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/eel/EelExecApiHelpers$Execute;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/EelProcess;", "Lcom/intellij/platform/eel/EelExecApi$ExecuteProcessError;", "owner", "Lcom/intellij/platform/eel/EelExecApi;", "exe", "", "<init>", "(Lcom/intellij/platform/eel/EelExecApi;Ljava/lang/String;)V", "args", "", "env", "", "interactionOptions", "Lcom/intellij/platform/eel/EelExecApi$InteractionOptions;", "ptyOrStdErrSettings", "Lcom/intellij/platform/eel/EelExecApi$PtyOrStdErrSettings;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "workingDirectory", "Lcom/intellij/platform/eel/path/EelPath;", "arg", "", "([Ljava/lang/String;)Lcom/intellij/platform/eel/EelExecApiHelpers$Execute;", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class Execute
    implements OwnedBuilder<EelResult<? extends EelProcess, ? extends EelExecApi.ExecuteProcessError>> {
        @NotNull
        private final EelExecApi owner;
        @NotNull
        private String exe;
        @NotNull
        private List<String> args;
        @NotNull
        private Map<String, String> env;
        @Nullable
        private EelExecApi.InteractionOptions interactionOptions;
        @Nullable
        private EelExecApi.PtyOrStdErrSettings ptyOrStdErrSettings;
        @Nullable
        private CoroutineScope scope;
        @Nullable
        private EelPath workingDirectory;

        public Execute(@NotNull EelExecApi owner, @NotNull String exe) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)exe, (String)"exe");
            this.owner = owner;
            this.exe = exe;
            this.args = CollectionsKt.emptyList();
            this.env = MapsKt.emptyMap();
            this.ptyOrStdErrSettings = this.interactionOptions;
        }

        @ApiStatus.Experimental
        @NotNull
        public final Execute args(@NotNull List<String> arg) {
            Execute execute2;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            Execute $this$args_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$args_u24lambda_u240.args = arg;
            return execute2;
        }

        @NotNull
        public final Execute args(String ... arg) {
            Execute execute2;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Execute $this$args_u24lambda_u241 = execute2 = this;
            boolean bl = false;
            $this$args_u24lambda_u241.args = CollectionsKt.listOf((Object[])Arrays.copyOf(arg, arg.length));
            return execute2;
        }

        @ApiStatus.Experimental
        @NotNull
        public final Execute env(@NotNull Map<String, String> arg) {
            Execute execute2;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            Execute $this$env_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$env_u24lambda_u240.env = arg;
            return execute2;
        }

        @ApiStatus.Experimental
        @NotNull
        public final Execute exe(@NotNull String arg) {
            Execute execute2;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Execute $this$exe_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$exe_u24lambda_u240.exe = arg;
            return execute2;
        }

        @ApiStatus.Experimental
        @NotNull
        public final Execute interactionOptions(@Nullable EelExecApi.InteractionOptions arg) {
            Execute execute2;
            Execute $this$interactionOptions_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$interactionOptions_u24lambda_u240.interactionOptions = arg;
            return execute2;
        }

        @Deprecated(message="Switch to interactionOptions", replaceWith=@ReplaceWith(expression="interactionOptions", imports={}))
        @ApiStatus.Internal
        @NotNull
        public final Execute ptyOrStdErrSettings(@Nullable EelExecApi.PtyOrStdErrSettings arg) {
            Execute execute2;
            Execute $this$ptyOrStdErrSettings_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$ptyOrStdErrSettings_u24lambda_u240.ptyOrStdErrSettings = arg;
            return execute2;
        }

        @NotNull
        public final Execute scope(@Nullable CoroutineScope arg) {
            Execute execute2;
            Execute $this$scope_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$scope_u24lambda_u240.scope = arg;
            return execute2;
        }

        @ApiStatus.Experimental
        @NotNull
        public final Execute workingDirectory(@Nullable EelPath arg) {
            Execute execute2;
            Execute $this$workingDirectory_u24lambda_u240 = execute2 = this;
            boolean bl = false;
            $this$workingDirectory_u24lambda_u240.workingDirectory = arg;
            return execute2;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelProcess, ? extends EelExecApi.ExecuteProcessError>> $completion) {
            return this.owner.execute(new ExecuteProcessOptionsImpl(this.args, this.env, this.exe, this.interactionOptions, this.ptyOrStdErrSettings, this.scope, this.workingDirectory), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fH\u0007J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0012\u0010\r\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012J\u0012\u0010\u0013\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0007J\u000e\u0010\u0018\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/eel/EelExecApiHelpers$SpawnProcess;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelProcess;", "owner", "Lcom/intellij/platform/eel/EelExecApi;", "exe", "", "<init>", "(Lcom/intellij/platform/eel/EelExecApi;Ljava/lang/String;)V", "args", "", "env", "", "interactionOptions", "Lcom/intellij/platform/eel/EelExecApi$InteractionOptions;", "ptyOrStdErrSettings", "Lcom/intellij/platform/eel/EelExecApi$PtyOrStdErrSettings;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "workingDirectory", "Lcom/intellij/platform/eel/path/EelPath;", "arg", "", "([Ljava/lang/String;)Lcom/intellij/platform/eel/EelExecApiHelpers$SpawnProcess;", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Experimental
    public static final class SpawnProcess
    implements OwnedBuilder<EelProcess> {
        @NotNull
        private final EelExecApi owner;
        @NotNull
        private String exe;
        @NotNull
        private List<String> args;
        @NotNull
        private Map<String, String> env;
        @Nullable
        private EelExecApi.InteractionOptions interactionOptions;
        @Nullable
        private EelExecApi.PtyOrStdErrSettings ptyOrStdErrSettings;
        @Nullable
        private CoroutineScope scope;
        @Nullable
        private EelPath workingDirectory;

        public SpawnProcess(@NotNull EelExecApi owner, @NotNull String exe) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)exe, (String)"exe");
            this.owner = owner;
            this.exe = exe;
            this.args = CollectionsKt.emptyList();
            this.env = MapsKt.emptyMap();
            this.ptyOrStdErrSettings = this.interactionOptions;
        }

        @ApiStatus.Experimental
        @NotNull
        public final SpawnProcess args(@NotNull List<String> arg) {
            SpawnProcess spawnProcess;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            SpawnProcess $this$args_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$args_u24lambda_u240.args = arg;
            return spawnProcess;
        }

        @NotNull
        public final SpawnProcess args(String ... arg) {
            SpawnProcess spawnProcess;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            SpawnProcess $this$args_u24lambda_u241 = spawnProcess = this;
            boolean bl = false;
            $this$args_u24lambda_u241.args = CollectionsKt.listOf((Object[])Arrays.copyOf(arg, arg.length));
            return spawnProcess;
        }

        @ApiStatus.Experimental
        @NotNull
        public final SpawnProcess env(@NotNull Map<String, String> arg) {
            SpawnProcess spawnProcess;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            SpawnProcess $this$env_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$env_u24lambda_u240.env = arg;
            return spawnProcess;
        }

        @ApiStatus.Experimental
        @NotNull
        public final SpawnProcess exe(@NotNull String arg) {
            SpawnProcess spawnProcess;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            SpawnProcess $this$exe_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$exe_u24lambda_u240.exe = arg;
            return spawnProcess;
        }

        @ApiStatus.Experimental
        @NotNull
        public final SpawnProcess interactionOptions(@Nullable EelExecApi.InteractionOptions arg) {
            SpawnProcess spawnProcess;
            SpawnProcess $this$interactionOptions_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$interactionOptions_u24lambda_u240.interactionOptions = arg;
            return spawnProcess;
        }

        @Deprecated(message="Switch to interactionOptions", replaceWith=@ReplaceWith(expression="interactionOptions", imports={}))
        @ApiStatus.Internal
        @NotNull
        public final SpawnProcess ptyOrStdErrSettings(@Nullable EelExecApi.PtyOrStdErrSettings arg) {
            SpawnProcess spawnProcess;
            SpawnProcess $this$ptyOrStdErrSettings_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$ptyOrStdErrSettings_u24lambda_u240.ptyOrStdErrSettings = arg;
            return spawnProcess;
        }

        @NotNull
        public final SpawnProcess scope(@Nullable CoroutineScope arg) {
            SpawnProcess spawnProcess;
            SpawnProcess $this$scope_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$scope_u24lambda_u240.scope = arg;
            return spawnProcess;
        }

        @ApiStatus.Experimental
        @NotNull
        public final SpawnProcess workingDirectory(@Nullable EelPath arg) {
            SpawnProcess spawnProcess;
            SpawnProcess $this$workingDirectory_u24lambda_u240 = spawnProcess = this;
            boolean bl = false;
            $this$workingDirectory_u24lambda_u240.workingDirectory = arg;
            return spawnProcess;
        }

        @Override
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelProcess> $completion) throws ExecuteProcessException {
            return this.owner.spawnProcess(new ExecuteProcessOptionsImpl(this.args, this.env, this.exe, this.interactionOptions, this.ptyOrStdErrSettings, this.scope, this.workingDirectory), $completion);
        }
    }
}

