// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.ListDirectoryWithAttrsArgs
import com.intellij.platform.eel.fs.EelFileSystemApi.SymlinkPolicy
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Internal
class ListDirectoryWithAttrsArgsBuilder(
  private var path: EelPath,
) {
  private var symlinkPolicy: SymlinkPolicy = SymlinkPolicy.DO_NOT_RESOLVE

  fun path(arg: EelPath): ListDirectoryWithAttrsArgsBuilder = apply {
    this.path = arg
  }

  fun symlinkPolicy(arg: SymlinkPolicy): ListDirectoryWithAttrsArgsBuilder = apply {
    this.symlinkPolicy = arg
  }

  fun doNotResolve(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(SymlinkPolicy.DO_NOT_RESOLVE)

  fun justResolve(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(SymlinkPolicy.JUST_RESOLVE)

  fun resolveAndFollow(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(SymlinkPolicy.RESOLVE_AND_FOLLOW)

  fun build(): ListDirectoryWithAttrsArgs =
    ListDirectoryWithAttrsArgsImpl(
      path = path,
      symlinkPolicy = symlinkPolicy,
    )
}

@GeneratedBuilder.Result
internal class ListDirectoryWithAttrsArgsImpl(
  override val path: EelPath,
  override val symlinkPolicy: SymlinkPolicy,
) : ListDirectoryWithAttrsArgs