// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.MoveArgs
import com.intellij.platform.eel.fs.EelFileSystemApi.ReplaceExistingDuringMove
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Internal
class MoveArgsBuilder(
  private var source: EelPath,
  private var target: EelPath,
) {
  private var followLinks: Boolean = false

  private var replaceExisting: ReplaceExistingDuringMove = ReplaceExistingDuringMove.REPLACE_EVERYTHING

  fun followLinks(arg: Boolean): MoveArgsBuilder = apply {
    this.followLinks = arg
  }

  fun replaceExisting(arg: ReplaceExistingDuringMove): MoveArgsBuilder = apply {
    this.replaceExisting = arg
  }

  fun doNotReplace(): MoveArgsBuilder =
    replaceExisting(ReplaceExistingDuringMove.DO_NOT_REPLACE)

  fun doNotReplaceDirectories(): MoveArgsBuilder =
    replaceExisting(ReplaceExistingDuringMove.DO_NOT_REPLACE_DIRECTORIES)

  fun replaceEverything(): MoveArgsBuilder =
    replaceExisting(ReplaceExistingDuringMove.REPLACE_EVERYTHING)

  fun source(arg: EelPath): MoveArgsBuilder = apply {
    this.source = arg
  }

  fun target(arg: EelPath): MoveArgsBuilder = apply {
    this.target = arg
  }

  fun build(): MoveArgs =
    MoveArgsImpl(
      followLinks = followLinks,
      replaceExisting = replaceExisting,
      source = source,
      target = target,
    )
}

@GeneratedBuilder.Result
internal class MoveArgsImpl(
  override val followLinks: Boolean,
  override val replaceExisting: ReplaceExistingDuringMove,
  override val source: EelPath,
  override val target: EelPath,
) : MoveArgs