// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.EelResult
import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.OwnedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.StatError
import com.intellij.platform.eel.fs.EelFileSystemApi.SymlinkPolicy
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus
import org.jetbrains.annotations.CheckReturnValue


@GeneratedBuilder.Result
@ApiStatus.Internal
fun EelFileSystemWindowsApi.listDirectoryWithAttrs(
  path: EelPath,
): EelFileSystemWindowsApiHelpers.ListDirectoryWithAttrs =
  EelFileSystemWindowsApiHelpers.ListDirectoryWithAttrs(
    owner = this,
    path = path,
  )

@GeneratedBuilder.Result
@ApiStatus.Internal
fun EelFileSystemWindowsApi.stat(
  path: EelPath,
): EelFileSystemWindowsApiHelpers.Stat =
  EelFileSystemWindowsApiHelpers.Stat(
    owner = this,
    path = path,
  )

@ApiStatus.Internal
object EelFileSystemWindowsApiHelpers {
  /**
   * Create it via [com.intellij.platform.eel.fs.EelFileSystemWindowsApi.listDirectoryWithAttrs].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Internal
  class ListDirectoryWithAttrs(
    private val owner: EelFileSystemWindowsApi,
    private var path: EelPath,
  ) : OwnedBuilder<EelResult<Collection<Pair<String, EelWindowsFileInfo>>, EelFileSystemApi.ListDirectoryError>> {
    private var symlinkPolicy: SymlinkPolicy = SymlinkPolicy.DO_NOT_RESOLVE

    fun path(arg: EelPath): ListDirectoryWithAttrs = apply {
      this.path = arg
    }

    fun symlinkPolicy(arg: SymlinkPolicy): ListDirectoryWithAttrs = apply {
      this.symlinkPolicy = arg
    }

    /**
     * Leaves symlinks unresolved.
     * This option makes the operation a bit more efficient if it is not interested in symlinks.
     */
    fun doNotResolve(): ListDirectoryWithAttrs =
      symlinkPolicy(SymlinkPolicy.DO_NOT_RESOLVE)

    /**
     * Resolves a symlink and returns the information about the target of the symlink,
     * But does not perform anything on the target of the symlink itself.
     */
    fun justResolve(): ListDirectoryWithAttrs =
      symlinkPolicy(SymlinkPolicy.JUST_RESOLVE)

    /**
     * Resolves a symlink, follows it, and performs the required operation on target.
     */
    fun resolveAndFollow(): ListDirectoryWithAttrs =
      symlinkPolicy(SymlinkPolicy.RESOLVE_AND_FOLLOW)

    /**
     * Complete the builder and call [com.intellij.platform.eel.fs.EelFileSystemWindowsApi.listDirectoryWithAttrs]
     * with an instance of [com.intellij.platform.eel.fs.EelFileSystemApi.ListDirectoryWithAttrsArgs].
     */
    @CheckReturnValue
    override suspend fun eelIt(): EelResult<Collection<Pair<String, EelWindowsFileInfo>>, EelFileSystemApi.ListDirectoryError> =
      owner.listDirectoryWithAttrs(
        ListDirectoryWithAttrsArgsImpl(
          path = path,
          symlinkPolicy = symlinkPolicy,
        )
      )
  }

  /**
   * Create it via [com.intellij.platform.eel.fs.EelFileSystemWindowsApi.stat].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Internal
  class Stat(
    private val owner: EelFileSystemWindowsApi,
    private var path: EelPath,
  ) : OwnedBuilder<EelResult<EelWindowsFileInfo, StatError>> {
    private var symlinkPolicy: SymlinkPolicy = SymlinkPolicy.DO_NOT_RESOLVE

    fun path(arg: EelPath): Stat = apply {
      this.path = arg
    }

    fun symlinkPolicy(arg: SymlinkPolicy): Stat = apply {
      this.symlinkPolicy = arg
    }

    /**
     * Leaves symlinks unresolved.
     * This option makes the operation a bit more efficient if it is not interested in symlinks.
     */
    fun doNotResolve(): Stat =
      symlinkPolicy(SymlinkPolicy.DO_NOT_RESOLVE)

    /**
     * Resolves a symlink and returns the information about the target of the symlink,
     * But does not perform anything on the target of the symlink itself.
     */
    fun justResolve(): Stat =
      symlinkPolicy(SymlinkPolicy.JUST_RESOLVE)

    /**
     * Resolves a symlink, follows it, and performs the required operation on target.
     */
    fun resolveAndFollow(): Stat =
      symlinkPolicy(SymlinkPolicy.RESOLVE_AND_FOLLOW)

    /**
     * Complete the builder and call [com.intellij.platform.eel.fs.EelFileSystemWindowsApi.stat]
     * with an instance of [com.intellij.platform.eel.fs.EelFileSystemApi.StatArgs].
     */
    @CheckReturnValue
    override suspend fun eelIt(): EelResult<EelWindowsFileInfo, StatError> =
      owner.stat(
        StatArgsImpl(
          path = path,
          symlinkPolicy = symlinkPolicy,
        )
      )
  }
}