// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelExecApi.ExecuteProcessOptions
import com.intellij.platform.eel.path.EelPath
import kotlinx.coroutines.CoroutineScope
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Experimental
class ExecuteProcessOptionsBuilder(
  /**
   * An **absolute** path to the executable.
   * TODO Or do relative paths also work?
   *
   * All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
   * [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
   */
  private var exe: String,
) {
  private var args: List<String> = listOf()

  private var env: Map<String, String> = mapOf()

  private var interactionOptions: EelExecApi.InteractionOptions? = null

  private var ptyOrStdErrSettings: EelExecApi.PtyOrStdErrSettings? = interactionOptions

  private var scope: CoroutineScope? = null

  private var workingDirectory: EelPath? = null

  @ApiStatus.Experimental
  fun args(arg: List<String>): ExecuteProcessOptionsBuilder = apply {
    this.args = arg
  }

  fun args(vararg arg: String): ExecuteProcessOptionsBuilder = apply {
    this.args = listOf(*arg)
  }

  /**
   * By default, environment is always inherited, which may be unwanted. [ExecuteProcessOptions.env] allows
   * to alter some environment variables, it doesn't clear the variables from the parent. When the process should be started in an
   * environment like in a terminal, the response of [fetchLoginShellEnvVariables] should be put into [ExecuteProcessOptions.env].
   */
  @ApiStatus.Experimental
  fun env(arg: Map<String, String>): ExecuteProcessOptionsBuilder = apply {
    this.env = arg
  }

  /**
   * An **absolute** path to the executable.
   * TODO Or do relative paths also work?
   *
   * All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
   * [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
   */
  @ApiStatus.Experimental
  fun exe(arg: String): ExecuteProcessOptionsBuilder = apply {
    this.exe = arg
  }

  /**
   * When set pty, be sure to accept esc codes for a terminal you are emulating.
   * This terminal should also be set in `TERM` environment variable, so setting it in [env] worth doing.
   * If not set, `xterm` will be used as a most popular one.
   *
   * See `termcap(2)`, `terminfo(2)`, `ncurses(3X)` and ISBN `0937175226`.
   */
  @ApiStatus.Experimental
  fun interactionOptions(arg: EelExecApi.InteractionOptions?): ExecuteProcessOptionsBuilder = apply {
    this.interactionOptions = arg
  }

  @Deprecated("Switch to interactionOptions", replaceWith = ReplaceWith("interactionOptions"))
  @ApiStatus.Internal
  fun ptyOrStdErrSettings(arg: EelExecApi.PtyOrStdErrSettings?): ExecuteProcessOptionsBuilder = apply {
    this.ptyOrStdErrSettings = arg
  }

  /**
   * Scope this process is bound to. Once scope dies -- this process dies as well.
   */
  fun scope(arg: CoroutineScope?): ExecuteProcessOptionsBuilder = apply {
    this.scope = arg
  }

  /**
   * All argument, all paths, should be valid for the remote machine. F.i., if the IDE runs on Windows, but IJent runs on Linux,
   * [ExecuteProcessOptions.workingDirectory] is the path on the Linux host. There's no automatic path mapping in this interface.
   */
  @ApiStatus.Experimental
  fun workingDirectory(arg: EelPath?): ExecuteProcessOptionsBuilder = apply {
    this.workingDirectory = arg
  }

  fun build(): ExecuteProcessOptions =
    ExecuteProcessOptionsImpl(
      args = args,
      env = env,
      exe = exe,
      interactionOptions = interactionOptions,
      ptyOrStdErrSettings = ptyOrStdErrSettings,
      scope = scope,
      workingDirectory = workingDirectory,
    )
}

@GeneratedBuilder.Result
internal class ExecuteProcessOptionsImpl(
  override val args: List<String>,
  override val env: Map<String, String>,
  override val exe: String,
  override val interactionOptions: EelExecApi.InteractionOptions?,
  override val ptyOrStdErrSettings: EelExecApi.PtyOrStdErrSettings?,
  override val scope: CoroutineScope?,
  override val workingDirectory: EelPath?,
) : ExecuteProcessOptions