// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelTunnelsApi.GetAcceptorForRemotePort
import org.jetbrains.annotations.ApiStatus
import kotlin.time.Duration
import kotlin.time.Duration.Companion.seconds


@GeneratedBuilder.Result
@ApiStatus.Internal
class GetAcceptorForRemotePortBuilder {
  private var configureServerSocket: ConfigurableSocket.() -> Unit = {}

  private var hostname: String = "localhost"

  private var port: UShort = 0u

  private var protocolPreference: EelIpPreference = EelIpPreference.USE_SYSTEM_DEFAULT

  private var timeout: Duration = 10.seconds

  fun configureServerSocket(arg: ConfigurableSocket.() -> Unit): GetAcceptorForRemotePortBuilder = apply {
    this.configureServerSocket = arg
  }

  @ApiStatus.Experimental
  fun hostname(arg: String): GetAcceptorForRemotePortBuilder = apply {
    this.hostname = arg
  }

  @ApiStatus.Experimental
  fun port(arg: UShort): GetAcceptorForRemotePortBuilder = apply {
    this.port = arg
  }

  /**
   * @see [Builder.preferIPv4]
   */
  @ApiStatus.Experimental
  fun protocolPreference(arg: EelIpPreference): GetAcceptorForRemotePortBuilder = apply {
    this.protocolPreference = arg
  }

  fun preferV4(): GetAcceptorForRemotePortBuilder =
    protocolPreference(EelIpPreference.PREFER_V4)

  fun preferV6(): GetAcceptorForRemotePortBuilder =
    protocolPreference(EelIpPreference.PREFER_V6)

  fun useSystemDefault(): GetAcceptorForRemotePortBuilder =
    protocolPreference(EelIpPreference.USE_SYSTEM_DEFAULT)

  /**
   * @see [Builder.connectionTimeout]
   */
  @ApiStatus.Experimental
  fun timeout(arg: Duration): GetAcceptorForRemotePortBuilder = apply {
    this.timeout = arg
  }

  fun build(): GetAcceptorForRemotePort =
    GetAcceptorForRemotePortImpl(
      configureServerSocket = configureServerSocket,
      hostname = hostname,
      port = port,
      protocolPreference = protocolPreference,
      timeout = timeout,
    )
}

@GeneratedBuilder.Result
internal class GetAcceptorForRemotePortImpl(
  override val configureServerSocket: ConfigurableSocket.() -> Unit,
  override val hostname: String,
  override val port: UShort,
  override val protocolPreference: EelIpPreference,
  override val timeout: Duration,
) : GetAcceptorForRemotePort