// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.EelError
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus

@ApiStatus.Internal
sealed interface EelFsError : EelError {
  val where: EelPath

  /**
   * This error message is generated by the IJent server application.
   * It can be written either in English or in the language of the server's locale.
   * It may contain a text returned by the remote operating system.
   */
  val message: String

  sealed interface Other : EelFsError

  sealed interface DoesNotExist : EelFsError
  sealed interface AlreadyExists : EelFsError
  sealed interface PermissionDenied : EelFsError
  sealed interface NotDirectory : EelFsError
  sealed interface NotFile : EelFsError
  sealed interface UnknownFile : EelFsError
  sealed interface ReadOnlyFileSystem : EelFsError
  sealed interface NameTooLong : EelFsError
  sealed interface NotEnoughSpace : EelFsError
  sealed interface DirNotEmpty : EelFsError
}